/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.api;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.NamedProperty;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.IDojoTypeContext;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import com.ibm.team.rtc.common.scriptengine.internal.bridge.wrapper.ObjectWrapper;
import com.ibm.team.rtc.common.scriptengine.internal.types.AbstractTypeConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.ClassProptotype;
import com.ibm.team.rtc.common.scriptengine.internal.types.FieldAccessor;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiMethodWrapperFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiUtil;
import com.ibm.team.rtc.common.scriptengine.internal.util.ExceptionHelper;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Scriptable;

public class ApiEnumConstructorFunction
extends AbstractTypeConstructorFunction {
    private static final List<Method> GETTERS;
    private static final Method COMPARE_TO;

    static {
        try {
            GETTERS = Arrays.asList(Enum.class.getMethod("name", new Class[0]), Enum.class.getMethod("ordinal", new Class[0]));
            COMPARE_TO = Enum.class.getMethod("compareTo", Enum.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ApiEnumConstructorFunction(Class<?> typeClass, IScriptEnvironment scriptEnvironment) {
        super(typeClass, scriptEnvironment);
    }

    @Override
    public String getScriptTypeName() {
        return this.fTypeClass.getName().replace('$', '.');
    }

    @Override
    public Class<?> getJavaTypeClass() {
        return this.fTypeClass;
    }

    @Override
    protected Constructor<?> findConstructor(IScriptEnvironment scriptEnvironment) {
        return null;
    }

    @Override
    protected ClassProptotype createClassPrototype(IScriptEnvironment scriptEnvironment) {
        return new ClassProptotype(this, null);
    }

    @Override
    protected void initializeClassPrototype(IScriptEnvironment scriptEnvironment) {
        int n;
        IDojoTypeContext dojoTypeContext = scriptEnvironment.adapt(IDojoTypeContext.class);
        ClassProptotype classPrototype = this.getClassPrototype();
        Set<Class<?>> typeInterfaces = ApiUtil.findNewApiInterfaces(this.fTypeClass, dojoTypeContext);
        classPrototype.setSupportedInterfaces(typeInterfaces, scriptEnvironment);
        for (Class<?> typeInterface : typeInterfaces) {
            Method[] methodArray = typeInterface.getDeclaredMethods();
            int n2 = methodArray.length;
            n = 0;
            while (n < n2) {
                Method method = methodArray[n];
                if (Modifier.isPublic(method.getModifiers())) {
                    classPrototype.defineFunction(new ApiMethodWrapperFunction(method, scriptEnvironment));
                }
                ++n;
            }
        }
        classPrototype.defineFunction(new ApiMethodWrapperFunction(COMPARE_TO, scriptEnvironment));
        for (Method getter : GETTERS) {
            classPrototype.defineProperty(new EnumLiteralPropertyAccessor(getter, scriptEnvironment));
        }
        Method valuesGetter = null;
        try {
            valuesGetter = this.fTypeClass.getMethod("values", new Class[0]);
            ValuesAccessor valuesAccessor = new ValuesAccessor(valuesGetter, scriptEnvironment);
            this.defineProperty(valuesAccessor.getPropertyName(), valuesAccessor, ValuesAccessor.GETTER, null, 5);
        }
        catch (Exception e) {
            ScriptEnginePlugin.log(e);
        }
        if (dojoTypeContext.isApiType(this.fTypeClass)) {
            AccessibleObject[] accessibleObjectArray = this.fTypeClass.getDeclaredMethods();
            n = accessibleObjectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Method method = accessibleObjectArray[n3];
                if (Modifier.isPublic(method.getModifiers())) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        if (method != valuesGetter) {
                            this.defineStaticFunction(new ApiMethodWrapperFunction(method, scriptEnvironment));
                        }
                    } else {
                        classPrototype.defineFunction(new ApiMethodWrapperFunction(method, scriptEnvironment));
                    }
                }
                ++n3;
            }
            accessibleObjectArray = this.fTypeClass.getDeclaredFields();
            n = accessibleObjectArray.length;
            n3 = 0;
            while (n3 < n) {
                AccessibleObject field = accessibleObjectArray[n3];
                if (Modifier.isPublic(((Field)field).getModifiers())) {
                    if (Modifier.isStatic(((Field)field).getModifiers())) {
                        this.defineStaticField(new FieldAccessor((Field)field, scriptEnvironment));
                    } else {
                        classPrototype.defineProperty(new FieldAccessor((Field)field, scriptEnvironment));
                    }
                }
                ++n3;
            }
        }
    }

    private static class EnumLiteralPropertyAccessor
    implements NamedProperty {
        private final String fName;
        private final Method fGetter;
        private final IScriptingHelper fScriptingHelper;

        public EnumLiteralPropertyAccessor(Method method, IScriptEnvironment scriptEnvironment) {
            this.fName = method.getName();
            this.fGetter = method;
            this.fScriptingHelper = scriptEnvironment.adapt(IScriptingHelper.class);
        }

        @Override
        public String getPropertyName() {
            return this.fName;
        }

        @Override
        public boolean isReadonly() {
            return true;
        }

        @Override
        public Object getValue(Scriptable start) {
            Assert.isLegal((boolean)(start instanceof ObjectWrapper));
            Object subject = ((ObjectWrapper)start).unwrap();
            Assert.isLegal((boolean)this.fGetter.getDeclaringClass().isInstance(subject));
            try {
                return this.fScriptingHelper.convertToScript(this.fGetter.invoke(subject, new Object[0]), this.fGetter.getReturnType());
            }
            catch (Exception e) {
                throw ExceptionHelper.handle(e);
            }
        }

        @Override
        public void setValue(Scriptable start, Object value) {
            Assert.isTrue((boolean)false);
        }
    }

    private static class ValuesAccessor
    implements NamedProperty {
        public static final Method GETTER;
        private final Method fValuesGetter;
        private final IScriptingHelper fScriptingHelper;

        static {
            try {
                GETTER = ValuesAccessor.class.getMethod("getValue", Scriptable.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ValuesAccessor(Method valuesGetter, IScriptEnvironment scriptEnvironment) {
            this.fValuesGetter = valuesGetter;
            this.fScriptingHelper = scriptEnvironment.adapt(IScriptingHelper.class);
        }

        @Override
        public String getPropertyName() {
            return this.fValuesGetter.getName();
        }

        @Override
        public boolean isReadonly() {
            return true;
        }

        @Override
        public Object getValue(Scriptable start) {
            try {
                return this.fScriptingHelper.convertToScript(this.fValuesGetter.invoke(null, new Object[0]), this.fValuesGetter.getReturnType());
            }
            catch (Exception e) {
                throw ExceptionHelper.handle(e);
            }
        }

        @Override
        public void setValue(Scriptable start, Object value) {
            Assert.isTrue((boolean)false);
        }
    }
}

