/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverter;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.NamedProperty;
import com.ibm.team.rtc.common.scriptengine.ScriptException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class FieldAccessor
implements NamedProperty {
    public static final Method GETTER;
    public static final Method SETTER;
    private final Field fField;
    private final IScriptTypeConverter fConverter;
    private final IScriptEnvironment fScriptEnvironment;

    static {
        try {
            GETTER = FieldAccessor.class.getMethod("getValue", Scriptable.class);
            SETTER = FieldAccessor.class.getMethod("setValue", Scriptable.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FieldAccessor(Field field, IScriptEnvironment scriptEnvironment) {
        this.fField = field;
        this.fConverter = scriptEnvironment.adapt(IScriptTypeConverterFactory.class).getConverter(field.getType());
        this.fScriptEnvironment = scriptEnvironment;
    }

    @Override
    public String getPropertyName() {
        return this.fField.getName();
    }

    @Override
    public boolean isReadonly() {
        return Modifier.isFinal(this.fField.getModifiers());
    }

    @Override
    public Object getValue(Scriptable start) {
        final Object subject = this.getSubject(start);
        return this.fScriptEnvironment.execute(new IScriptRunnable<Object, RuntimeException>(){

            @Override
            public Object run(Context cx, Scriptable scope) throws RuntimeException {
                try {
                    return FieldAccessor.this.fConverter.toScript(cx, scope, FieldAccessor.this.fField.get(subject));
                }
                catch (IllegalAccessException e) {
                    throw new ScriptException(e);
                }
            }
        });
    }

    @Override
    public void setValue(Scriptable start, final Object value) {
        final Object subject = this.getSubject(start);
        this.fScriptEnvironment.execute(new IScriptRunnable<Void, RuntimeException>(){

            @Override
            public Void run(Context cx, Scriptable scope) throws RuntimeException {
                try {
                    FieldAccessor.this.fField.set(subject, FieldAccessor.this.fConverter.toJava(cx, scope, value));
                    return null;
                }
                catch (IllegalAccessException e) {
                    throw new ScriptException(e);
                }
            }
        });
    }

    private Object getSubject(Scriptable start) {
        Object result = null;
        if (!Modifier.isStatic(this.fField.getModifiers())) {
            Assert.isLegal((boolean)(start instanceof Wrapper));
            result = ((Wrapper)start).unwrap();
            Assert.isLegal((boolean)this.fField.getDeclaringClass().isInstance(result));
        }
        return result;
    }
}

