/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.NamedFunction;
import com.ibm.team.rtc.common.scriptengine.ScriptException;
import com.ibm.team.rtc.common.scriptengine.internal.marshaller.IInvocationMarshaller;
import com.ibm.team.rtc.common.scriptengine.internal.marshaller.StandardMethodInvocationMarshaller;
import com.ibm.team.rtc.common.scriptengine.internal.types.IllegalInvocationTargetException;
import com.ibm.team.rtc.common.scriptengine.internal.util.ExceptionHelper;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public abstract class AbstractWrapperFunction
extends BaseFunction
implements NamedFunction {
    protected final Method fMethod;
    private final IInvocationMarshaller fMarshaller;

    public AbstractWrapperFunction(Method method, IScriptEnvironment scriptEnvironment) {
        this.fMethod = method;
        this.fMarshaller = new StandardMethodInvocationMarshaller(this.fMethod, scriptEnvironment);
        scriptEnvironment.adapt(IScriptingHelper.class).initPrototypeAndScope((Scriptable)this);
    }

    public int getArity() {
        return this.fMarshaller.getArity();
    }

    public int getLength() {
        return this.fMarshaller.getArity();
    }

    @Override
    public String getFunctionName() {
        return this.fMethod.getName();
    }

    public Object call(Context cx, Scriptable scope, Scriptable scriptThisObj, Object[] args) {
        Object thisObject = null;
        if (!Modifier.isStatic(this.fMethod.getModifiers())) {
            thisObject = this.getThisObject(scriptThisObj);
            if (!this.fMethod.getDeclaringClass().isInstance(thisObject)) {
                throw new IllegalInvocationTargetException(thisObject, this);
            }
        }
        try {
            return this.fMarshaller.convertResult(cx, scope, this.fMethod.invoke(thisObject, this.fMarshaller.convertArguments(cx, scope, args)));
        }
        catch (IllegalAccessException iae) {
            if (thisObject.getClass().isAnonymousClass() && Modifier.isPublic(this.fMethod.getModifiers())) {
                this.fMethod.setAccessible(true);
                try {
                    return this.fMarshaller.convertResult(cx, scope, this.fMethod.invoke(thisObject, this.fMarshaller.convertArguments(cx, scope, args)));
                }
                catch (Exception e) {
                    throw ExceptionHelper.handle(e);
                }
            }
            throw ExceptionHelper.handle(iae);
        }
        catch (Exception e) {
            throw ExceptionHelper.handle(e);
        }
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw new ScriptException(String.format("Function '%s' cannot be used as a constructor", this.getFunctionName()));
    }

    protected abstract Object getThisObject(Object var1);
}

