/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.scripts;

import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptTypeFeature;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.IResourceResolver;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.ITypeResolver;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import com.ibm.team.rtc.common.scriptengine.internal.scripts.DojoScriptTypeFeature;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DojoScriptTypeResolver
implements ITypeResolver,
IResourceResolver {
    private static final String DOJO_PLUGIN_ID = "org.dojotoolkit.dojo";
    private static final String DIJIT_PLUGIN_ID = "org.dojotoolkit.dijit";
    private static final String DOJOX_PLUGIN_ID = "org.dojotoolkit.dojox";
    private List<BundleInfo> fScriptBundles = new ArrayList<BundleInfo>();
    private final Map<String, IScriptTypeFeature> fScripts = new HashMap<String, IScriptTypeFeature>();

    public DojoScriptTypeResolver(Source source) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint scriptBundleExtensionPoint = extensionRegistry.getExtensionPoint(source.getExtensionPoint());
        IExtension[] scriptBundleExtensions = scriptBundleExtensionPoint.getExtensions();
        this.fScriptBundles.add(new BundleInfo(Platform.getBundle((String)DOJO_PLUGIN_ID), "dojo", "/resources"));
        if (source != Source.WebBundles) {
            Bundle dojoxBundle;
            Bundle dijitBundle = Platform.getBundle((String)DIJIT_PLUGIN_ID);
            if (dijitBundle != null) {
                this.fScriptBundles.add(new BundleInfo(dijitBundle, "dijit", "/resources"));
            }
            if ((dojoxBundle = Platform.getBundle((String)DOJOX_PLUGIN_ID)) != null) {
                this.fScriptBundles.add(new BundleInfo(dojoxBundle, "dojox", "/resources"));
            }
        }
        IExtension[] iExtensionArray = scriptBundleExtensions;
        int n = scriptBundleExtensions.length;
        int dojoxBundle = 0;
        while (dojoxBundle < n) {
            IConfigurationElement[] configurationElements;
            IExtension scriptBundleExtension = iExtensionArray[dojoxBundle];
            String namespace = scriptBundleExtension.getNamespaceIdentifier();
            String resourceLocation = "/resources";
            Bundle bundle = Platform.getBundle((String)namespace);
            IConfigurationElement[] iConfigurationElementArray = configurationElements = scriptBundleExtension.getConfigurationElements();
            int n2 = configurationElements.length;
            int n3 = 0;
            while (n3 < n2) {
                IConfigurationElement configElement = iConfigurationElementArray[n3];
                if ("alias".equals(configElement.getName()) && configElement.getAttribute("value") != null) {
                    namespace = configElement.getAttribute("value");
                }
                if ("resource".equals(configElement.getName()) && configElement.getAttribute("base-name") != null) {
                    resourceLocation = configElement.getAttribute("base-name");
                }
                ++n3;
            }
            BundleInfo bundleInfo = new BundleInfo(bundle, namespace, resourceLocation);
            if (this.includeBundle(bundleInfo)) {
                this.fScriptBundles.add(bundleInfo);
            }
            ++dojoxBundle;
        }
        Collections.sort(this.fScriptBundles, new Comparator<BundleInfo>(){

            @Override
            public int compare(BundleInfo o1, BundleInfo o2) {
                return -o1.fNamespace.compareTo(o2.fNamespace);
            }
        });
        if (ScriptEnginePlugin.TRACE_TYPE_RESOLVING) {
            StringBuilder trace = new StringBuilder();
            trace.append(String.format("Registred Script Bundles:%n", new Object[0]));
            for (BundleInfo bundleInfo : this.fScriptBundles) {
                trace.append(String.format("%s: namespace: '%s' basefolder: '%s'%n", bundleInfo.fBundle.getSymbolicName(), bundleInfo.fNamespace, bundleInfo.fBaseDirectory));
            }
            ScriptEnginePlugin.trace(trace.toString(), new Object[0]);
        }
    }

    protected boolean includeBundle(BundleInfo bundleInfo) {
        return true;
    }

    @Override
    public void initializeConversion(IScriptTypeConverterFactory converterFactory) {
    }

    @Override
    public DojoScriptTypeFeature resolve(String typeName) {
        if (this.fScripts.containsKey(typeName)) {
            return (DojoScriptTypeFeature)this.fScripts.get(typeName);
        }
        IScriptTypeFeature result = this.findScript(typeName);
        this.fScripts.put(typeName, result);
        return (DojoScriptTypeFeature)result;
    }

    @Override
    public InputStream resolveResource(String path) {
        for (BundleInfo bundleInfo : this.fScriptBundles) {
            if (!path.startsWith(bundleInfo.fNamespace.replace('.', '/'))) continue;
            String filePath = bundleInfo.fBaseDirectory;
            filePath = String.valueOf(filePath) + path.substring(bundleInfo.fNamespace.length());
            URL url = FileLocator.find((Bundle)bundleInfo.fBundle, (IPath)new Path(filePath), null);
            try {
                return url != null ? url.openStream() : null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private IScriptTypeFeature findScript(String typeName) {
        for (BundleInfo bundleInfo : this.fScriptBundles) {
            if (!typeName.startsWith(bundleInfo.fNamespace)) continue;
            String filePath = bundleInfo.fBaseDirectory;
            filePath = String.valueOf(filePath) + typeName.substring(bundleInfo.fNamespace.length()).replace('.', '/');
            filePath = String.valueOf(filePath) + ".js";
            return DojoScriptTypeFeature.create(typeName, bundleInfo.fBundle, (IPath)new Path(filePath));
        }
        return null;
    }

    protected static class BundleInfo {
        public final Bundle fBundle;
        public final String fNamespace;
        public final String fBaseDirectory;

        BundleInfo(Bundle bundle, String namespace, String baseDirectory) {
            this.fBundle = bundle;
            this.fNamespace = String.valueOf(namespace) + '.';
            if (!baseDirectory.endsWith("/")) {
                baseDirectory = String.valueOf(baseDirectory) + '/';
            }
            this.fBaseDirectory = baseDirectory;
        }
    }

    public static enum Source {
        WebBundles("net.jazz.ajax.webBundles"),
        ScriptBundles("com.ibm.team.rtc.common.scriptengine.scriptBundles");

        private final String fExtensionPoint;

        private Source(String extensionPoint) {
            this.fExtensionPoint = extensionPoint;
        }

        public String getExtensionPoint() {
            return this.fExtensionPoint;
        }
    }
}

