/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.marshaller;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverter;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.internal.marshaller.IInvocationMarshaller;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class StandardMethodInvocationMarshaller
implements IInvocationMarshaller {
    private static final IExtraParameter fgContextArgument = new IExtraParameter(){

        @Override
        public Object getValue(Context cx, Scriptable scope, Object[] args) {
            return cx;
        }
    };
    private static final IExtraParameter fgScopeArgument = new IExtraParameter(){

        @Override
        public Object getValue(Context cx, Scriptable scope, Object[] args) {
            return scope;
        }
    };
    private static final IExtraParameter fgRawArguments = new IExtraParameter(){

        @Override
        public Object getValue(Context cx, Scriptable scope, Object[] args) {
            return args;
        }
    };
    private static final IExtraParameter fgScriptEnvironmentArgument = new IExtraParameter(){

        @Override
        public Object getValue(Context cx, Scriptable scope, Object[] args) {
            return IScriptEnvironment.CURRENT.getScriptEnvironment();
        }
    };
    private static final IExtraParameter[] fgNoExtraArguments = new IExtraParameter[0];
    private static final IExtraParameter[] fgScriptRawArguments = new IExtraParameter[]{fgContextArgument, fgScopeArgument, fgRawArguments};
    private static final IExtraParameter[] fgScriptContextExtraArguments = new IExtraParameter[]{fgContextArgument, fgScopeArgument};
    private static final IExtraParameter[] fgScriptEnvironmentArguments = new IExtraParameter[]{fgScriptEnvironmentArgument};
    private final IExtraParameter[] fExtraArguments;
    private final IScriptTypeConverter[] fParameterConverters;
    private final IScriptTypeConverter fResultConverter;
    private final Class<?> fVarArgType;

    public StandardMethodInvocationMarshaller(Method method, IScriptEnvironment scriptEnvironment) {
        this(method.getParameterTypes(), method.isVarArgs(), method.getReturnType(), scriptEnvironment);
    }

    public StandardMethodInvocationMarshaller(Constructor<?> constructor, IScriptEnvironment scriptEnvironment) {
        this(constructor.getParameterTypes(), constructor.isVarArgs(), constructor.getDeclaringClass(), scriptEnvironment);
    }

    private StandardMethodInvocationMarshaller(Class<?>[] parameterTypes, boolean isVarArgs, Class<?> returnType, IScriptEnvironment scriptEnvironment) {
        IScriptTypeConverterFactory converterFactory = scriptEnvironment.adapt(IScriptTypeConverterFactory.class);
        Class<?> varArgType = null;
        int skipParameters = 0;
        if (parameterTypes.length >= 2 && Context.class.equals(parameterTypes[0]) && Scriptable.class.equals(parameterTypes[1])) {
            if (parameterTypes.length == 3 && Object[].class.equals(parameterTypes[2])) {
                skipParameters = Integer.MAX_VALUE;
                this.fExtraArguments = fgScriptRawArguments;
            } else {
                skipParameters = 2;
                this.fExtraArguments = fgScriptContextExtraArguments;
            }
        } else if (parameterTypes.length >= 1 && IScriptEnvironment.class.equals(parameterTypes[0])) {
            skipParameters = 1;
            this.fExtraArguments = fgScriptEnvironmentArguments;
        } else {
            this.fExtraArguments = fgNoExtraArguments;
        }
        this.fParameterConverters = new IScriptTypeConverter[Math.max(0, parameterTypes.length - skipParameters)];
        int i = skipParameters;
        while (i < parameterTypes.length) {
            Class<?> parameterType = parameterTypes[i];
            if (isVarArgs && i == parameterTypes.length - 1) {
                Assert.isLegal((boolean)parameterTypes[i].isArray());
                varArgType = parameterType = parameterTypes[i].getComponentType();
            }
            this.fParameterConverters[i - skipParameters] = converterFactory.getConverter(parameterType);
            ++i;
        }
        Assert.isTrue((isVarArgs == (varArgType != null) ? 1 : 0) != 0);
        this.fVarArgType = varArgType;
        this.fResultConverter = converterFactory.getConverter(returnType);
    }

    @Override
    public Object[] convertArguments(Context cx, Scriptable scope, Object[] arguments) {
        int extraArgumentsCount = this.fExtraArguments.length;
        Object[] result = new Object[extraArgumentsCount + this.fParameterConverters.length];
        int i = 0;
        while (i < extraArgumentsCount) {
            result[i] = this.fExtraArguments[i].getValue(cx, scope, arguments);
            ++i;
        }
        i = 0;
        while (i < this.fParameterConverters.length) {
            if (this.fVarArgType == null || i < this.fParameterConverters.length - 1) {
                Object argument = i < arguments.length ? arguments[i] : Undefined.instance;
                result[extraArgumentsCount + i] = this.fParameterConverters[i].toJava(cx, scope, argument);
            } else {
                Object varargs = Array.newInstance(this.fVarArgType, arguments.length - i + 1);
                int j = i;
                while (j < arguments.length) {
                    Array.set(varargs, j - i, this.fParameterConverters[i].toJava(cx, scope, arguments[j]));
                    ++j;
                }
                result[extraArgumentsCount + i] = varargs;
            }
            ++i;
        }
        return result;
    }

    @Override
    public Object convertResult(Context cx, Scriptable scope, Object result) {
        return this.fResultConverter.toScript(cx, scope, result);
    }

    @Override
    public int getArity() {
        return this.fParameterConverters.length;
    }

    private static interface IExtraParameter {
        public Object getValue(Context var1, Scriptable var2, Object[] var3);
    }
}

