/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.marshaller;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverter;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.internal.marshaller.IInvocationMarshaller;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class StandardFunctionInvocationMarshaller
implements IInvocationMarshaller {
    private final IScriptTypeConverter[] fParameterConverters;
    private final IScriptTypeConverter fResultConverter;
    private boolean fIsVarArgs;

    public StandardFunctionInvocationMarshaller(Method method, IScriptEnvironment scriptEnvironment) {
        IScriptTypeConverterFactory converterFactory = scriptEnvironment.adapt(IScriptTypeConverterFactory.class);
        this.fIsVarArgs = method.isVarArgs();
        Class<?>[] parameterTypes = method.getParameterTypes();
        this.fParameterConverters = new IScriptTypeConverter[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            Class<?> parameterType = parameterTypes[i];
            if (this.fIsVarArgs && i == parameterTypes.length - 1) {
                Assert.isLegal((boolean)parameterTypes[i].isArray());
                parameterType = parameterTypes[i].getComponentType();
            }
            this.fParameterConverters[i] = converterFactory.getConverter(parameterType);
            ++i;
        }
        this.fResultConverter = converterFactory.getConverter(method.getReturnType());
    }

    @Override
    public Object[] convertArguments(Context cx, Scriptable scope, Object[] arguments) {
        if (arguments == null) {
            return Context.emptyArgs;
        }
        int argSize = arguments.length;
        int varArgSize = 0;
        if (this.fIsVarArgs) {
            varArgSize = Array.getLength(arguments[arguments.length - 1]);
            --argSize;
        }
        Object[] result = new Object[argSize + varArgSize];
        int i = 0;
        while (i < argSize) {
            result[i] = this.fParameterConverters[i].toScript(cx, scope, arguments[i]);
            ++i;
        }
        i = 0;
        while (i < varArgSize) {
            result[argSize + i] = this.fParameterConverters[argSize].toScript(cx, scope, Array.get(arguments[argSize], i));
            ++i;
        }
        return result;
    }

    @Override
    public Object convertResult(Context cx, Scriptable scope, Object result) {
        return this.fResultConverter.toJava(cx, scope, result);
    }

    @Override
    public int getArity() {
        return this.fParameterConverters.length;
    }
}

