/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.bridge.wrapper;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptException;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import com.ibm.team.rtc.common.scriptengine.internal.marshaller.IInvocationMarshaller;
import com.ibm.team.rtc.common.scriptengine.internal.marshaller.StandardMethodInvocationMarshaller;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class SingleMethodInterfaceWrapper
extends BaseFunction
implements Wrapper {
    private final Method fMethod;
    private final IInvocationMarshaller fMarshaller;
    private final Object fSubject;

    public SingleMethodInterfaceWrapper(Scriptable scope, Object subject, Method method, IScriptEnvironment scriptEnvironment) {
        this.fSubject = subject;
        Assert.isNotNull((Object)subject);
        Assert.isNotNull((Object)method);
        this.fMethod = method;
        this.fMarshaller = new StandardMethodInvocationMarshaller(this.fMethod, scriptEnvironment);
        scriptEnvironment.adapt(IScriptingHelper.class).initPrototypeAndScope((Scriptable)this);
    }

    public Object unwrap() {
        return this.fSubject;
    }

    public int getArity() {
        return this.fMarshaller.getArity();
    }

    public int getLength() {
        return this.fMarshaller.getArity();
    }

    public String getFunctionName() {
        return this.fMethod.getName();
    }

    public Object call(Context cx, Scriptable scope, Scriptable scriptThisObj, Object[] args) {
        try {
            return this.fMarshaller.convertResult(cx, scope, this.fMethod.invoke(this.fSubject, this.fMarshaller.convertArguments(cx, scope, args)));
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RhinoException) {
                throw (RhinoException)targetException;
            }
            throw new ScriptException(e.getTargetException());
        }
        catch (Exception e) {
            ScriptEnginePlugin.log("Failed to call method", e);
            throw new ScriptException(e);
        }
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw new ScriptException(String.format("Function '%s' cannot be used as a constructor", this.getFunctionName()));
    }
}

