/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.bridge.proxy;

import com.ibm.team.rtc.common.scriptengine.IInvokeableProxy;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.internal.bridge.proxy.AbstractInvocationHandler;
import com.ibm.team.rtc.common.scriptengine.internal.marshaller.StandardFunctionInvocationMarshaller;
import com.ibm.team.rtc.common.scriptengine.internal.util.jdojo.JDojoTypeUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class FunctionInvocationHandler
extends AbstractInvocationHandler {
    private static final Method INVOKE;
    private static final Method CREATE_SCOPED_FUNCTION;
    private final Function fFunction;
    private final Method fMethod;
    private final StandardFunctionInvocationMarshaller fInvocationMarshaller;

    static {
        try {
            INVOKE = IInvokeableProxy.class.getMethod("invoke", Object[].class);
            CREATE_SCOPED_FUNCTION = IInvokeableProxy.class.getMethod("createScopedFunction", Scriptable.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FunctionInvocationHandler(IScriptEnvironment scriptEnvironment, Scriptable subject, Class<?> singleMethodInterface, Function targetFunction) {
        super(scriptEnvironment, subject);
        this.fFunction = targetFunction;
        this.fMethod = singleMethodInterface != null ? JDojoTypeUtils.findSingleMethod(singleMethodInterface) : null;
        this.fInvocationMarshaller = this.fMethod != null ? new StandardFunctionInvocationMarshaller(this.fMethod, scriptEnvironment) : null;
    }

    @Override
    protected Scriptable invokeGetProxySubject(Object thisObj, Scriptable subject, IScriptEnvironment scriptEnvironment) {
        return this.fFunction;
    }

    @Override
    protected boolean invokeEquals(Object thisObj, Scriptable subject, Object other, IScriptEnvironment scriptEnvironment) {
        return super.invokeEquals(thisObj, (Scriptable)this.fFunction, other, scriptEnvironment);
    }

    @Override
    protected int invokeHashCode(Object thisObj, Scriptable subject, IScriptEnvironment scriptEnvironment) {
        return super.invokeHashCode(thisObj, (Scriptable)this.fFunction, scriptEnvironment);
    }

    @Override
    protected Object invokeGeneric(Object thisObj, Scriptable subject, Method method, final Object[] args, IScriptEnvironment scriptEnvironment) {
        if (this.fMethod != null && this.fMethod.equals(method)) {
            return scriptEnvironment.execute(new IScriptRunnable<Object, RuntimeException>(){

                @Override
                public Object run(Context cx, Scriptable scope) throws RuntimeException {
                    return FunctionInvocationHandler.this.fInvocationMarshaller.convertResult(cx, scope, FunctionInvocationHandler.this.fFunction.call(cx, scope, FunctionInvocationHandler.this.fSubject, FunctionInvocationHandler.this.fInvocationMarshaller.convertArguments(cx, scope, args)));
                }
            });
        }
        if (INVOKE.equals(method)) {
            final StandardFunctionInvocationMarshaller invocationMarshaller = new StandardFunctionInvocationMarshaller(INVOKE, scriptEnvironment);
            return scriptEnvironment.execute(new IScriptRunnable<Object, RuntimeException>(){

                @Override
                public Object run(Context cx, Scriptable scope) throws RuntimeException {
                    return invocationMarshaller.convertResult(cx, scope, FunctionInvocationHandler.this.fFunction.call(cx, scope, FunctionInvocationHandler.this.fSubject, invocationMarshaller.convertArguments(cx, scope, args)));
                }
            });
        }
        if (CREATE_SCOPED_FUNCTION.equals(method)) {
            Class<?> proxyClass = thisObj.getClass();
            FunctionInvocationHandler invocationHandler = new FunctionInvocationHandler(scriptEnvironment, (Scriptable)args[0], this.fMethod != null ? this.fMethod.getDeclaringClass() : null, this.fFunction);
            return Proxy.newProxyInstance(proxyClass.getClassLoader(), proxyClass.getInterfaces(), (InvocationHandler)invocationHandler);
        }
        return super.invokeGeneric(thisObj, subject, method, args, scriptEnvironment);
    }
}

