/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.bridge.proxy;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import com.ibm.team.rtc.common.scriptengine.UnknownFunctionException;
import com.ibm.team.rtc.common.scriptengine.internal.marshaller.StandardFunctionInvocationMarshaller;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class AbstractInvocationHandler
implements InvocationHandler {
    private static final String EQUALS = "equals";
    private static final String HASHCODE = "hashCode";
    private static final String TOSTRING = "toString";
    private static final Method GET_PROXY_SUBJECT;
    private static final Method GET_SCRIPT_ENVIRONMENT;
    private static final Method CAST;
    private final Map<Method, MethodHandler> fMethodHandlerCache = new ConcurrentHashMap<Method, MethodHandler>();
    private final IScriptEnvironment fScriptEnvironment;
    final Scriptable fSubject;

    static {
        try {
            GET_PROXY_SUBJECT = IScriptableProxy.class.getMethod("getProxySubject", new Class[0]);
            GET_SCRIPT_ENVIRONMENT = IScriptableProxy.class.getMethod("getScriptEnvironment", new Class[0]);
            CAST = IScriptableProxy.class.getMethod("cast", Class.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractInvocationHandler(IScriptEnvironment environment, Scriptable subject) {
        this.fScriptEnvironment = environment;
        this.fSubject = subject;
    }

    @Override
    public Object invoke(Object thisObj, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        switch (methodName.charAt(0)) {
            case 'g': {
                if (GET_PROXY_SUBJECT.equals(method)) {
                    return this.invokeGetProxySubject(thisObj, this.fSubject, this.fScriptEnvironment);
                }
                if (!GET_SCRIPT_ENVIRONMENT.equals(method)) break;
                return this.invokeGetScriptEnvironment(thisObj, this.fSubject, this.fScriptEnvironment);
            }
            case 'c': {
                if (!CAST.equals(method)) break;
                return this.invokeCast(thisObj, this.fSubject, (Class)args[0], this.fScriptEnvironment);
            }
            case 'e': {
                if (!EQUALS.equals(methodName)) break;
                return this.invokeEquals(thisObj, this.fSubject, args[0], this.fScriptEnvironment);
            }
            case 'h': {
                if (!HASHCODE.equals(methodName)) break;
                return this.invokeHashCode(thisObj, this.fSubject, this.fScriptEnvironment);
            }
            case 't': {
                if (!TOSTRING.equals(methodName)) break;
                return this.invokeToString(thisObj, this.fSubject, this.fScriptEnvironment);
            }
        }
        return this.invokeGeneric(thisObj, this.fSubject, method, args, this.fScriptEnvironment);
    }

    protected Scriptable invokeGetProxySubject(Object thisObj, Scriptable subject, IScriptEnvironment scriptEnvironment) {
        return subject;
    }

    protected IScriptEnvironment invokeGetScriptEnvironment(Object thisObj, Scriptable subject, IScriptEnvironment scriptEnvironment) {
        return scriptEnvironment;
    }

    protected <T> T invokeCast(Object thisObj, final Scriptable subject, final Class<T> castType, final IScriptEnvironment scriptEnvironment) {
        if (castType.isInstance(thisObj)) {
            return castType.cast(thisObj);
        }
        return (T)scriptEnvironment.execute(new IScriptRunnable<T, RuntimeException>(){

            @Override
            public T run(Context cx, Scriptable scope) throws RuntimeException {
                IScriptTypeConverterFactory typeConverterFactory = scriptEnvironment.adapt(IScriptTypeConverterFactory.class);
                return castType.cast(typeConverterFactory.getConverter(castType).toJava(cx, scope, subject));
            }
        });
    }

    protected boolean invokeEquals(Object thisObj, Scriptable subject, Object other, IScriptEnvironment scriptEnvironment) {
        if (other instanceof IScriptableProxy) {
            other = ((IScriptableProxy)other).getProxySubject();
        }
        return subject == other;
    }

    protected int invokeHashCode(Object thisObj, Scriptable subject, IScriptEnvironment scriptEnvironment) {
        return subject.hashCode();
    }

    protected String invokeToString(Object thisObj, Scriptable subject, IScriptEnvironment scriptEnvironment) {
        return subject.toString();
    }

    protected Object invokeGeneric(Object thisObj, Scriptable subject, Method method, Object[] args, IScriptEnvironment scriptEnvironment) {
        MethodHandler methodHandler = this.fMethodHandlerCache.get(method);
        if (methodHandler == null) {
            methodHandler = new MethodHandler(scriptEnvironment, method);
            this.fMethodHandlerCache.put(method, methodHandler);
        }
        return methodHandler.invoke(scriptEnvironment, this.fSubject, args);
    }

    private static class MethodHandler {
        private final Method fMethod;
        private final StandardFunctionInvocationMarshaller fInvocationMarshaller;

        public MethodHandler(IScriptEnvironment scriptEnvironment, Method method) {
            this.fMethod = method;
            this.fInvocationMarshaller = new StandardFunctionInvocationMarshaller(this.fMethod, scriptEnvironment);
        }

        public Object invoke(IScriptEnvironment scriptEnvironment, final Scriptable subject, final Object[] args) {
            return scriptEnvironment.execute(new IScriptRunnable<Object, RuntimeException>(){

                @Override
                public Object run(Context cx, Scriptable scope) throws RuntimeException {
                    Object functionProperty = ScriptableObject.getProperty((Scriptable)subject, (String)fMethod.getName());
                    if (functionProperty instanceof Callable) {
                        return fInvocationMarshaller.convertResult(cx, scope, ((Callable)functionProperty).call(cx, scope, subject, fInvocationMarshaller.convertArguments(cx, scope, args)));
                    }
                    throw new UnknownFunctionException(fMethod.getName());
                }
            });
        }
    }
}

