/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;

class WrapperCache {
    private final WeakIdentityHashMap<Class<?>, WeakIdentityWeakValueHashMap<Object, Object>> fWrapperCache = new WeakIdentityHashMap();

    WrapperCache() {
    }

    public synchronized Object get(Object source, Class<?> typeConversion) {
        WeakIdentityWeakValueHashMap<Object, Object> objectCache = this.fWrapperCache.get(typeConversion);
        if (objectCache != null) {
            return objectCache.get(source);
        }
        return null;
    }

    public synchronized void put(Object source, Class<?> typeConversion, Object wrapper) {
        WeakIdentityWeakValueHashMap<Object, Object> objectCache = this.fWrapperCache.get(typeConversion);
        if (objectCache == null) {
            objectCache = new WeakIdentityWeakValueHashMap();
            this.fWrapperCache.put(typeConversion, objectCache);
        }
        objectCache.put(source, wrapper);
    }

    public void cleanup() {
        WrapperCache.purge(((WeakIdentityHashMap)this.fWrapperCache).fMap, ((WeakIdentityHashMap)this.fWrapperCache).fQueue);
        for (WeakIdentityWeakValueHashMap map : ((WeakIdentityHashMap)this.fWrapperCache).fMap.values()) {
            WrapperCache.purge(map.fMap, map.fQueue);
            Iterator iterator = map.fMap.entrySet().iterator();
            while (iterator.hasNext()) {
                if (((WeakReference)iterator.next().getValue()).get() != null) continue;
                iterator.remove();
            }
        }
    }

    private static <K> void purge(HashMap<IdentityReference<K>, ?> map, ReferenceQueue<K> queue) {
        Reference<K> obsolete;
        while ((obsolete = queue.poll()) != null) {
            map.remove(obsolete);
        }
    }

    private static class IdentityReference<T>
    extends WeakReference<T> {
        private int fHashCode = System.identityHashCode(this.get());

        public IdentityReference(T referent) {
            super(referent);
        }

        public IdentityReference(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IdentityReference)) {
                return false;
            }
            return this.get() == ((IdentityReference)obj).get();
        }

        public int hashCode() {
            return this.fHashCode;
        }
    }

    private static class WeakIdentityHashMap<K, V> {
        private final HashMap<IdentityReference<K>, V> fMap = new HashMap();
        private final ReferenceQueue<K> fQueue = new ReferenceQueue();

        private WeakIdentityHashMap() {
        }

        public V get(K key) {
            WrapperCache.purge(this.fMap, this.fQueue);
            return this.fMap.get(new IdentityReference<K>(key));
        }

        public void put(K key, V value) {
            WrapperCache.purge(this.fMap, this.fQueue);
            this.fMap.put(new IdentityReference<K>(key, this.fQueue), value);
        }
    }

    private static class WeakIdentityWeakValueHashMap<K, V> {
        private final HashMap<IdentityReference<K>, WeakReference<V>> fMap = new HashMap();
        private final ReferenceQueue<K> fQueue = new ReferenceQueue();

        private WeakIdentityWeakValueHashMap() {
        }

        public V get(K key) {
            WrapperCache.purge(this.fMap, this.fQueue);
            WeakReference<V> reference = this.fMap.get(new IdentityReference<K>(key));
            return reference != null ? (V)reference.get() : null;
        }

        public void put(K key, V value) {
            WrapperCache.purge(this.fMap, this.fQueue);
            this.fMap.put(new IdentityReference<K>(key, this.fQueue), value != null ? new WeakReference<V>(value) : null);
        }
    }
}

