/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal;

import com.ibm.team.rtc.common.scriptengine.AbstractScriptType;
import com.ibm.team.rtc.common.scriptengine.AbstractWrapperScriptType;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverter;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import com.ibm.team.rtc.common.scriptengine.TypeConversionException;
import com.ibm.team.rtc.common.scriptengine.annotation.WrapType;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.IDojoTypeContext;
import com.ibm.team.rtc.common.scriptengine.internal.WrapperCache;
import com.ibm.team.rtc.common.scriptengine.internal.bridge.wrapper.ObjectWrapper;
import com.ibm.team.rtc.common.scriptengine.internal.bridge.wrapper.SingleMethodInterfaceWrapper;
import com.ibm.team.rtc.common.scriptengine.internal.types.ITypeConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.util.ExceptionHelper;
import com.ibm.team.rtc.common.scriptengine.internal.util.jdojo.JDojoTypeUtils;
import com.ibm.team.rtc.common.scriptengine.internal.util.jdojo.ProxyFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class DojoScriptTypeConverterFactory
implements IScriptTypeConverterFactory {
    private static final String RHINO_NATIVE_DATE = "org.mozilla.javascript.NativeDate";
    private static final String UNDEFINED_LITERAL = "undefined";
    private final Set<Class<?>> fRegistredWrappers = Collections.synchronizedSet(new HashSet());
    private final Map<TypePair, Constructor<?>> fWrapperConstructors = Collections.synchronizedMap(new HashMap());
    private final Map<TypePair, IScriptTypeConverter> fConverterCache = Collections.synchronizedMap(new HashMap());
    private final WrapperCache fObjectWrappers = new WrapperCache();
    private final WrapperCache fScriptProxies = new WrapperCache();
    private final IScriptEnvironment fScriptEnvironment;
    private final ITypeConstructorFunction fOpaqueObjectCtorFunction;
    private final IScriptTypeConverter fDefaultConverter;
    private final IScriptTypeConverter fDefaultArrayConverter;
    private final IScriptTypeConverter fDefaultDateConverter;
    private final ProxyFactory fProxyFactory;

    public DojoScriptTypeConverterFactory(IScriptEnvironment scriptEnvironment) {
        this.fScriptEnvironment = scriptEnvironment;
        this.fProxyFactory = new ProxyFactory(scriptEnvironment);
        final Scriptable objectPrototype = scriptEnvironment.execute(new IScriptRunnable<Scriptable, RuntimeException>(){

            @Override
            public Scriptable run(Context cx, Scriptable scope) throws RuntimeException {
                return ScriptableObject.getObjectPrototype((Scriptable)scope);
            }
        });
        this.fOpaqueObjectCtorFunction = new ITypeConstructorFunction(){

            @Override
            public String getScriptTypeName() {
                return objectPrototype.getClassName();
            }

            @Override
            public Class<?> getJavaTypeClass() {
                return Object.class;
            }

            @Override
            public Scriptable getClassPrototype() {
                return objectPrototype;
            }
        };
        this.fDefaultConverter = new DefaultTypeConversion(null);
        this.fDefaultArrayConverter = new ArrayConversion(Object[].class);
        this.fDefaultDateConverter = new DateConversion();
    }

    @Override
    public IScriptTypeConverter getConverter(Class<?> typeClass) {
        return this.getConverter(typeClass, null);
    }

    @Override
    public IScriptTypeConverter getConverter(Class<?> typeClass, Class<?> rootType) {
        TypePair key = new TypePair(typeClass, rootType);
        IScriptTypeConverter typeConverter = this.fConverterCache.get(key);
        if (typeConverter == null) {
            typeConverter = this.createConverter(typeClass, rootType);
            this.fConverterCache.put(key, typeConverter);
        }
        return typeConverter;
    }

    private IScriptTypeConverter createConverter(Class<?> typeClass, Class<?> rootType) {
        Class<?>[] interfaces;
        if (typeClass.isAnonymousClass()) {
            interfaces = typeClass.getInterfaces();
            Assert.isTrue((interfaces.length <= 1 ? 1 : 0) != 0);
            typeClass = interfaces.length == 1 ? interfaces[0] : typeClass.getSuperclass();
        } else if (Proxy.isProxyClass(typeClass) && (interfaces = typeClass.getInterfaces()).length == 1) {
            typeClass = interfaces[0];
        }
        if (typeClass == String.class) {
            return new StringConversion();
        }
        if (typeClass == Integer.class || typeClass == Integer.TYPE) {
            return new IntegerConversion();
        }
        if (typeClass == Short.class || typeClass == Short.TYPE) {
            return new ShortConversion();
        }
        if (typeClass == Long.class || typeClass == Long.TYPE) {
            return new LongConversion();
        }
        if (typeClass == Double.class || typeClass == Double.TYPE || typeClass == Number.class) {
            return new DoubleConversion();
        }
        if (typeClass == Boolean.class || typeClass == Boolean.TYPE) {
            return new BooleanConversion();
        }
        if (typeClass == Date.class || typeClass == Timestamp.class || RHINO_NATIVE_DATE.equals(typeClass.getName())) {
            return new DateConversion();
        }
        if (typeClass == Void.class || typeClass == Void.TYPE || typeClass == Undefined.class) {
            return new VoidConversion();
        }
        if (typeClass == Class.class || typeClass == ITypeConstructorFunction.class) {
            return new TypeClassConversion();
        }
        if (Scriptable.class.isAssignableFrom(typeClass)) {
            return new ScriptableConversion();
        }
        if (typeClass.isArray()) {
            return new ArrayConversion(typeClass);
        }
        if (!typeClass.equals(Object.class)) {
            Constructor<?> constructor = this.findContributedWrapper(typeClass, rootType);
            if (constructor != null) {
                return new ContributedWrapperConversion(constructor);
            }
            return new DefaultTypeConversion(typeClass);
        }
        return new DynamicConversion();
    }

    public void registerWrapper(Class<?> typeClass) {
        WrapType wrapType = typeClass.getAnnotation(WrapType.class);
        if (wrapType != null) {
            try {
                Constructor<?> constructor = typeClass.getConstructor(Context.class, Scriptable.class, wrapType.value());
                this.fWrapperConstructors.put(new TypePair(wrapType.value(), null), constructor);
                this.fRegistredWrappers.add(wrapType.value());
            }
            catch (SecurityException constructor) {
            }
            catch (NoSuchMethodException e) {
                Assert.isTrue((boolean)false, (String)"Constructor with the parameters [Context, Scriptable, Object] is expected");
            }
        }
    }

    @Override
    public void cleanup() {
        this.fObjectWrappers.cleanup();
        this.fScriptProxies.cleanup();
    }

    private ITypeConstructorFunction getTypeConstructorFunction(Class<?> type) {
        return this.fScriptEnvironment.adapt(IDojoTypeContext.class).getTypeConstructorFunction(type);
    }

    private Constructor<?> findContributedWrapper(Class<?> typeClass, Class<?> rootType) {
        TypePair key = new TypePair(typeClass, rootType);
        Constructor<?> constructor = this.fWrapperConstructors.get(key);
        if (constructor == null && !this.fWrapperConstructors.containsKey(key)) {
            ArrayList candidateClasses = new ArrayList();
            this.computeClassOrder(typeClass, rootType, candidateClasses);
            Collections.sort(candidateClasses, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> o1, Class<?> o2) {
                    int c2;
                    int c1 = this.category(o1);
                    if (c1 != (c2 = this.category(o2))) {
                        return c1 - c2;
                    }
                    if (o1.isAssignableFrom(o2)) {
                        return 1;
                    }
                    if (o2.isAssignableFrom(o1)) {
                        return -1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }

                private int category(Class<?> type) {
                    if (type.isInterface()) {
                        return 1;
                    }
                    return Proxy.isProxyClass(type) ? 2 : 0;
                }
            });
            for (Class clazz : candidateClasses) {
                if (this.fRegistredWrappers.contains(clazz) && (constructor = this.fWrapperConstructors.get(new TypePair(clazz, null))) != null) break;
            }
            this.fWrapperConstructors.put(key, constructor);
        }
        return constructor;
    }

    private void computeClassOrder(Class<?> sourceClass, Class<?> rootType, Collection<Class<?>> classes) {
        Class<?> clazz = sourceClass;
        HashSet seen = new HashSet(4);
        while (clazz != null) {
            if (rootType == null || rootType.isAssignableFrom(clazz)) {
                classes.add(clazz);
                this.computeInterfaceOrder(clazz.getInterfaces(), rootType, classes, seen);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void computeInterfaceOrder(Class<?>[] interfaces, Class<?> rootType, Collection<Class<?>> classes, Set<Class<?>> seen) {
        ArrayList newInterfaces = new ArrayList(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            Class<?> interfac = interfaces[i];
            if (seen.add(interfac) && (rootType == null || rootType.isAssignableFrom(interfac))) {
                classes.add(interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator it = newInterfaces.iterator();
        while (it.hasNext()) {
            this.computeInterfaceOrder(((Class)it.next()).getInterfaces(), rootType, classes, seen);
        }
    }

    private class ArrayConversion
    implements IScriptTypeConverter {
        private final Class<?> fArrayType;
        private final Class<?> fElementType;
        private final IScriptTypeConverter fElementConverter;

        public ArrayConversion(Class<?> arrayType) {
            this.fArrayType = arrayType;
            Assert.isTrue((boolean)arrayType.isArray());
            this.fElementType = arrayType.getComponentType();
            this.fElementConverter = DojoScriptTypeConverterFactory.this.getConverter(this.fElementType);
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            if (javaObject == null) {
                return null;
            }
            Object wrapper = DojoScriptTypeConverterFactory.this.fObjectWrappers.get(javaObject, this.fArrayType);
            if (wrapper == null) {
                wrapper = new NativeJavaArray(scope, javaObject);
                DojoScriptTypeConverterFactory.this.fObjectWrappers.put(javaObject, this.fArrayType, wrapper);
            }
            return wrapper;
        }

        @Override
        public Object toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null || scriptObject == Undefined.instance || scriptObject == Scriptable.NOT_FOUND) {
                return null;
            }
            if (scriptObject instanceof NativeJavaArray) {
                return ((NativeJavaObject)scriptObject).unwrap();
            }
            long jsLength = 0L;
            jsLength = scriptObject instanceof NativeArray ? ((NativeArray)scriptObject).getLength() : ScriptRuntime.toUint32((Object)ScriptRuntime.getObjectProp((Object)scriptObject, (String)"length", (Context)cx));
            if (jsLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            int length = (int)jsLength;
            Object result = Array.newInstance(this.fElementType, length);
            int i = 0;
            while (i < length) {
                Array.set(result, i, this.fElementConverter.toJava(cx, scope, ScriptableObject.getProperty((Scriptable)((Scriptable)scriptObject), (int)i)));
                ++i;
            }
            return result;
        }
    }

    private class BooleanConversion
    implements IScriptTypeConverter {
        private BooleanConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            Assert.isLegal((javaObject == null || javaObject instanceof Boolean ? 1 : 0) != 0);
            return javaObject;
        }

        @Override
        public Boolean toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null) {
                return null;
            }
            if (scriptObject instanceof Boolean) {
                return (Boolean)scriptObject;
            }
            return ScriptRuntime.toBoolean((Object)scriptObject);
        }
    }

    private class ContributedWrapperConversion
    implements IScriptTypeConverter {
        private final Constructor<?> fConstructor;
        private Class<?> fWrapperClass;
        private Class<?> fSourceClass;
        private Map<Class<?>, Method> fConversionMethods;

        public ContributedWrapperConversion(Constructor<?> constructor) {
            this.fConstructor = constructor;
            this.fWrapperClass = constructor.getDeclaringClass();
            this.fSourceClass = this.fWrapperClass.getAnnotation(WrapType.class).value();
            this.fConversionMethods = null;
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            if (javaObject == null) {
                return null;
            }
            if (this.fWrapperClass.isInstance(javaObject)) {
                return javaObject;
            }
            Object wrapper = DojoScriptTypeConverterFactory.this.fObjectWrappers.get(javaObject, this.fWrapperClass);
            if (wrapper == null) {
                try {
                    if (!this.fSourceClass.equals(javaObject.getClass())) {
                        boolean useMoreSpecificConversion;
                        IScriptTypeConverter subjectConversion = DojoScriptTypeConverterFactory.this.getConverter(javaObject.getClass());
                        boolean bl = useMoreSpecificConversion = subjectConversion != this;
                        if (subjectConversion instanceof ContributedWrapperConversion && !this.fSourceClass.isAssignableFrom(((ContributedWrapperConversion)subjectConversion).fSourceClass)) {
                            useMoreSpecificConversion = false;
                        }
                        if (useMoreSpecificConversion) {
                            wrapper = subjectConversion.toScript(cx, scope, javaObject);
                        }
                    }
                    if (wrapper == null) {
                        wrapper = this.fConstructor.newInstance(cx, scope, javaObject);
                    }
                }
                catch (Exception e) {
                    throw ExceptionHelper.handle(e);
                }
                DojoScriptTypeConverterFactory.this.fObjectWrappers.put(javaObject, this.fWrapperClass, wrapper);
            }
            return wrapper;
        }

        @Override
        public Object toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null || scriptObject == Undefined.instance || scriptObject == Scriptable.NOT_FOUND) {
                return null;
            }
            if (this.fWrapperClass.isInstance(scriptObject)) {
                return ((AbstractWrapperScriptType)scriptObject).unwrap();
            }
            Map<Class<?>, Method> conversionMethods = this.getConversionMethods();
            for (Class<?> compatibleType : conversionMethods.keySet()) {
                IScriptTypeConverter converter = DojoScriptTypeConverterFactory.this.getConverter(compatibleType);
                if (converter == null) continue;
                try {
                    Object o = converter.toJava(cx, scope, scriptObject);
                    if (o == null) continue;
                    Method method = conversionMethods.get(compatibleType);
                    return method.invoke(null, o);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new TypeConversionException(String.format("Can only convert instances of '%s', but got '%s'", this.fWrapperClass.getName(), scriptObject.getClass().getName()), scriptObject);
        }

        private Map<Class<?>, Method> getConversionMethods() {
            if (this.fConversionMethods == null) {
                Method[] methods;
                this.fConversionMethods = new HashMap(3);
                Method[] methodArray = methods = this.fWrapperClass.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?>[] parameterTypes;
                    Method method = methodArray[n2];
                    if (method.getName().equals("convert") && (parameterTypes = method.getParameterTypes()).length == 1) {
                        this.fConversionMethods.put(parameterTypes[0], method);
                    }
                    ++n2;
                }
            }
            return this.fConversionMethods;
        }
    }

    private class DateConversion
    implements IScriptTypeConverter {
        private static final String DATE_CLASS = "Date";

        private DateConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            if (javaObject == null) {
                return null;
            }
            Assert.isLegal((boolean)(javaObject instanceof Date));
            return cx.newObject(scope, DATE_CLASS, new Object[]{((Date)javaObject).getTime()});
        }

        @Override
        public Date toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null) {
                return null;
            }
            Assert.isLegal((boolean)(scriptObject instanceof Scriptable));
            Assert.isLegal((boolean)DATE_CLASS.equals(((Scriptable)scriptObject).getClassName()));
            Object result = ScriptableObject.callMethod((Scriptable)((Scriptable)scriptObject), (String)"getTime", (Object[])Context.emptyArgs);
            Assert.isTrue((boolean)(result instanceof Number));
            return new Timestamp(((Number)result).longValue());
        }
    }

    private class DefaultTypeConversion
    implements IScriptTypeConverter {
        private final Class<?> fTypeClass;
        private final Method fSingleMethodInterfaceMethod;

        public DefaultTypeConversion(Class<?> typeClass) {
            this.fTypeClass = typeClass;
            this.fSingleMethodInterfaceMethod = typeClass != null ? JDojoTypeUtils.findSingleMethod(typeClass) : null;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            void var4_11;
            if (javaObject == null) {
                return null;
            }
            if (javaObject instanceof IScriptableProxy) {
                Scriptable scriptable = ((IScriptableProxy)javaObject).getProxySubject();
                if (this.fSingleMethodInterfaceMethod == null || scriptable instanceof Function) {
                    return scriptable;
                }
            }
            if (javaObject instanceof Scriptable) {
                return javaObject;
            }
            Object object = DojoScriptTypeConverterFactory.this.fObjectWrappers.get(javaObject, this.fTypeClass);
            if (object != null) return var4_11;
            if (this.fTypeClass != null) {
                if (!this.fTypeClass.isInstance(javaObject)) throw new TypeConversionException(String.format("Value must be of type '%s'", this.fTypeClass.getName()), javaObject);
                if (this.fSingleMethodInterfaceMethod != null) {
                    SingleMethodInterfaceWrapper singleMethodInterfaceWrapper = new SingleMethodInterfaceWrapper(scope, javaObject, this.fSingleMethodInterfaceMethod, DojoScriptTypeConverterFactory.this.fScriptEnvironment);
                } else {
                    void var4_8;
                    IScriptTypeConverter subjectConversion;
                    if (!this.fTypeClass.equals(javaObject.getClass()) && (subjectConversion = DojoScriptTypeConverterFactory.this.getConverter(javaObject.getClass())) != this) {
                        Object object2 = subjectConversion.toScript(cx, scope, javaObject);
                    }
                    if (var4_8 == null) {
                        ObjectWrapper objectWrapper = new ObjectWrapper(cx, scope, javaObject, DojoScriptTypeConverterFactory.this.getTypeConstructorFunction(javaObject.getClass()), DojoScriptTypeConverterFactory.this.fScriptEnvironment);
                    }
                }
            } else {
                ObjectWrapper objectWrapper = new ObjectWrapper(cx, scope, javaObject, DojoScriptTypeConverterFactory.this.fOpaqueObjectCtorFunction, DojoScriptTypeConverterFactory.this.fScriptEnvironment);
            }
            Assert.isNotNull((Object)var4_11);
            DojoScriptTypeConverterFactory.this.fObjectWrappers.put(javaObject, this.fTypeClass, var4_11);
            return var4_11;
        }

        @Override
        public Object toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null || scriptObject == Undefined.instance || scriptObject == Scriptable.NOT_FOUND) {
                return null;
            }
            if (scriptObject instanceof Wrapper) {
                return ((Wrapper)scriptObject).unwrap();
            }
            if (!(scriptObject instanceof Scriptable)) {
                throw new TypeConversionException("Expected a Scriptable object", scriptObject);
            }
            if (this.fTypeClass != null && this.fTypeClass.isInstance(scriptObject)) {
                return scriptObject;
            }
            if (this.fTypeClass == null || this.fTypeClass.isInterface()) {
                Object proxy = DojoScriptTypeConverterFactory.this.fScriptProxies.get(scriptObject, this.fTypeClass);
                if (proxy == null) {
                    proxy = scriptObject instanceof Function ? DojoScriptTypeConverterFactory.this.fProxyFactory.createFunctionProxy((Function)scriptObject, this.fTypeClass) : DojoScriptTypeConverterFactory.this.fProxyFactory.createProxy((Scriptable)scriptObject, this.fTypeClass);
                    DojoScriptTypeConverterFactory.this.fScriptProxies.put(scriptObject, this.fTypeClass, proxy);
                }
                return proxy;
            }
            Assert.isNotNull(this.fTypeClass);
            throw new TypeConversionException(String.format("Cant convert object to class '%s'", this.fTypeClass.getName()), scriptObject);
        }
    }

    private class DoubleConversion
    implements IScriptTypeConverter {
        private DoubleConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            Assert.isLegal((javaObject == null || javaObject instanceof Double ? 1 : 0) != 0);
            return javaObject;
        }

        @Override
        public Double toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null) {
                return null;
            }
            if (scriptObject instanceof Double) {
                return (Double)scriptObject;
            }
            return ScriptRuntime.toNumber((Object)scriptObject);
        }
    }

    private class DynamicConversion
    implements IScriptTypeConverter {
        private DynamicConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            if (javaObject == null) {
                return null;
            }
            if (javaObject instanceof String || javaObject instanceof Number || javaObject instanceof Boolean) {
                return javaObject;
            }
            if (javaObject instanceof IScriptableProxy) {
                return ((IScriptableProxy)javaObject).getProxySubject();
            }
            IScriptTypeConverter subjectConversion = DojoScriptTypeConverterFactory.this.getConverter(javaObject.getClass());
            if (subjectConversion != this) {
                return subjectConversion.toScript(cx, scope, javaObject);
            }
            Object wrapper = DojoScriptTypeConverterFactory.this.fObjectWrappers.get(javaObject, null);
            if (wrapper == null) {
                wrapper = new ObjectWrapper(cx, scope, javaObject, DojoScriptTypeConverterFactory.this.fOpaqueObjectCtorFunction, DojoScriptTypeConverterFactory.this.fScriptEnvironment);
                DojoScriptTypeConverterFactory.this.fObjectWrappers.put(javaObject, null, wrapper);
            }
            return wrapper;
        }

        @Override
        public Object toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null || scriptObject == Undefined.instance || scriptObject == Scriptable.NOT_FOUND) {
                return null;
            }
            if (scriptObject instanceof String || scriptObject instanceof Number || scriptObject instanceof Boolean) {
                return scriptObject;
            }
            if (scriptObject instanceof Wrapper) {
                return ((Wrapper)scriptObject).unwrap();
            }
            if (scriptObject instanceof AbstractScriptType) {
                return scriptObject;
            }
            Object proxy = DojoScriptTypeConverterFactory.this.fScriptProxies.get(scriptObject, Object.class);
            if (proxy == null) {
                if (ScriptRuntime.isArrayObject((Object)scriptObject)) {
                    proxy = DojoScriptTypeConverterFactory.this.fDefaultArrayConverter.toJava(cx, scope, scriptObject);
                } else {
                    proxy = DojoScriptTypeConverterFactory.RHINO_NATIVE_DATE.equals(scriptObject.getClass().getName()) ? DojoScriptTypeConverterFactory.this.fDefaultDateConverter.toJava(cx, scope, scriptObject) : DojoScriptTypeConverterFactory.this.fDefaultConverter.toJava(cx, scope, scriptObject);
                    DojoScriptTypeConverterFactory.this.fScriptProxies.put(scriptObject, null, proxy);
                }
            }
            return proxy;
        }
    }

    private class IntegerConversion
    implements IScriptTypeConverter {
        private IntegerConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            Assert.isLegal((javaObject == null || javaObject instanceof Integer ? 1 : 0) != 0);
            return javaObject;
        }

        @Override
        public Integer toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null) {
                return null;
            }
            if (scriptObject instanceof Integer) {
                return (Integer)scriptObject;
            }
            return ScriptRuntime.toInt32((Object)scriptObject);
        }
    }

    private class LongConversion
    implements IScriptTypeConverter {
        private LongConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            Assert.isLegal((javaObject == null || javaObject instanceof Long ? 1 : 0) != 0);
            return javaObject;
        }

        @Override
        public Long toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null) {
                return null;
            }
            if (scriptObject instanceof Long) {
                return (Long)scriptObject;
            }
            if (scriptObject instanceof Integer) {
                return ((Number)scriptObject).longValue();
            }
            if (scriptObject instanceof Double) {
                return ((Number)scriptObject).longValue();
            }
            return ScriptRuntime.toInt32((Object)scriptObject);
        }
    }

    private class ScriptableConversion
    implements IScriptTypeConverter {
        private ScriptableConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            if (javaObject == null) {
                return null;
            }
            if (javaObject instanceof IScriptableProxy) {
                return ((IScriptableProxy)javaObject).getProxySubject();
            }
            if (javaObject instanceof Scriptable) {
                return javaObject;
            }
            throw new TypeConversionException(String.format("Cant convert object of type '%s' to Scriptable", javaObject.getClass().getName()), javaObject);
        }

        public Scriptable toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null || scriptObject == Undefined.instance || scriptObject == Scriptable.NOT_FOUND) {
                return null;
            }
            if (scriptObject instanceof Scriptable) {
                return (Scriptable)scriptObject;
            }
            throw new TypeConversionException(String.format("Cant convert value of type '%s' to Scriptable", ScriptRuntime.typeof((Object)scriptObject)), scriptObject);
        }
    }

    private class ShortConversion
    implements IScriptTypeConverter {
        private ShortConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            Assert.isLegal((javaObject == null || javaObject instanceof Short ? 1 : 0) != 0);
            return javaObject;
        }

        @Override
        public Short toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null) {
                return null;
            }
            if (scriptObject instanceof Short) {
                return (Short)scriptObject;
            }
            if (scriptObject instanceof Integer) {
                return ((Number)scriptObject).shortValue();
            }
            return (short)ScriptRuntime.toInt32((Object)scriptObject);
        }
    }

    private class StringConversion
    implements IScriptTypeConverter {
        private StringConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            if (javaObject == DojoScriptTypeConverterFactory.UNDEFINED_LITERAL) {
                return Undefined.instance;
            }
            Assert.isLegal((javaObject == null || javaObject instanceof String ? 1 : 0) != 0);
            return javaObject;
        }

        @Override
        public String toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null) {
                return null;
            }
            if (scriptObject == Undefined.instance) {
                return DojoScriptTypeConverterFactory.UNDEFINED_LITERAL;
            }
            if (scriptObject instanceof String) {
                return (String)scriptObject;
            }
            if (scriptObject instanceof Scriptable) {
                if ((scriptObject = ((Scriptable)scriptObject).getDefaultValue(String.class)) instanceof Scriptable) {
                    throw new TypeConversionException("Primitive value expected", scriptObject);
                }
                return this.toJava(cx, scope, scriptObject);
            }
            Assert.isTrue((scriptObject instanceof Number || scriptObject instanceof Boolean ? 1 : 0) != 0);
            return scriptObject.toString();
        }
    }

    private class TypeClassConversion
    implements IScriptTypeConverter {
        private TypeClassConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            if (javaObject == null) {
                return null;
            }
            if (javaObject instanceof Class) {
                Constructor constructor = DojoScriptTypeConverterFactory.this.findContributedWrapper(javaObject, null);
                if (constructor != null) {
                    javaObject = constructor.getDeclaringClass();
                }
                return DojoScriptTypeConverterFactory.this.getTypeConstructorFunction(javaObject);
            }
            throw new TypeConversionException(String.format("Cant convert value of type '%s' to a constructor function", javaObject.getClass().getName()), javaObject);
        }

        @Override
        public Class<?> toJava(Context cx, Scriptable scope, Object scriptObject) {
            if (scriptObject == null || scriptObject == Undefined.instance || scriptObject == Scriptable.NOT_FOUND) {
                return null;
            }
            if (scriptObject instanceof ITypeConstructorFunction) {
                return ((ITypeConstructorFunction)scriptObject).getJavaTypeClass();
            }
            throw new TypeConversionException(String.format("Cant convert value of type '%s' to java.lang.Class", ScriptRuntime.typeof((Object)scriptObject)), scriptObject);
        }
    }

    private static class TypePair {
        public final Class<?> concreteType;
        public final Class<?> rootType;

        public TypePair(Class<?> concreteType, Class<?> rootType) {
            this.concreteType = concreteType;
            this.rootType = rootType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.concreteType == null ? 0 : this.concreteType.hashCode());
            result = 31 * result + (this.rootType == null ? 0 : this.rootType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypePair other = (TypePair)obj;
            if (this.concreteType == null ? other.concreteType != null : !this.concreteType.equals(other.concreteType)) {
                return false;
            }
            return !(this.rootType == null ? other.rootType != null : !this.rootType.equals(other.rootType));
        }
    }

    private class VoidConversion
    implements IScriptTypeConverter {
        private VoidConversion() {
        }

        @Override
        public Object toScript(Context cx, Scriptable scope, Object javaObject) {
            Assert.isLegal((javaObject == null || javaObject == Undefined.instance ? 1 : 0) != 0);
            return Undefined.instance;
        }

        @Override
        public Void toJava(Context cx, Scriptable scope, Object scriptObject) {
            return null;
        }
    }
}

