/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.dojo;

import com.ibm.team.rtc.common.scriptengine.AbstractScriptType;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptTypeFeature;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.ITypeResolver;
import com.ibm.team.rtc.common.scriptengine.internal.DojoScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import com.ibm.team.rtc.common.scriptengine.internal.types.scripttype.ScriptTypeFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptTypeResolver
implements ITypeResolver {
    private final Map<String, ScriptTypeFeature> fTypesFeatures = new HashMap<String, ScriptTypeFeature>();

    public ScriptTypeResolver(Class<? extends AbstractScriptType> ... scriptTypes) {
        this(Arrays.asList(scriptTypes));
    }

    public ScriptTypeResolver(List<Class<? extends AbstractScriptType>> scriptTypes) {
        for (Class<? extends AbstractScriptType> scriptType : scriptTypes) {
            ScriptTypeFeature scriptTypeFeature = new ScriptTypeFeature(scriptType);
            this.fTypesFeatures.put(scriptTypeFeature.getProvidedTypeName(), scriptTypeFeature);
        }
        if (ScriptEnginePlugin.TRACE_TYPE_RESOLVING) {
            StringBuilder trace = new StringBuilder();
            trace.append(String.format("Registred Script Types:%n", new Object[0]));
            Collection<ScriptTypeFeature> values = this.fTypesFeatures.values();
            for (ScriptTypeFeature typeFeature : values) {
                trace.append(String.format("%s", typeFeature.toString()));
            }
            ScriptEnginePlugin.trace(trace.toString(), new Object[0]);
        }
    }

    @Override
    public void initializeConversion(IScriptTypeConverterFactory converterFactory) {
        if (converterFactory instanceof DojoScriptTypeConverterFactory) {
            DojoScriptTypeConverterFactory dojoConverter = (DojoScriptTypeConverterFactory)converterFactory;
            for (ScriptTypeFeature typeFeature : this.fTypesFeatures.values()) {
                dojoConverter.registerWrapper(typeFeature.getFacadeClass());
            }
        }
    }

    @Override
    public IScriptTypeFeature resolve(String typeName) {
        return this.fTypesFeatures.get(typeName);
    }
}

