/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.dojo;

import com.ibm.team.rtc.common.scriptengine.environment.IScriptEnvironmentFeature;
import com.ibm.team.rtc.common.scriptengine.environment.LoggingFeature;
import com.ibm.team.rtc.common.scriptengine.environment.SuperGlobalFeature;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.DojoFeature;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.ITypeResolver;
import com.ibm.team.rtc.common.scriptengine.internal.scripts.DojoScriptTypeResolver;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiTypeResolver;
import com.ibm.team.rtc.common.scriptengine.internal.types.scripttype.ContributedScriptTypeResolver;

public class DefaultDojoEnvironment {
    private static final ITypeResolver API_TYPES = new ApiTypeResolver();
    private static final ITypeResolver SCRIPT_TYPES = new ContributedScriptTypeResolver();
    private static final ITypeResolver SCRIPTED_TYPES = new DojoScriptTypeResolver(DojoScriptTypeResolver.Source.ScriptBundles);

    public static IScriptEnvironmentFeature[] createFeatures() {
        return DefaultDojoEnvironment.createFeatures(new IScriptEnvironmentFeature[0], new ITypeResolver[0]);
    }

    public static IScriptEnvironmentFeature[] createFeatures(ITypeResolver ... additionalResolvers) {
        return DefaultDojoEnvironment.createFeatures(new IScriptEnvironmentFeature[0], additionalResolvers);
    }

    public static IScriptEnvironmentFeature[] createFeatures(IScriptEnvironmentFeature ... additionalFeatures) {
        return DefaultDojoEnvironment.createFeatures(additionalFeatures, new ITypeResolver[0]);
    }

    public static IScriptEnvironmentFeature[] createFeatures(IScriptEnvironmentFeature[] additionalFeatures, ITypeResolver[] additionalResolvers) {
        IScriptEnvironmentFeature[] result = new IScriptEnvironmentFeature[3 + additionalFeatures.length];
        result[0] = new SuperGlobalFeature();
        result[1] = DefaultDojoEnvironment.createDojoFeature(additionalResolvers);
        result[2] = new LoggingFeature();
        System.arraycopy(additionalFeatures, 0, result, 3, additionalFeatures.length);
        return result;
    }

    private static DojoFeature createDojoFeature(ITypeResolver[] additionalResolvers) {
        ITypeResolver[] typeResolvers = new ITypeResolver[3 + additionalResolvers.length];
        typeResolvers[0] = API_TYPES;
        typeResolvers[1] = SCRIPT_TYPES;
        typeResolvers[2] = SCRIPTED_TYPES;
        System.arraycopy(additionalResolvers, 0, typeResolvers, 3, additionalResolvers.length);
        return new DojoFeature(typeResolvers);
    }
}

