/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.browser;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.rtc.common.scriptengine.AbstractScriptType;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.annotation.Constructor;
import com.ibm.team.rtc.common.scriptengine.annotation.Function;
import com.ibm.team.rtc.common.scriptengine.annotation.Property;
import com.ibm.team.rtc.common.scriptengine.environment.browser.XMLDefaultDocumentHandler;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;

@Stub(value="XMLHttpRequest")
public class XMLHttpRequestScriptType
extends AbstractScriptType {
    private org.mozilla.javascript.Function fOnReadyStateChange = null;
    private boolean fAsync = true;
    private ReadyState fReadyState = ReadyState.UNINITIALIZED;
    private HttpResponse fResponse;
    private Document fResponseXML;
    private HttpMethod fMethod;
    private String fURL;
    private Map<String, String> fRequestHeaders = new HashMap<String, String>();
    private final IScriptEnvironment fScriptEnvironment = IScriptEnvironment.CURRENT.getScriptEnvironment();
    private List<IHttpRequestHandler> fRequestHandlers;
    private List<org.mozilla.javascript.Function> fLoadListeners = new ArrayList<org.mozilla.javascript.Function>();
    private List<org.mozilla.javascript.Function> fErrorListeners = new ArrayList<org.mozilla.javascript.Function>();

    @Constructor
    public XMLHttpRequestScriptType(Context cx, Scriptable scope) {
        super(cx, scope);
        this.fRequestHandlers = new ArrayList<IHttpRequestHandler>();
        this.initializeHandlers(this.fRequestHandlers);
        this.fResponse = new HttpResponse(100, "Not yet processed", "Not yet processed", Collections.emptyMap());
    }

    public void initializeHandlers(List<IHttpRequestHandler> handlers) {
        handlers.add(new XMLDefaultDocumentHandler());
    }

    @Function
    public void open(String method, String url, boolean async, String user, String password) {
        this.fReadyState = ReadyState.LOADING;
        this.fAsync = async;
        this.fMethod = HttpMethod.parse(method);
        this.fURL = url;
        this.invokeOnReadyStateChange();
    }

    @Function
    public void setRequestHeader(String header, String value) {
        this.fRequestHeaders.put(header, value);
    }

    @Function
    public String getResponseHeader(String header) {
        if (this.fReadyState == ReadyState.UNINITIALIZED || this.fReadyState == ReadyState.LOADING) {
            Context.reportRuntimeError((String)"Invalid State");
        }
        for (Map.Entry<String, String> headerEntry : this.fResponse.responseHeaders.entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase(header)) continue;
            return headerEntry.getValue();
        }
        return null;
    }

    @Function
    public String getAllResponseHeaders() {
        if (this.fReadyState == ReadyState.UNINITIALIZED || this.fReadyState == ReadyState.LOADING) {
            Context.reportRuntimeError((String)"Invalid State");
        }
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> header : this.fResponse.responseHeaders.entrySet()) {
            if (!isFirst) {
                result.append("\r\n");
            } else {
                isFirst = false;
            }
            result.append(header.getKey()).append(": ").append(header.getValue());
        }
        return result.toString();
    }

    @Function
    public void send(String data) {
        IHttpResponseCallback callback = new IHttpResponseCallback(){

            @Override
            public void callback(HttpResponse response) {
                XMLHttpRequestScriptType.this.handleResponse(response);
            }
        };
        for (IHttpRequestHandler handler : this.fRequestHandlers) {
            boolean canHandle = handler.handle(this.fMethod, this.fURL, this.fRequestHeaders, data, callback);
            if (!canHandle) continue;
            return;
        }
        callback.callback(new HttpResponse(404, "Not Found", "", Collections.emptyMap()));
    }

    @Function
    public void abort() {
    }

    @Function
    public void addEventListener(String eventType, org.mozilla.javascript.Function listener, boolean useCapture) {
        if ("load".equals(eventType)) {
            this.fLoadListeners.add(listener);
        } else if ("error".equals(eventType)) {
            this.fErrorListeners.add(listener);
        }
    }

    @Function
    public void removeEventListener(String eventType, org.mozilla.javascript.Function listener, boolean useCapture) {
        if ("load".equals(eventType)) {
            this.fLoadListeners.remove(listener);
        } else if ("error".equals(eventType)) {
            this.fErrorListeners.remove(listener);
        }
    }

    @Property(name="async", accessor=Property.Kind.Getter)
    public boolean isAsync() {
        return this.fAsync;
    }

    @Property(name="async", accessor=Property.Kind.Setter)
    public void setAsync(boolean async) {
        this.fAsync = async;
    }

    @Property(name="readyState", accessor=Property.Kind.Getter)
    public int getReadyState() {
        return this.fReadyState.value;
    }

    @Property(name="status", accessor=Property.Kind.Getter)
    public int getStatus() {
        return this.fResponse.status;
    }

    @Property(name="statusText", accessor=Property.Kind.Getter)
    public String getStatusText() {
        return this.fResponse.statusText;
    }

    @Property(name="responseText", accessor=Property.Kind.Getter)
    public String getResponseText() {
        return this.fResponse.responseText;
    }

    @Property(name="responseXML", accessor=Property.Kind.Getter)
    public Document getResponseXML() {
        if (this.fResponseXML == null && this.fResponse.responseText.trim().startsWith("<")) {
            this.fResponseXML = this.fScriptEnvironment.execute(new IScriptRunnable<Document, RuntimeException>(){

                @Override
                public Document run(Context cx, Scriptable scope) throws RuntimeException {
                    try {
                        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(new String(((XMLHttpRequestScriptType)XMLHttpRequestScriptType.this).fResponse.responseText).getBytes("UTF8")));
                    }
                    catch (Exception e) {
                        ScriptEnginePlugin.log(e);
                        return null;
                    }
                }
            });
        }
        return this.fResponseXML;
    }

    @Property(name="onreadystatechange", accessor=Property.Kind.Getter)
    public org.mozilla.javascript.Function getOnReadyStateChange() {
        return this.fOnReadyStateChange;
    }

    @Property(name="onreadystatechange", accessor=Property.Kind.Setter)
    public void setOnReadyStateChange(org.mozilla.javascript.Function onReadyStateChange) {
        this.fOnReadyStateChange = onReadyStateChange;
    }

    private void invokeOnReadyStateChange() {
        if (this.fOnReadyStateChange != null) {
            this.fScriptEnvironment.execute(new IScriptRunnable<Void, RuntimeException>(){

                @Override
                public Void run(Context cx, Scriptable scope) throws RuntimeException {
                    XMLHttpRequestScriptType.this.fOnReadyStateChange.call(cx, scope, scope, Context.emptyArgs);
                    return null;
                }
            });
        }
    }

    private void notifyListeners() {
        final List<org.mozilla.javascript.Function> listeners = this.fLoadListeners;
        if (!listeners.isEmpty()) {
            this.fScriptEnvironment.execute(new IScriptRunnable<Void, RuntimeException>(){

                @Override
                public Void run(Context cx, Scriptable scope) throws RuntimeException {
                    for (org.mozilla.javascript.Function listener : listeners) {
                        listener.call(cx, scope, scope, new Object[0]);
                    }
                    return null;
                }
            });
        }
    }

    private void handleResponse(HttpResponse response) {
        this.fReadyState = ReadyState.COMPLETED;
        this.fResponse = response;
        this.fResponseXML = null;
        this.invokeOnReadyStateChange();
        this.notifyListeners();
    }

    public static enum HttpMethod {
        GET,
        PUT,
        POST,
        DELETE;


        public static HttpMethod parse(String method) {
            if (method != null) {
                try {
                    return HttpMethod.valueOf(method.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return GET;
        }
    }

    public static class HttpResponse {
        public final int status;
        public final Map<String, String> responseHeaders;
        public final String responseText;
        public final String statusText;

        public HttpResponse(int statusCode, String statusText, String response, Map<String, String> map) {
            this.status = statusCode;
            this.statusText = statusText;
            this.responseText = response;
            this.responseHeaders = map;
        }
    }

    public static interface IHttpRequestHandler {
        public boolean handle(HttpMethod var1, String var2, Map<String, String> var3, String var4, IHttpResponseCallback var5);
    }

    public static interface IHttpResponseCallback {
        public void callback(HttpResponse var1);
    }

    static enum ReadyState {
        UNINITIALIZED(0),
        LOADING(1),
        LOADED(2),
        INTERACTIVE(3),
        COMPLETED(4);

        public final int value;

        private ReadyState(int val) {
            this.value = val;
        }
    }
}

