/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.browser;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.environment.browser.EventLockImplementation;
import java.util.concurrent.PriorityBlockingQueue;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class ScriptExecutionManager {
    private final IScriptEnvironment fScriptEnvironment;
    private final PriorityBlockingQueue<FunctionSubmission> fSubmissionQueue = new PriorityBlockingQueue();
    private FunctionSubmission fCurrent = null;

    public ScriptExecutionManager(IScriptEnvironment scriptEnvironment) {
        this.fScriptEnvironment = scriptEnvironment;
    }

    public void start(Scriptable thisObj, Function function, long timeout) {
        this.fSubmissionQueue.add(new FunctionSubmission(thisObj, (Callable)function, timeout));
        while (!this.fSubmissionQueue.isEmpty()) {
            if (this.triggerExecution()) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public FunctionSubmission submit(Scriptable thisObj, Callable function, long timeout) {
        FunctionSubmission result = new FunctionSubmission(thisObj, function, timeout);
        this.fSubmissionQueue.add(result);
        return result;
    }

    public void remove(FunctionSubmission handle) {
        this.fSubmissionQueue.remove(handle);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void await(EventLockImplementation eventLock, int timeout) {
        FunctionSubmission suspended = this.fCurrent;
        this.fCurrent = null;
        long expires = System.currentTimeMillis() + (long)timeout;
        try {
            block9: {
                block8: {
                    if (!true) break block8;
                    if (eventLock.isTriggered()) return;
                    if (System.currentTimeMillis() >= expires) break block9;
                }
                do {
                    if (!this.triggerExecution()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (eventLock.isTriggered()) return;
                } while (System.currentTimeMillis() < expires);
            }
            return;
        }
        finally {
            this.fCurrent = suspended;
        }
    }

    private boolean triggerExecution() {
        if (this.fCurrent != null) {
            return false;
        }
        final FunctionSubmission nextSubmission = this.fSubmissionQueue.peek();
        if (nextSubmission != null && nextSubmission.fExecutionTime < System.currentTimeMillis()) {
            this.fCurrent = nextSubmission;
            this.fSubmissionQueue.remove(nextSubmission);
            try {
                this.fScriptEnvironment.execute(new IScriptRunnable<Void, RuntimeException>(){

                    @Override
                    public Void run(Context cx, Scriptable scope) throws RuntimeException {
                        nextSubmission.fFunction.call(cx, scope, nextSubmission.fThisObj, ScriptRuntime.emptyArgs);
                        return null;
                    }
                });
                return true;
            }
            finally {
                this.fCurrent = null;
            }
        }
        return false;
    }

    public static class FunctionSubmission
    implements Comparable<FunctionSubmission> {
        Scriptable fThisObj;
        Callable fFunction;
        long fExecutionTime;

        public FunctionSubmission(Scriptable thisObj, Callable function, long timeout) {
            this.fThisObj = thisObj;
            this.fFunction = function;
            this.fExecutionTime = System.currentTimeMillis() + timeout;
        }

        @Override
        public int compareTo(FunctionSubmission o) {
            if (this.fExecutionTime < o.fExecutionTime) {
                return -1;
            }
            if (this.fExecutionTime > o.fExecutionTime) {
                return 1;
            }
            return 0;
        }
    }
}

