/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.browser;

import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import java.io.StringWriter;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLUtils {
    public static String getOuterHTML(NodeList nodelist, boolean indent) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < nodelist.getLength()) {
            result.append(HTMLUtils.getOuterHTML(nodelist.item(i), indent));
            ++i;
        }
        return result.toString();
    }

    public static String getOuterHTML(NodeList nodelist) {
        return HTMLUtils.getOuterHTML(nodelist, false);
    }

    public static String getOuterHTML(Node node, boolean indent) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("omit-xml-declaration", "yes");
            xformer.setOutputProperty("indent", indent ? "yes" : "no");
            xformer.transform(source, result);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            ScriptEnginePlugin.log(e);
            return "Failed to transform. See error log.";
        }
        catch (TransformerException e) {
            ScriptEnginePlugin.log(e);
            return "Failed to transform. See error log.";
        }
    }

    public static String getOuterHTML(Node node) {
        return HTMLUtils.getOuterHTML(node, false);
    }

    public static void toUpperCase(NodeList nodes) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node item = nodes.item(i);
            if (item instanceof Element) {
                Element element = (Element)item;
                String tagName = element.getTagName();
                if (!tagName.equals(tagName.toUpperCase(Locale.ROOT))) {
                    element.getOwnerDocument().renameNode(element, null, tagName.toUpperCase(Locale.ROOT));
                }
                NamedNodeMap attributes = element.getAttributes();
                int j = 0;
                while (j < attributes.getLength()) {
                    Attr attribute = (Attr)attributes.item(j);
                    String attributeName = attribute.getName();
                    if (!attributeName.equals(attributeName.toUpperCase(Locale.ROOT))) {
                        attribute.getOwnerDocument().renameNode(attribute, null, attributeName.toUpperCase(Locale.ROOT));
                    }
                    ++j;
                }
            }
            HTMLUtils.toUpperCase(item.getChildNodes());
            ++i;
        }
    }
}

