/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.browser;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.events.Event;

public class EventManager {
    private Map<String, List<Function>> fHandlers = new HashMap<String, List<Function>>();
    private final IScriptEnvironment fScriptEnvironment;
    private final Scriptable fEventSource;

    public EventManager(Scriptable eventSource, IScriptEnvironment scriptEnvironment) {
        this.fEventSource = eventSource;
        this.fScriptEnvironment = scriptEnvironment;
    }

    public void addEventListener(String type, Function handler) {
        List<Function> handlers = this.fHandlers.get(type);
        if (handlers == null) {
            handlers = new ArrayList<Function>();
            this.fHandlers.put(type, handlers);
        }
        if (handlers.contains(handler)) {
            handlers.add(handler);
        }
    }

    public void removeEventListener(String type, Function handler) {
        List<Function> handlers = this.fHandlers.get(type);
        if (handlers != null) {
            handlers.remove(handler);
        }
    }

    public void dispatchEvent(final Event event) {
        final String type = event.getType();
        if (type != null && type.length() > 0) {
            this.fScriptEnvironment.execute(new IScriptRunnable<Void, RuntimeException>(){

                @Override
                public Void run(Context cx, Scriptable scope) throws RuntimeException {
                    Object handlerCandidate;
                    List handlers = (List)EventManager.this.fHandlers.get(type);
                    if (handlers != null) {
                        for (Function handler : handlers) {
                            handler.call(cx, scope, EventManager.this.fEventSource, new Object[]{event});
                        }
                    }
                    if ((handlerCandidate = ScriptableObject.getProperty((Scriptable)EventManager.this.fEventSource, (String)("on" + type))) instanceof Callable) {
                        ((Callable)handlerCandidate).call(cx, scope, EventManager.this.fEventSource, new Object[]{event});
                    }
                    return null;
                }
            });
        }
    }
}

