/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.browser;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.rtc.common.scriptengine.AbstractScriptable;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.annotation.Constructor;
import com.ibm.team.rtc.common.scriptengine.annotation.Function;
import com.ibm.team.rtc.common.scriptengine.annotation.Property;
import com.ibm.team.rtc.common.scriptengine.annotation.WrapType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMCSSStyleSheetScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMNodeScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMStyleScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.HTMLUtils;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumSet;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Stub(value="DOMElement")
@WrapType(value=Element.class)
public class DOMElementScriptType
extends DOMNodeScriptType {
    private static final String ATTR_ID = "id";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_LANG = "lang";
    private static final String ATTR_DIR = "dir";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASSNAME = "className";
    private static final String ATTR_INNERHTML = "innerHTML";
    private static final String ATTR_DISABLED = "disabled";
    private static final String ATTR_CHECKED = "checked";
    private static final String ATTR_SELECTED = "selected";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_SRC = "src";
    private static final String ATTR_HREF = "href";
    private static final String ATTR_TABINDEX = "tabIndex";
    private static final String ATTR_SHEET = "sheet";
    private static final String ATTR_COLSPAN = "colSpan";
    private DOMStyleScriptType fStyles;
    private DOMCSSStyleSheetScriptType fStyleSheet;

    @Constructor
    public DOMElementScriptType(Context cx, Scriptable scope, Element subject) {
        super(cx, scope, subject);
        this.defineProperty("clientHeight", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("clientLeft", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("clientTop", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("clientWidth", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("offsetHeight", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("offsetLeft", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("offsetParent", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("offsetTop", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("offsetWidth", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("scrollHeight", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("scrollLeft", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("scrollParent", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("scrollTop", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("scrollWidth", 0, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
        this.defineProperty("spellcheck", false, EnumSet.noneOf(AbstractScriptable.PropertyAttribute.class));
    }

    @Property(name="attributes", accessor=Property.Kind.Getter)
    public NamedNodeMap getAttributes() {
        return ((Element)this.getSubject()).getAttributes();
    }

    @Property(name="style", accessor=Property.Kind.Getter)
    public DOMStyleScriptType getStyles() {
        if (this.fStyles == null) {
            this.fStyles = IScriptEnvironment.CURRENT.execute(new IScriptRunnable<DOMStyleScriptType, RuntimeException>(){

                @Override
                public DOMStyleScriptType run(Context cx, Scriptable scope) throws RuntimeException {
                    return new DOMStyleScriptType(cx, scope, (Element)DOMElementScriptType.this.getSubject());
                }
            });
        }
        return this.fStyles;
    }

    @Property(name="tagName", accessor=Property.Kind.Getter)
    public String getTagName() {
        return ((Element)this.getSubject()).getTagName().toUpperCase(Locale.ROOT);
    }

    @Function
    public String getAttribute(String name) {
        return ((Element)this.getSubject()).getAttribute(name.toUpperCase(Locale.ROOT));
    }

    @Function
    public void setAttribute(String name, String value) throws DOMException {
        ((Element)this.getSubject()).setAttribute(name.toUpperCase(Locale.ROOT), value);
    }

    @Function
    public void removeAttribute(String name) throws DOMException {
        ((Element)this.getSubject()).removeAttribute(name.toUpperCase(Locale.ROOT));
    }

    @Function
    public Attr getAttributeNode(String name) {
        return ((Element)this.getSubject()).getAttributeNode(name.toUpperCase(Locale.ROOT));
    }

    @Function
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return ((Element)this.getSubject()).setAttributeNode(newAttr);
    }

    @Function
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return ((Element)this.getSubject()).removeAttributeNode(oldAttr);
    }

    @Function
    public NodeList getElementsByTagName(String name) {
        return ((Element)this.getSubject()).getElementsByTagName(name.toUpperCase(Locale.ROOT));
    }

    @Function
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return ((Element)this.getSubject()).getAttributeNS(namespaceURI, localName);
    }

    @Function
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        ((Element)this.getSubject()).setAttributeNS(namespaceURI, qualifiedName, value);
    }

    @Function
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        ((Element)this.getSubject()).removeAttributeNS(namespaceURI, localName);
    }

    @Function
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return ((Element)this.getSubject()).getAttributeNodeNS(namespaceURI, localName);
    }

    @Function
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return ((Element)this.getSubject()).setAttributeNodeNS(newAttr);
    }

    @Function
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return ((Element)this.getSubject()).getElementsByTagNameNS(namespaceURI, localName);
    }

    @Function
    public boolean hasAttribute(String name) {
        return ((Element)this.getSubject()).hasAttribute(name.toUpperCase(Locale.ROOT));
    }

    @Function
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return ((Element)this.getSubject()).hasAttributeNS(namespaceURI, localName);
    }

    @Property(name="id", accessor=Property.Kind.Getter)
    public String getId() {
        return this.doGetAttribute(ATTR_ID);
    }

    @Property(name="id", accessor=Property.Kind.Setter)
    public void setId(String id) {
        this.doSetAttribute(ATTR_ID, id);
    }

    @Property(name="title", accessor=Property.Kind.Getter)
    public String getTitle() {
        return this.doGetAttribute(ATTR_TITLE);
    }

    @Property(name="title", accessor=Property.Kind.Setter)
    public void setTitle(String title) {
        this.doSetAttribute(ATTR_TITLE, title);
    }

    @Property(name="lang", accessor=Property.Kind.Getter)
    public String getLang() {
        return this.doGetAttribute(ATTR_LANG);
    }

    @Property(name="lang", accessor=Property.Kind.Setter)
    public void setLang(String lang) {
        this.doSetAttribute(ATTR_LANG, lang);
    }

    @Property(name="dir", accessor=Property.Kind.Getter)
    public String getDir() {
        return this.doGetAttribute(ATTR_DIR);
    }

    @Property(name="dir", accessor=Property.Kind.Setter)
    public void setDir(String dir) {
        this.doSetAttribute(ATTR_DIR, dir);
    }

    @Property(name="name", accessor=Property.Kind.Getter)
    public String getName() {
        return this.doGetAttribute(ATTR_NAME);
    }

    @Property(name="name", accessor=Property.Kind.Setter)
    public void setName(String name) {
        this.doSetAttribute(ATTR_NAME, name);
    }

    @Property(name="className", accessor=Property.Kind.Getter)
    public String getClassName2() {
        return this.doGetAttribute("class");
    }

    @Property(name="className", accessor=Property.Kind.Setter)
    public void setClassName(String className) {
        this.doSetAttribute("class", className.trim());
    }

    @Property(name="innerHTML", accessor=Property.Kind.Getter)
    public String getInnerHTML() {
        return HTMLUtils.getOuterHTML(((Element)this.getSubject()).getChildNodes());
    }

    @Property(name="innerHTML", accessor=Property.Kind.Setter)
    public void setInnerHTML(String html) {
        html = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<doc>" + html + "</doc>";
        Element element = (Element)this.getSubject();
        Document ownerDocument = element.getOwnerDocument();
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(DOMElementScriptType.getEntityResolver());
            Document innerDocument = documentBuilder.parse(new ByteArrayInputStream(html.getBytes("UTF-8")));
            NodeList newChildNodes = ownerDocument.importNode(innerDocument.getDocumentElement(), true).getChildNodes();
            HTMLUtils.toUpperCase(newChildNodes);
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            while (newChildNodes.getLength() > 0) {
                element.appendChild(newChildNodes.item(0));
            }
        }
        catch (ParserConfigurationException e) {
            ScriptEnginePlugin.log(e);
            Context.reportRuntimeError((String)"Failed to set innerHTML. See log.");
        }
        catch (UnsupportedEncodingException e) {
            ScriptEnginePlugin.log(e);
            Context.reportRuntimeError((String)"Failed to set innerHTML. See log.");
        }
        catch (SAXException e) {
            ScriptEnginePlugin.log(e);
            Context.reportRuntimeError((String)"Failed to set innerHTML. See log.");
        }
        catch (IOException e) {
            ScriptEnginePlugin.log(e);
            Context.reportRuntimeError((String)"Failed to set innerHTML. See log.");
        }
    }

    @Property(name="disabled", accessor=Property.Kind.Getter)
    public boolean getDisabled() {
        return this.doGetBooleanAttribute(ATTR_DISABLED);
    }

    @Property(name="disabled", accessor=Property.Kind.Setter)
    public void setDisabled(boolean isDisabled) {
        this.doSetAttribute(ATTR_DISABLED, isDisabled);
    }

    @Property(name="checked", accessor=Property.Kind.Getter)
    public boolean getChecked() {
        return this.doGetBooleanAttribute(ATTR_CHECKED);
    }

    @Property(name="checked", accessor=Property.Kind.Setter)
    public void setChecked(boolean isChecked) {
        this.doSetAttribute(ATTR_CHECKED, isChecked);
    }

    @Property(name="selected", accessor=Property.Kind.Getter)
    public boolean getSelected() {
        return this.doGetBooleanAttribute(ATTR_SELECTED);
    }

    @Property(name="selected", accessor=Property.Kind.Setter)
    public void setSelected(boolean isSelected) {
        this.doSetAttribute(ATTR_SELECTED, isSelected);
    }

    @Property(name="type", accessor=Property.Kind.Getter)
    public String getType() {
        return this.doGetAttribute(ATTR_TYPE);
    }

    @Property(name="type", accessor=Property.Kind.Setter)
    public void setType(String type) {
        this.doSetAttribute(ATTR_TYPE, type);
    }

    @Property(name="value", accessor=Property.Kind.Getter)
    public String getValue() {
        return this.doGetAttribute(ATTR_VALUE);
    }

    @Property(name="value", accessor=Property.Kind.Setter)
    public void setValue(String value) {
        this.doSetAttribute(ATTR_VALUE, value);
    }

    @Property(name="src", accessor=Property.Kind.Getter)
    public String getSrc() {
        return this.doGetAttribute(ATTR_SRC);
    }

    @Property(name="src", accessor=Property.Kind.Setter)
    public void setSrc(String src) {
        this.doSetAttribute(ATTR_SRC, src);
    }

    @Property(name="href", accessor=Property.Kind.Getter)
    public String getHref() {
        return this.doGetAttribute(ATTR_HREF);
    }

    @Property(name="href", accessor=Property.Kind.Setter)
    public void setHref(String src) {
        this.doSetAttribute(ATTR_HREF, src);
    }

    @Property(name="colSpan", accessor=Property.Kind.Getter)
    public Integer getColSpan() {
        try {
            return Integer.parseInt(this.doGetAttribute(ATTR_COLSPAN));
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Property(name="colSpan", accessor=Property.Kind.Setter)
    public void setColSpan(Integer colSpan) {
        this.doSetAttribute(ATTR_COLSPAN, colSpan);
    }

    @Property(name="tabIndex", accessor=Property.Kind.Getter)
    public int getTabIndex() {
        try {
            return Integer.parseInt(this.doGetAttribute(ATTR_TABINDEX));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Property(name="tabIndex", accessor=Property.Kind.Setter)
    public void setTabIndex(int tabIndex) {
        this.doSetAttribute(ATTR_TABINDEX, tabIndex);
    }

    @Property(name="sheet", accessor=Property.Kind.Getter)
    public DOMCSSStyleSheetScriptType getSheet() {
        if (this.fStyleSheet == null && "STYLE".equals(this.getTagName())) {
            this.fStyleSheet = IScriptEnvironment.CURRENT.execute(new IScriptRunnable<DOMCSSStyleSheetScriptType, RuntimeException>(){

                @Override
                public DOMCSSStyleSheetScriptType run(Context cx, Scriptable scope) throws RuntimeException {
                    return new DOMCSSStyleSheetScriptType(cx, scope, (Element)DOMElementScriptType.this.getSubject());
                }
            });
        }
        return this.fStyleSheet;
    }

    @Function
    public Object getBoundingClientRect() throws DOMException {
        NativeObject obj = new NativeObject();
        ScriptableObject.putProperty((Scriptable)obj, (String)"bottom", (Object)0);
        ScriptableObject.putProperty((Scriptable)obj, (String)"height", (Object)10);
        ScriptableObject.putProperty((Scriptable)obj, (String)"left", (Object)10);
        ScriptableObject.putProperty((Scriptable)obj, (String)"right", (Object)20);
        ScriptableObject.putProperty((Scriptable)obj, (String)"top", (Object)0);
        ScriptableObject.putProperty((Scriptable)obj, (String)"width", (Object)10);
        ScriptableObject.putProperty((Scriptable)obj, (String)"height", (Object)0);
        return obj;
    }

    @Function
    public void blur() {
        Event event = this.createEvent();
        event.initEvent("blur", true, true);
        this.dispatchEvent(event);
    }

    @Function
    public void click() {
        Event event = this.createEvent();
        event.initEvent("click", true, true);
        this.dispatchEvent(event);
    }

    @Function
    public void focus() {
        Event event = this.createEvent();
        event.initEvent("focus", true, true);
        this.dispatchEvent(event);
    }

    @Function
    public void submit() {
        Event event = this.createEvent();
        event.initEvent("submit", true, true);
        this.dispatchEvent(event);
    }

    @Function
    public void select() {
    }

    @Function
    public void scrollIntoView() {
    }

    private String doGetAttribute(String name) {
        return ((Element)this.getSubject()).getAttribute(name.toUpperCase(Locale.ROOT));
    }

    private boolean doGetBooleanAttribute(String name) {
        String value = ((Element)this.getSubject()).getAttribute(name.toUpperCase(Locale.ROOT));
        return value != null && !"false".equalsIgnoreCase(value);
    }

    private void doSetAttribute(String name, String value) {
        ((Element)this.getSubject()).setAttribute(name.toUpperCase(Locale.ROOT), value);
    }

    private void doSetAttribute(String name, boolean value) {
        ((Element)this.getSubject()).setAttribute(name.toUpperCase(Locale.ROOT), Boolean.toString(value));
    }

    private void doSetAttribute(String name, Number value) {
        ((Element)this.getSubject()).setAttribute(name.toUpperCase(Locale.ROOT), value.toString());
    }

    private static EntityResolver getEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                try {
                    URL documentSkelettonUrl = Platform.getBundle((String)"com.ibm.team.rtc.common.scriptengine").getEntry("resources/browser/entities.dtd");
                    URLConnection connection = documentSkelettonUrl.openConnection();
                    return new InputSource(connection.getInputStream());
                }
                catch (IOException e) {
                    ScriptEnginePlugin.log(e);
                    return null;
                }
            }
        };
    }
}

