/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.browser;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.annotation.Function;
import com.ibm.team.rtc.common.scriptengine.annotation.Property;
import com.ibm.team.rtc.common.scriptengine.annotation.WrapType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMNodeScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMViewCSSScriptType;
import java.util.Locale;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

@Stub(value="DOMDocument")
@WrapType(value=Document.class)
public class DOMDocumentScriptType
extends DOMNodeScriptType {
    private DOMViewCSSScriptType fDefaultView;

    public DOMDocumentScriptType(Context cx, Scriptable scope, Document subject) {
        super(cx, scope, subject);
    }

    public DocumentType getDoctype() {
        return ((Document)this.getSubject()).getDoctype();
    }

    public DOMImplementation getImplementation() {
        return ((Document)this.getSubject()).getImplementation();
    }

    @Property(name="defaultView", accessor=Property.Kind.Getter)
    public DOMViewCSSScriptType getDefaultView() {
        if (this.fDefaultView == null) {
            this.fDefaultView = IScriptEnvironment.CURRENT.execute(new IScriptRunnable<DOMViewCSSScriptType, RuntimeException>(){

                @Override
                public DOMViewCSSScriptType run(Context cx, Scriptable scope) throws RuntimeException {
                    return new DOMViewCSSScriptType(cx, scope, (Document)DOMDocumentScriptType.this.getSubject());
                }
            });
        }
        return this.fDefaultView;
    }

    @Property(name="documentElement", accessor=Property.Kind.Getter)
    public Element getDocumentElement() {
        return ((Document)this.getSubject()).getDocumentElement();
    }

    @Property(name="body", accessor=Property.Kind.Getter)
    public Element getBody() {
        return (Element)((Document)this.getSubject()).getElementsByTagName("BODY").item(0);
    }

    @Function
    public Element createElement(String tagName) throws DOMException {
        return ((Document)this.getSubject()).createElement(tagName.toUpperCase(Locale.ROOT));
    }

    @Function
    public DocumentFragment createDocumentFragment() {
        return ((Document)this.getSubject()).createDocumentFragment();
    }

    @Function
    public Text createTextNode(String data) {
        return ((Document)this.getSubject()).createTextNode(data);
    }

    @Function
    public Comment createComment(String data) {
        return ((Document)this.getSubject()).createComment(data);
    }

    @Function
    public CDATASection createCDATASection(String data) throws DOMException {
        return ((Document)this.getSubject()).createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return ((Document)this.getSubject()).createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return ((Document)this.getSubject()).createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return ((Document)this.getSubject()).createEntityReference(name);
    }

    @Function
    public NodeList getElementsByTagName(String tagname) {
        return ((Document)this.getSubject()).getElementsByTagName(tagname.toUpperCase(Locale.ROOT));
    }

    @Function
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return ((Document)this.getSubject()).importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return ((Document)this.getSubject()).createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return ((Document)this.getSubject()).createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return ((Document)this.getSubject()).getElementsByTagNameNS(namespaceURI, localName);
    }

    @Function
    public Element getElementById(String elementId) {
        return this.doGetElementById(((Document)this.getSubject()).getDocumentElement(), elementId);
    }

    private Element doGetElementById(Element candidateElement, String elementId) {
        if (elementId.equals(candidateElement.getAttribute("ID"))) {
            return candidateElement;
        }
        NodeList children = candidateElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element result;
            Node item = children.item(i);
            if (item instanceof Element && (result = this.doGetElementById((Element)item, elementId)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public String getInputEncoding() {
        return ((Document)this.getSubject()).getInputEncoding();
    }

    public String getXmlEncoding() {
        return ((Document)this.getSubject()).getXmlEncoding();
    }

    public boolean getXmlStandalone() {
        return ((Document)this.getSubject()).getXmlStandalone();
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        ((Document)this.getSubject()).setXmlStandalone(xmlStandalone);
    }

    public String getXmlVersion() {
        return ((Document)this.getSubject()).getXmlVersion();
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        ((Document)this.getSubject()).setXmlVersion(xmlVersion);
    }

    public boolean getStrictErrorChecking() {
        return ((Document)this.getSubject()).getStrictErrorChecking();
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        ((Document)this.getSubject()).setStrictErrorChecking(strictErrorChecking);
    }

    public String getDocumentURI() {
        return ((Document)this.getSubject()).getDocumentURI();
    }

    public void setDocumentURI(String documentURI) {
        ((Document)this.getSubject()).setDocumentURI(documentURI);
    }

    @Function
    public Node adoptNode(Node source) throws DOMException {
        return ((Document)this.getSubject()).adoptNode(source);
    }

    public DOMConfiguration getDomConfig() {
        return ((Document)this.getSubject()).getDomConfig();
    }

    public void normalizeDocument() {
        ((Document)this.getSubject()).normalizeDocument();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return ((Document)this.getSubject()).renameNode(n, namespaceURI, qualifiedName);
    }
}

