/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment.browser;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverter;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.environment.browser.BrowserTypeFeature;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMAttrScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMCSSStyleDeclarationScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMCSSStyleRuleScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMCSSStyleSheetScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMCharacterDataScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMDocumentScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMElementScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMEventScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMNamedNodeMap;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMNodeListScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMNodeScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMStyleScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMTextScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.DOMViewCSSScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.browser.EventManager;
import com.ibm.team.rtc.common.scriptengine.environment.browser.HTMLUtils;
import com.ibm.team.rtc.common.scriptengine.environment.browser.ScriptExecutionManager;
import com.ibm.team.rtc.common.scriptengine.environment.browser.XMLHttpRequestScriptType;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.DojoFeature;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.IDependencyResolver;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.ITypeResolver;
import com.ibm.team.rtc.common.scriptengine.internal.DojoScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.xml.sax.SAXException;

public class BrowserDojoFeature
extends DojoFeature {
    private ScriptableObject fWindowObject;
    private ScriptableObject fNavigatorObject;
    private ScriptableObject fLocationObject;
    private ScriptableObject fLocalStorage;
    private URL fCurrentLocation;
    private Document fDocument;
    private final BrowserTypeFeature[] fBrowserFeatures = new BrowserTypeFeature[]{new BrowserTypeFeature(DOMNodeScriptType.class), new BrowserTypeFeature(DOMAttrScriptType.class), new BrowserTypeFeature(DOMCharacterDataScriptType.class), new BrowserTypeFeature(DOMTextScriptType.class), new BrowserTypeFeature(DOMNamedNodeMap.class), new BrowserTypeFeature(DOMDocumentScriptType.class), new BrowserTypeFeature(DOMElementScriptType.class), new BrowserTypeFeature(DOMEventScriptType.class), new BrowserTypeFeature(DOMNodeListScriptType.class), new BrowserTypeFeature(DOMStyleScriptType.class), new BrowserTypeFeature(DOMViewCSSScriptType.class), new BrowserTypeFeature(DOMCSSStyleDeclarationScriptType.class), new BrowserTypeFeature(DOMCSSStyleSheetScriptType.class), new BrowserTypeFeature(DOMCSSStyleRuleScriptType.class), new BrowserTypeFeature(XMLHttpRequestScriptType.class)};
    private ScriptExecutionManager fScriptExecutionManager;

    public BrowserDojoFeature(ITypeResolver ... typeResolvers) {
        this(Collections.emptyList(), typeResolvers);
    }

    public BrowserDojoFeature(Collection<IDependencyResolver> dependencyResolvers, ITypeResolver ... typeResolvers) {
        super(dependencyResolvers, typeResolvers);
        try {
            URL documentSkelettonUrl = Platform.getBundle((String)"com.ibm.team.rtc.common.scriptengine").getEntry("resources/browser/default.html");
            URLConnection connection = documentSkelettonUrl.openConnection();
            this.fDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(connection.getInputStream());
            HTMLUtils.toUpperCase(this.fDocument.getChildNodes());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        try {
            this.fCurrentLocation = new URL("https://localhost:9443/jazz");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean isOnBrowser() {
        return true;
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        if (type == ScriptExecutionManager.class) {
            return type.cast(this.fScriptExecutionManager);
        }
        return super.getAdapter(type);
    }

    public void setDocument(Document document) {
        this.fDocument = document;
    }

    public Document getDocument() {
        return this.fDocument;
    }

    @Override
    public void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        this.fScriptExecutionManager = new ScriptExecutionManager(scriptEnvironment);
        super.define(cx, scope, scriptEnvironment);
    }

    @Override
    protected void configureEnvironment(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        BrowserTypeFeature feature;
        DojoScriptTypeConverterFactory converterFactory = (DojoScriptTypeConverterFactory)scriptEnvironment.adapt(IScriptTypeConverterFactory.class);
        BrowserTypeFeature[] browserTypeFeatureArray = this.fBrowserFeatures;
        int n = this.fBrowserFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            feature = browserTypeFeatureArray[n2];
            converterFactory.registerWrapper(feature.getFacadeClass());
            feature.define(cx, scope, scriptEnvironment);
            ++n2;
        }
        browserTypeFeatureArray = this.fBrowserFeatures;
        n = this.fBrowserFeatures.length;
        n2 = 0;
        while (n2 < n) {
            feature = browserTypeFeatureArray[n2];
            feature.initialize(cx, scope, scriptEnvironment);
            ++n2;
        }
        this.defineWindowObject(cx, scope, scriptEnvironment);
        this.defineNavigatorObject(cx, scope, scriptEnvironment);
        this.defineLocationObject(cx, scope, scriptEnvironment);
        this.defineLocalStorage(cx, scope, scriptEnvironment);
        this.defineDocumentObject(cx, scope, scriptEnvironment);
        super.configureEnvironment(cx, scope, scriptEnvironment);
    }

    @Override
    protected void configureDojo(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        super.configureDojo(cx, scope, scriptEnvironment);
        Scriptable dojoConfig = (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"dojoConfig");
        Scriptable has = (Scriptable)ScriptableObject.getProperty((Scriptable)dojoConfig, (String)"has");
        ScriptableObject.putProperty((Scriptable)has, (String)"dom-qsa3", (Object)0);
        ScriptableObject.putProperty((Scriptable)has, (String)"dom-addeventlistener", (Object)1);
        ScriptableObject.putProperty((Scriptable)dojoConfig, (String)"isDebug", (Object)false);
        ScriptableObject.putProperty((Scriptable)dojoConfig, (String)"usePlainJson", (Object)true);
        ScriptableObject.putProperty((Scriptable)dojoConfig, (String)"localizationComplete", (Object)false);
        ScriptableObject.putProperty((Scriptable)dojoConfig, (String)"deps", (Object)new NativeArray((Object[])new String[]{"dojo/_base/url", "dojo/_base/html", "dojo/io-query"}));
        ScriptableObject ajax = (ScriptableObject)cx.newObject(scope);
        ScriptableObject.putProperty((Scriptable)ajax, (String)"_contextRoot", (Object)"/");
        ScriptableObject.putProperty((Scriptable)ajax, (String)"_webuiPrefix", (Object)"/web/");
        ScriptableObject jazz = (ScriptableObject)cx.newObject(scope);
        ScriptableObject.putProperty((Scriptable)jazz, (String)"ajax", (Object)ajax);
        ScriptableObject net = (ScriptableObject)cx.newObject(scope);
        ScriptableObject.putProperty((Scriptable)net, (String)"jazz", (Object)jazz);
        ScriptableObject.putProperty((Scriptable)scope, (String)"net", (Object)net);
        ScriptableObject.putProperty((Scriptable)scope, (String)"JSON", (Object)Undefined.instance);
    }

    @Override
    protected void defineDojoExtensions(Context cx, Scriptable scope, final IScriptEnvironment scriptEnvironment) {
        super.defineDojoExtensions(cx, scope, scriptEnvironment);
        Scriptable dojo = (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"dojo");
        cx.evaluateString(scope, "var ioQuery= require('dojo/io-query'); dojo.objectToQuery= ioQuery.objectToQuery; dojo.queryToObject= ioQuery.queryToObject;", "", 0, null);
        ScriptableObject.putProperty((Scriptable)dojo, (String)"isBrowser", (Object)true);
        ScriptableObject.putProperty((Scriptable)dojo, (String)"addOnWindowUnload", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return null;
            }
        });
        ScriptableObject.putProperty((Scriptable)dojo, (String)"_xhrObj", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return new XMLHttpRequestScriptType(cx, scope);
            }
        });
        ScriptableObject.putProperty((Scriptable)dojo, (String)"_isDocumentOk", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                XMLHttpRequestScriptType http = scriptEnvironment.adapt(IScriptingHelper.class).convertToJava(args[0], XMLHttpRequestScriptType.class);
                if ((http.getStatus() < 200 || http.getStatus() > 300) && http.getStatus() != 304) {
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected void configureLiveConnect(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
    }

    private void defineWindowObject(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        this.fWindowObject = (ScriptableObject)scope;
        ScriptableObject.putProperty((Scriptable)scope, (String)"window", (Object)this.fWindowObject);
        final EventManager eventManager = new EventManager((Scriptable)this.fWindowObject, scriptEnvironment);
        final ArrayList jobs = new ArrayList();
        this.addFunction(this.fWindowObject, "setTimeout", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                Function fn = (Function)args[0];
                long timeout = args.length > 1 ? (long)Context.toNumber((Object)args[1]) : 0L;
                jobs.add(BrowserDojoFeature.this.fScriptExecutionManager.submit((Scriptable)BrowserDojoFeature.this.fWindowObject, (Callable)fn, timeout));
                return jobs.size() - 1;
            }
        });
        this.addFunction(this.fWindowObject, "setInterval", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                final Function fn = (Function)args[0];
                final long timeout = args.length > 1 ? (long)Context.toNumber((Object)args[1]) : 0L;
                final int jobId = jobs.size();
                Callable repeatable = new Callable(){

                    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                        jobs.set(jobId, BrowserDojoFeature.this.fScriptExecutionManager.submit(thisObj, this, timeout));
                        return fn.call(cx, scope, thisObj, args);
                    }
                };
                jobs.add(BrowserDojoFeature.this.fScriptExecutionManager.submit((Scriptable)BrowserDojoFeature.this.fWindowObject, repeatable, timeout));
                return jobId;
            }
        });
        this.addFunction(this.fWindowObject, "clearInterval", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                BrowserDojoFeature.this.fScriptExecutionManager.remove((ScriptExecutionManager.FunctionSubmission)jobs.get(ScriptRuntime.toInt32((Object[])args, (int)0)));
                return Undefined.instance;
            }
        });
        this.addFunction(this.fWindowObject, "clearTimeout", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                BrowserDojoFeature.this.fScriptExecutionManager.remove((ScriptExecutionManager.FunctionSubmission)jobs.get(ScriptRuntime.toInt32((Object[])args, (int)0)));
                return Undefined.instance;
            }
        });
        this.addFunction(this.fWindowObject, "addEventListener", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                eventManager.addEventListener((String)args[0], (Function)args[1]);
                return Undefined.instance;
            }
        });
        this.addFunction(this.fWindowObject, "removeEventListener", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                eventManager.removeEventListener((String)args[0], (Function)args[1]);
                return Undefined.instance;
            }
        });
        final IScriptTypeConverter eventConverter = scriptEnvironment.adapt(IScriptTypeConverterFactory.class).getConverter(Event.class);
        this.addFunction(this.fWindowObject, "dispatchEvent", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                eventManager.dispatchEvent((Event)eventConverter.toJava(cx, scope, args[0]));
                return Undefined.instance;
            }
        });
        final IScriptTypeConverter elementConverter = scriptEnvironment.adapt(IScriptTypeConverterFactory.class).getConverter(Element.class);
        this.addFunction(this.fWindowObject, "Image", (Function)new BaseFunction(){

            public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
                return (Scriptable)elementConverter.toScript(cx, scope, BrowserDojoFeature.this.fDocument.createElement("img"));
            }
        });
        this.addFunction(this.fWindowObject, "getSelection", (Function)new BaseFunction(){

            public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
                return null;
            }
        });
        this.addFunction(this.fWindowObject, "getComputedStyle", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                String width = null;
                String height = null;
                String display = null;
                if (args[0] != null) {
                    DOMElementScriptType element = (DOMElementScriptType)args[0];
                    DOMStyleScriptType styles = element.getStyles();
                    display = (String)styles.getProperty("display", scope);
                    width = (String)styles.getProperty("width", scope);
                    height = (String)styles.getProperty("height", scope);
                }
                return BrowserDojoFeature.this.getStyleObject(cx, scope, width, height, display);
            }
        });
    }

    private ScriptableObject getStyleObject(Context cx, Scriptable scope, String width, String height, String display) {
        if (width == null) {
            width = "-1";
        }
        if (height == null) {
            height = "-1";
        }
        if (display == null) {
            display = "none";
        }
        ScriptableObject style = (ScriptableObject)cx.newObject(scope);
        ScriptableObject.putProperty((Scriptable)style, (String)"width", (Object)width);
        ScriptableObject.putProperty((Scriptable)style, (String)"height", (Object)height);
        ScriptableObject.putProperty((Scriptable)style, (String)"display", (Object)display);
        return style;
    }

    private void defineNavigatorObject(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        this.fNavigatorObject = (ScriptableObject)cx.newObject(scope);
        ScriptableObject.putProperty((Scriptable)this.fNavigatorObject, (String)"userAgent", (Object)"Mozilla/5.0 (X11; Linux x86_64; rv:17.0) Gecko/20100101 Firefox/17.0");
        ScriptableObject.putProperty((Scriptable)this.fNavigatorObject, (String)"platform", (Object)"Linux x86_64");
        ScriptableObject.putProperty((Scriptable)this.fWindowObject, (String)"navigator", (Object)this.fNavigatorObject);
    }

    private void defineLocationObject(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        this.fLocationObject = (ScriptableObject)cx.newObject(scope);
        this.addGetter(this.fLocationObject, "href", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return BrowserDojoFeature.this.fCurrentLocation.toString();
            }
        });
        this.addGetter(this.fLocationObject, "protocol", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return String.valueOf(BrowserDojoFeature.this.fCurrentLocation.getProtocol()) + ":";
            }
        });
        this.addGetter(this.fLocationObject, "host", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return BrowserDojoFeature.this.fCurrentLocation.getHost();
            }
        });
        this.addGetter(this.fLocationObject, "search", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return "";
            }
        });
        this.addGetter(this.fLocationObject, "hash", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return "";
            }
        });
        this.addGetter(this.fWindowObject, "location", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return BrowserDojoFeature.this.fLocationObject;
            }
        });
        this.addSetter(this.fWindowObject, "location", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return args[0];
            }
        });
    }

    private void defineLocalStorage(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        this.fLocalStorage = (ScriptableObject)cx.newObject(scope);
        this.addFunction(this.fLocalStorage, "key", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length != 1 || !(args[0] instanceof Number)) {
                    throw new IllegalArgumentException("Function must contian one argument only and it has to be a number");
                }
                Integer id = ((Number)args[0]).intValue();
                List ids = BrowserDojoFeature.this.getKeys(BrowserDojoFeature.this.fLocalStorage);
                if (id >= 0 && id < ids.size()) {
                    return ids.get(id);
                }
                return null;
            }
        });
        this.addFunction(this.fLocalStorage, "setItem", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length != 2 || !(args[0] instanceof String) || !(args[1] instanceof String)) {
                    throw new IllegalArgumentException("Function must contian two arguments only and both have to be Strings");
                }
                ScriptableObject.putProperty((Scriptable)BrowserDojoFeature.this.fLocalStorage, (String)((String)args[0]), (Object)((String)args[1]));
                return Undefined.instance;
            }
        });
        this.addFunction(this.fLocalStorage, "getItem", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length != 1 || !(args[0] instanceof String)) {
                    throw new IllegalArgumentException("Function must contian one arguments only and have to be a Strings");
                }
                return ScriptableObject.hasProperty((Scriptable)BrowserDojoFeature.this.fLocalStorage, (String)((String)args[0])) ? ScriptableObject.getProperty((Scriptable)BrowserDojoFeature.this.fLocalStorage, (String)((String)args[0])) : null;
            }
        });
        this.addFunction(this.fLocalStorage, "removeItem", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length != 1 || !(args[0] instanceof String)) {
                    throw new IllegalArgumentException("Function must contian one arguments only and have to be a Strings");
                }
                ScriptableObject.deleteProperty((Scriptable)BrowserDojoFeature.this.fLocalStorage, (String)((String)args[0]));
                return Undefined.instance;
            }
        });
        this.addFunction(this.fLocalStorage, "clear", (Function)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                List keys = BrowserDojoFeature.this.getKeys(BrowserDojoFeature.this.fLocalStorage);
                for (String key : keys) {
                    ScriptableObject.deleteProperty((Scriptable)BrowserDojoFeature.this.fLocalStorage, (String)key);
                }
                return Undefined.instance;
            }
        });
        this.addGetter(this.fLocalStorage, "length", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return BrowserDojoFeature.this.getKeys(BrowserDojoFeature.this.fLocalStorage).size();
            }
        });
        this.addGetter(this.fWindowObject, "localStorage", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return BrowserDojoFeature.this.fLocalStorage;
            }
        });
    }

    private List<String> getKeys(ScriptableObject object) {
        Object[] keys = ScriptableObject.getPropertyIds((Scriptable)object);
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object property;
            Object key = objectArray[n2];
            if (!"length".equals(key) && !((property = ScriptableObject.getProperty((Scriptable)object, (String)((String)key))) instanceof Function)) {
                result.add((String)key);
            }
            ++n2;
        }
        return result;
    }

    private void defineDocumentObject(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        final IScriptTypeConverter documentConverter = scriptEnvironment.adapt(IScriptTypeConverterFactory.class).getConverter(Document.class);
        this.addSetter((ScriptableObject)scope, "document", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                Scriptable documentObject = (Scriptable)args[0];
                BrowserDojoFeature.this.fDocument = (Document)documentConverter.toJava(cx, scope, documentObject);
                HTMLUtils.toUpperCase(BrowserDojoFeature.this.fDocument.getChildNodes());
                return BrowserDojoFeature.this.ensureCookiesSet(documentObject);
            }
        });
        this.addGetter((ScriptableObject)scope, "document", new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                Scriptable documentObject = (Scriptable)documentConverter.toScript(cx, scope, BrowserDojoFeature.this.fDocument);
                return BrowserDojoFeature.this.ensureCookiesSet(documentObject);
            }
        });
    }

    private Scriptable ensureCookiesSet(Scriptable document) {
        Object property = ScriptableObject.getProperty((Scriptable)document, (String)"cookie");
        if (!(property instanceof String)) {
            System.out.println("Setting cookie to empty string");
            ScriptableObject.putProperty((Scriptable)document, (String)"cookie", (Object)"");
        }
        return document;
    }

    private void addFunction(ScriptableObject target, String methodName, Function function) {
        function.setParentScope((Scriptable)target);
        function.setPrototype(ScriptableObject.getFunctionPrototype((Scriptable)target));
        ScriptableObject.putProperty((Scriptable)target, (String)methodName, (Object)function);
    }

    private void addGetter(ScriptableObject target, String propertyName, BaseFunction accessor) {
        target.setGetterOrSetter(propertyName, 0, (Callable)accessor, false);
    }

    private void addSetter(ScriptableObject target, String propertyName, BaseFunction accessor) {
        target.setGetterOrSetter(propertyName, 0, (Callable)accessor, true);
    }
}

