/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment;

import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.UnknownTypeException;
import com.ibm.team.rtc.common.scriptengine.environment.AbstractScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import java.util.StringTokenizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class ScriptingHelperImplementation
implements IScriptingHelper {
    private Scriptable fScope;
    private Scriptable fObjectPrototype;
    private Scriptable fFunctionPrototype;
    private final AbstractScriptEnvironment fScriptEnvironment;

    public ScriptingHelperImplementation(Context cx, Scriptable scope, AbstractScriptEnvironment scriptEnvironment) {
        this.fScriptEnvironment = scriptEnvironment;
        this.fScope = scope;
    }

    @Override
    public Scriptable getGlobalScope() {
        return this.fScope;
    }

    @Override
    public Scriptable createSimpleObject() {
        NativeObject result = new NativeObject();
        this.initPrototypeAndScope((Scriptable)result);
        return result;
    }

    @Override
    public Object convertToScript(final Object javaObject, final Class<?> type) {
        return this.fScriptEnvironment.execute(new IScriptRunnable<Object, RuntimeException>(){

            @Override
            public Object run(Context cx, Scriptable scope) throws RuntimeException {
                if (javaObject == null) {
                    return ScriptingHelperImplementation.this.fScriptEnvironment.adapt(IScriptTypeConverterFactory.class).getConverter(type).toScript(cx, scope, javaObject);
                }
                return ScriptingHelperImplementation.this.fScriptEnvironment.adapt(IScriptTypeConverterFactory.class).getConverter(javaObject.getClass(), type).toScript(cx, scope, javaObject);
            }
        });
    }

    @Override
    public <T> T convertToJava(final Object scriptObject, final Class<T> type) {
        return (T)this.fScriptEnvironment.execute(new IScriptRunnable<T, RuntimeException>(){

            @Override
            public T run(Context cx, Scriptable scope) throws RuntimeException {
                return ScriptingHelperImplementation.this.fScriptEnvironment.adapt(IScriptTypeConverterFactory.class).getConverter(type).toJava(cx, scope, scriptObject);
            }
        });
    }

    @Override
    public void initPrototypeAndScope(Scriptable object) {
        object.setParentScope(this.fScope);
        if (object instanceof Function) {
            if (this.fFunctionPrototype == null) {
                this.fFunctionPrototype = ScriptableObject.getFunctionPrototype((Scriptable)this.fScope);
            }
            object.setPrototype(this.fFunctionPrototype);
        } else {
            if (this.fObjectPrototype == null) {
                this.fObjectPrototype = ScriptableObject.getObjectPrototype((Scriptable)this.fScope);
            }
            object.setPrototype(this.fObjectPrototype);
        }
    }

    @Override
    public Object getObject(String name) {
        StringTokenizer nameTokenizer = new StringTokenizer(name, String.valueOf('.'));
        Scriptable current = ScriptableObject.getTopLevelScope((Scriptable)this.fScope);
        while (current != null) {
            String propertyName = nameTokenizer.nextToken();
            Object value = ScriptableObject.getProperty((Scriptable)current, (String)propertyName);
            if (value == null) {
                value = this.createSimpleObject();
                ScriptableObject.putProperty((Scriptable)current, (String)propertyName, (Object)value);
            }
            if (nameTokenizer.hasMoreTokens()) {
                current = value instanceof Scriptable ? (Scriptable)value : null;
                continue;
            }
            return value;
        }
        return null;
    }

    @Override
    public void setObject(String name, Object value) {
        StringTokenizer nameTokenizer = new StringTokenizer(name, String.valueOf('.'));
        Object current = ScriptableObject.getTopLevelScope((Scriptable)this.fScope);
        while (nameTokenizer.hasMoreTokens()) {
            String propertyName = nameTokenizer.nextToken();
            if (nameTokenizer.hasMoreTokens()) {
                Object child = ScriptableObject.getProperty((Scriptable)current, (String)propertyName);
                if (!(child instanceof Scriptable)) {
                    child = this.createSimpleObject();
                    ScriptableObject.putProperty((Scriptable)current, (String)propertyName, (Object)child);
                }
                current = child;
                continue;
            }
            ScriptableObject.putProperty((Scriptable)current, (String)propertyName, (Object)value);
        }
    }

    @Override
    public void dojoProvide(final String namespace) {
        this.fScriptEnvironment.execute(new IScriptRunnable<Void, RuntimeException>(){

            @Override
            public Void run(Context cx, Scriptable scope) throws RuntimeException {
                Scriptable dojoObject = (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"dojo");
                ScriptableObject.callMethod((Context)cx, (Scriptable)dojoObject, (String)"provide", (Object[])new Object[]{namespace});
                return null;
            }
        });
    }

    @Override
    public void dojoRequire(final String namespace) {
        this.fScriptEnvironment.execute(new IScriptRunnable<Void, RuntimeException>(){

            @Override
            public Void run(Context cx, Scriptable scope) throws RuntimeException {
                Scriptable dojoObject = (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"dojo");
                ScriptableObject.callMethod((Context)cx, (Scriptable)dojoObject, (String)"require", (Object[])new Object[]{namespace});
                return null;
            }
        });
    }

    @Override
    public Function getConstructor(String typeName) throws UnknownTypeException {
        Object ctorVal = this.getObject(typeName);
        if (!(ctorVal instanceof Function)) {
            this.dojoRequire(typeName);
            ctorVal = this.getObject(typeName);
        }
        if (ctorVal instanceof Function) {
            return (Function)ctorVal;
        }
        throw new UnknownTypeException(typeName);
    }
}

