/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptEnvironmentFeature;
import com.ibm.team.rtc.common.scriptengine.environment.browser.HTMLUtils;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import com.ibm.team.rtc.common.scriptengine.internal.bridge.wrapper.ObjectWrapper;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoggingFeature
implements IScriptEnvironmentFeature {
    @Override
    public void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        ScriptableObject console = (ScriptableObject)cx.newObject(scope);
        ScriptableObject.putProperty((Scriptable)console, (String)"debug", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return LoggingFeature.printArgs(1, "DEBUG", args, 0);
            }
        });
        ScriptableObject.putProperty((Scriptable)console, (String)"error", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return LoggingFeature.printArgs(4, "ERROR", args, 0);
            }
        });
        ScriptableObject.putProperty((Scriptable)console, (String)"info", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return LoggingFeature.printArgs(1, "INFO", args, 0);
            }
        });
        ScriptableObject.putProperty((Scriptable)console, (String)"warn", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return LoggingFeature.printArgs(2, "WARN", args, 0);
            }
        });
        ScriptableObject.putProperty((Scriptable)console, (String)"log", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return LoggingFeature.printArgs(1, "LOG", args, 0);
            }
        });
        ScriptableObject.putProperty((Scriptable)console, (String)"inspect", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                String message = (String)args[0];
                Object subject = args[1];
                System.out.println(message);
                return Undefined.instance;
            }
        });
        ScriptableObject.putProperty((Scriptable)scope, (String)"console", (Object)console);
    }

    private static Undefined printArgs(int severity, String preamble, Object[] args, int formatArg) {
        if (args.length > 0) {
            StringBuilder message = new StringBuilder();
            if (preamble != null) {
                message.append(preamble).append(": ");
            }
            if (args.length > formatArg + 1 && args[formatArg] instanceof String) {
                String format = (String)args[formatArg];
                Object[] formatArgs = new Object[args.length - 1 - formatArg];
                System.arraycopy(args, formatArg + 1, formatArgs, 0, formatArgs.length);
                message.append(String.format(format, formatArgs));
            } else {
                int i = 0;
                while (i < args.length) {
                    Object arg;
                    if (i > 0) {
                        message.append(", ");
                    }
                    if ((arg = args[i]) instanceof Wrapper) {
                        arg = ((Wrapper)arg).unwrap();
                    }
                    if (arg instanceof org.mozilla.javascript.Node) {
                        message.append(HTMLUtils.getOuterHTML((Node)arg, true));
                    } else if (arg instanceof NodeList) {
                        message.append(HTMLUtils.getOuterHTML((NodeList)arg, true));
                    } else {
                        HashSet<Object> alreadyPrinted = new HashSet<Object>();
                        LoggingFeature.printObject(arg, message, 0, alreadyPrinted);
                    }
                    ++i;
                }
            }
            ScriptEnginePlugin.log((IStatus)new Status(severity, "com.ibm.team.rtc.common.scriptengine", message.toString()));
        }
        return (Undefined)Undefined.instance;
    }

    private static void printObject(Object object, StringBuilder buf, int level, HashSet<Object> alreadyPrinted) {
        if (object == Undefined.instance) {
            buf.append("undefined");
        } else if (object == null) {
            buf.append("null");
        } else if (object instanceof String) {
            buf.append("'").append(object).append("'");
        } else if (object instanceof Number || object instanceof Boolean) {
            buf.append(object);
        } else if (object instanceof Object[]) {
            if (!alreadyPrinted.add(object)) {
                buf.append("[...]");
            } else {
                Object[] array = (Object[])object;
                if (array.length == 0) {
                    buf.append("[]");
                } else {
                    buf.append("[\n");
                    int i = 0;
                    while (i < array.length) {
                        LoggingFeature.appendIndent(buf, level + 1);
                        LoggingFeature.printObject(array[i], buf, level + 1, alreadyPrinted);
                        if (i < array.length - 1) {
                            buf.append(",");
                        }
                        buf.append("\n");
                        ++i;
                    }
                    LoggingFeature.appendIndent(buf, level);
                    buf.append("]");
                }
            }
        } else if (object instanceof ScriptableObject) {
            if (!alreadyPrinted.add(object)) {
                buf.append("{...}");
            } else {
                ScriptableObject scriptable = (ScriptableObject)object;
                Object[] propertyIds = ScriptableObject.getPropertyIds((Scriptable)scriptable);
                if (propertyIds.length == 0) {
                    buf.append("{}");
                } else {
                    buf.append("{\n");
                    int i = 0;
                    while (i < propertyIds.length) {
                        Object val;
                        Object id = propertyIds[i];
                        if (id instanceof String && !((val = ScriptableObject.getProperty((Scriptable)scriptable, (String)((String)id))) instanceof Function)) {
                            LoggingFeature.appendIndent(buf, level + 1);
                            buf.append(id).append(": ");
                            LoggingFeature.printObject(val, buf, level + 1, alreadyPrinted);
                            if (i < propertyIds.length - 1) {
                                buf.append(",");
                            }
                            buf.append("\n");
                        }
                        ++i;
                    }
                    Object exceptionWrapper = ScriptableObject.getProperty((Scriptable)scriptable, (String)"rhinoException");
                    if (exceptionWrapper instanceof ObjectWrapper) {
                        ObjectWrapper objectWrapper = (ObjectWrapper)exceptionWrapper;
                        StackTraceElement[] stacks = ((EcmaError)objectWrapper.unwrap()).getStackTrace();
                        LoggingFeature.appendIndent(buf, level);
                        buf.append("stack: ");
                        int i2 = 0;
                        while (i2 < stacks.length) {
                            LoggingFeature.appendIndent(buf, level + 1);
                            buf.append(stacks[i2].toString()).append("\n");
                            ++i2;
                        }
                    }
                    LoggingFeature.appendIndent(buf, level);
                    buf.append("}");
                }
            }
        }
    }

    private static StringBuilder appendIndent(StringBuilder buf, int level) {
        int i = 0;
        while (i < level) {
            buf.append("  ");
            ++i;
        }
        return buf;
    }
}

