/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment;

import com.ibm.team.rtc.common.scriptengine.environment.AbstractScriptFeature;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class FileScriptFeature
extends AbstractScriptFeature {
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String OSGI_SYMBOLIC_NAME = "OSGi.Bundle-SymbolicName";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private final URL fUrl;
    private final String fFileName;
    private long fLastModified = -1L;

    protected FileScriptFeature(URL url, String fileName) {
        this.fUrl = url;
        this.fFileName = fileName;
    }

    public static FileScriptFeature create(String bundleSymbolicName, IPath path) {
        return FileScriptFeature.create(Platform.getBundle((String)bundleSymbolicName), path);
    }

    public static FileScriptFeature create(Bundle bundle, IPath path) {
        URL url = FileScriptFeature.findFile(bundle, path);
        if (url == null) {
            return null;
        }
        return new FileScriptFeature(url, FileScriptFeature.buildFileName(bundle, path));
    }

    @Override
    protected boolean isOudated() throws IOException {
        if (super.isOudated()) {
            return true;
        }
        if (this.fLastModified == -1L) {
            return true;
        }
        URLConnection connection = this.fUrl.openConnection();
        return connection.getLastModified() > this.fLastModified;
    }

    @Override
    public Reader getInputReader() throws IOException {
        URLConnection connection = this.fUrl.openConnection();
        this.fLastModified = connection.getLastModified();
        String encoding = connection.getContentEncoding();
        return new InputStreamReader(connection.getInputStream(), encoding != null ? encoding : "UTF-8");
    }

    @Override
    public int getLineNumber() {
        return 1;
    }

    @Override
    public String getSourceName() {
        return this.fFileName;
    }

    protected static String buildFileName(Bundle bundle, IPath path) {
        StringBuilder sourceName = new StringBuilder();
        sourceName.append('{');
        FileScriptFeature.writeProperty(BUNDLE_SYMBOLIC_NAME, bundle.getSymbolicName(), sourceName).append(", ");
        FileScriptFeature.writeProperty(PATH, path.removeLastSegments(1).toOSString(), sourceName).append(", ");
        FileScriptFeature.writeProperty(NAME, path.lastSegment(), sourceName);
        sourceName.append('}');
        return sourceName.toString();
    }

    protected static URL findFile(Bundle bundle, IPath path) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        return url;
    }

    private static StringBuilder writeProperty(String key, String value, StringBuilder builder) {
        FileScriptFeature.writeString(key, builder);
        builder.append(":");
        FileScriptFeature.writeString(value, builder);
        return builder;
    }

    private static void writeString(String string, StringBuilder builder) {
        builder.append('\"');
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    builder.append('\\');
                    builder.append(c);
                    break;
                }
                case '\b': {
                    builder.append("\\b");
                    break;
                }
                case '\f': {
                    builder.append("\\f");
                    break;
                }
                case '\n': {
                    builder.append("\\n");
                    break;
                }
                case '\r': {
                    builder.append("\\r");
                    break;
                }
                case '\t': {
                    builder.append("\\t");
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        builder.append("\\u");
                        String hexString = Integer.toHexString(c);
                        int j = hexString.length();
                        while (j < 4) {
                            builder.append('0');
                            ++j;
                        }
                        builder.append(hexString);
                        break;
                    }
                    builder.append(c);
                }
            }
            ++i;
        }
        builder.append('\"');
    }
}

