/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment;

import com.ibm.team.rtc.common.scriptengine.environment.AbstractScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.environment.IAdaptableScriptEnvironmentFeature;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptEnvironmentFeature;
import com.ibm.team.rtc.common.scriptengine.internal.IScriptEnvironmentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class FeatureScriptEnvironment
extends AbstractScriptEnvironment {
    private final List<IScriptEnvironmentFeature> fFeatureList;
    private final IScriptEnvironmentContext fScriptEnvironmentContext;

    public FeatureScriptEnvironment(IScriptEnvironmentFeature[] features) {
        this(null, features);
    }

    public FeatureScriptEnvironment(IScriptEnvironmentContext context, IScriptEnvironmentFeature[] features) {
        this.fFeatureList = Arrays.asList(features);
        this.fScriptEnvironmentContext = new AdaptableFeatureContext(context, this.fFeatureList);
    }

    @Override
    protected void initializeScope(Context cx, ScriptableObject scope) throws Exception {
        for (IScriptEnvironmentFeature feature : this.fFeatureList) {
            feature.define(cx, (Scriptable)scope, this);
        }
    }

    @Override
    public <T> T adapt(Class<T> type) {
        T result = super.adapt(type);
        if (result != null) {
            return result;
        }
        if (IScriptEnvironmentContext.class.equals(type)) {
            return type.cast(this.fScriptEnvironmentContext);
        }
        return this.fScriptEnvironmentContext.get(type);
    }

    private class AdaptableFeatureContext
    implements IScriptEnvironmentContext {
        private final IScriptEnvironmentContext fContext;
        private final List<IAdaptableScriptEnvironmentFeature> fAdaptableFeatures;

        public AdaptableFeatureContext(IScriptEnvironmentContext context, List<IScriptEnvironmentFeature> featureList) {
            this.fContext = context;
            this.fAdaptableFeatures = new ArrayList<IAdaptableScriptEnvironmentFeature>();
            for (IScriptEnvironmentFeature environmentFeature : featureList) {
                if (!(environmentFeature instanceof IAdaptableScriptEnvironmentFeature)) continue;
                this.fAdaptableFeatures.add((IAdaptableScriptEnvironmentFeature)environmentFeature);
            }
        }

        @Override
        public <T> T get(Class<T> type) {
            for (IAdaptableScriptEnvironmentFeature adaptableFeature : this.fAdaptableFeatures) {
                T result = adaptableFeature.getAdapter(type);
                if (result == null) continue;
                return result;
            }
            return this.fContext != null ? (T)this.fContext.get(type) : null;
        }
    }
}

