/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.environment;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptEnvironmentSetupException;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptEnvironmentFeature;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import com.ibm.team.rtc.common.scriptengine.internal.scripts.DojoScriptTypeFeature;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.eclipse.osgi.util.NLS;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public abstract class AbstractScriptFeature
implements IScriptEnvironmentFeature {
    private static final String JAZZ_UI_POLYFILLS = "jazz.ui.polyfills";
    private Script fPrecompiledScript;

    @Override
    public void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) throws ScriptEnvironmentSetupException {
        this.evalScript(cx, scope, scriptEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalScript(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        Script script = null;
        AbstractScriptFeature abstractScriptFeature = this;
        synchronized (abstractScriptFeature) {
            try {
                if (this.isOudated() || this.fPrecompiledScript == null) {
                    if (ScriptEnginePlugin.TRACE_SCRIPT_COMPILATION) {
                        ScriptEnginePlugin.trace("AbstractScriptFeature: compile: %s", this.getSourceName());
                    }
                    this.fPrecompiledScript = cx.compileReader(this.getInputReader(), this.getSourceName(), this.getLineNumber(), null);
                }
                script = this.fPrecompiledScript;
            }
            catch (IOException e) {
                ScriptEnginePlugin.log(NLS.bind((String)"Unable to load file {0}", (Object)this.getSourceName()), e);
            }
        }
        if (script != null) {
            if (ScriptEnginePlugin.TRACE_SCRIPT_EXECUTION) {
                ScriptEnginePlugin.trace("AbstractScriptFeature: eval: %s", this.getSourceName());
            }
            try {
                return script.exec(cx, scope);
            }
            catch (EcmaError e) {
                ScriptEnginePlugin.log(NLS.bind((String)"Error executing script {0}", (Object)this.getSourceName()), e);
                if (JAZZ_UI_POLYFILLS.equals(this.getTypeName())) {
                    return null;
                }
                throw e;
            }
            catch (RuntimeException e) {
                ScriptEnginePlugin.log(NLS.bind((String)"Error executing script {0}", (Object)this.getSourceName()), e);
                throw e;
            }
        }
        return null;
    }

    public abstract String getSourceName();

    public abstract int getLineNumber();

    private String getTypeName() {
        if (this instanceof DojoScriptTypeFeature) {
            return ((DojoScriptTypeFeature)this).getProvidedTypeName();
        }
        return null;
    }

    public String getSource() throws IOException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(this.getInputReader());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
            int ch = reader.read();
            while (ch != -1) {
                writer.write(ch);
                ch = reader.read();
            }
            writer.flush();
            writer.close();
            String string = new String(output.toByteArray(), "UTF-8");
            return string;
        }
    }

    protected boolean isOudated() throws IOException {
        return ScriptEnginePlugin.ALWAYS_RECOMPILE_SCRIPTS;
    }

    protected abstract Reader getInputReader() throws IOException;

    protected static String createStringFromInputStream(InputStream input, String contentEncoding) throws IOException {
        try {
            if (contentEncoding == null) {
                contentEncoding = "UTF-8";
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, contentEncoding));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
            int ch = reader.read();
            while (ch != -1) {
                writer.write(ch);
                ch = reader.read();
            }
            writer.flush();
            writer.close();
            String string = new String(output.toByteArray(), "UTF-8");
            return string;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

