/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine;

import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.ScriptEnvironmentSetupException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;

public interface IScriptEnvironment {
    public static final ContextFactory fgContextFactory = new ContextFactory();
    public static final CurrentEnvironmentAccessor CURRENT = new CurrentEnvironmentAccessor();

    public <V, E extends Exception> V execute(IScriptRunnable<V, E> var1) throws E, ScriptEnvironmentSetupException;

    public <T> T adapt(Class<T> var1);

    public void cleanup();

    public static final class CurrentEnvironmentAccessor {
        public static final Object ENVIRONMENT_KEY = new Object();
        public static final Object SCOPE_KEY = new Object();

        public <V, E extends Exception> V execute(IScriptRunnable<V, E> code) throws E {
            Context cx = Context.getCurrentContext();
            if (cx == null) {
                throw new RuntimeException("No currently active script environment");
            }
            Scriptable scope = (Scriptable)cx.getThreadLocal(SCOPE_KEY);
            return code.run(cx, scope);
        }

        public IScriptEnvironment getScriptEnvironment() {
            Context cx = Context.getCurrentContext();
            return cx != null ? (IScriptEnvironment)cx.getThreadLocal(ENVIRONMENT_KEY) : null;
        }

        public <T> T adapt(Class<T> type) {
            IScriptEnvironment scriptEnvironment = this.getScriptEnvironment();
            return scriptEnvironment != null ? (T)scriptEnvironment.adapt(type) : null;
        }
    }
}

