/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class AbstractScriptable
implements Scriptable {
    protected final Map<String, PropertyContainer> fProperties = new ConcurrentHashMap<String, PropertyContainer>();
    private Scriptable fParentScope;
    private Scriptable fPrototype;

    public void defineProperty(String name, Object value, EnumSet<PropertyAttribute> attributes) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        if (propertyContainer == null || !propertyContainer.isAttribute(PropertyAttribute.READONLY)) {
            this.fProperties.put(name, new ValuePropertyContainer(value, attributes));
        }
    }

    public void defineProperty(String name, PropertyAccessor propertyAccessor, EnumSet<PropertyAttribute> attributes) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        if (propertyContainer == null || !propertyContainer.isAttribute(PropertyAttribute.READONLY)) {
            this.fProperties.put(name, new PropertyAccessorPropertyContainer(propertyAccessor, attributes));
        }
    }

    public Scriptable getParentScope() {
        return this.fParentScope;
    }

    public void setParentScope(Scriptable parent) {
        this.fParentScope = parent;
    }

    public Scriptable getPrototype() {
        return this.fPrototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.fPrototype = prototype;
    }

    public Object get(int index, Scriptable start) {
        return this.get(Integer.toString(index), start);
    }

    public Object get(String name, Scriptable start) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        return propertyContainer != null ? propertyContainer.getValue(start) : Scriptable.NOT_FOUND;
    }

    public boolean has(int index, Scriptable start) {
        return this.has(Integer.toString(index), start);
    }

    public boolean has(String name, Scriptable start) {
        return this.fProperties.containsKey(name);
    }

    public void put(int index, Scriptable start, Object value) {
        this.put(Integer.toString(index), start, value);
    }

    public void put(String name, Scriptable start, Object value) {
        if (!this.doPut(name, start, value)) {
            Assert.isTrue((start != this ? 1 : 0) != 0);
            start.put(name, start, value);
        }
    }

    private boolean doPut(String name, Scriptable start, Object value) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        if (propertyContainer == null) {
            if (this != start) {
                return false;
            }
            this.fProperties.put(name, new ValuePropertyContainer(value));
            return true;
        }
        if (propertyContainer.isAttribute(PropertyAttribute.READONLY)) {
            return start == this;
        }
        if (start != this && !(propertyContainer instanceof PropertyAccessorPropertyContainer)) {
            return false;
        }
        return propertyContainer.setValue(start, value);
    }

    public void delete(int index) {
        this.delete(Integer.toString(index));
    }

    public void delete(String name) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        if (propertyContainer != null && !propertyContainer.isAttribute(PropertyAttribute.PERMANENT)) {
            this.fProperties.remove(name);
        }
    }

    public Object getDefaultValue(Class hint) {
        return ScriptableObject.getDefaultValue((Scriptable)this, (Class)hint);
    }

    public Object[] getIds() {
        ArrayList<String> result = null;
        for (Map.Entry<String, PropertyContainer> entry : this.fProperties.entrySet()) {
            if (entry.getValue().isAttribute(PropertyAttribute.DONTENUM)) continue;
            if (result == null) {
                result = new ArrayList<String>(this.fProperties.size());
            }
            result.add(entry.getKey());
        }
        return result != null ? result.toArray() : ScriptRuntime.emptyArgs;
    }

    public Object[] getAllIds() {
        ArrayList<String> result = new ArrayList<String>(this.fProperties.size());
        Iterator<Map.Entry<String, PropertyContainer>> iterator = this.fProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next().getKey());
        }
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (!o1.getClass().equals(o2.getClass())) {
                    return (String.class.equals(o1.getClass()) ? 0 : 1) - (String.class.equals(o2.getClass()) ? 0 : 1);
                }
                return ((Comparable)o1).compareTo(o2);
            }
        });
        return result.toArray();
    }

    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo((Scriptable)instance, (Scriptable)this);
    }

    public static interface PropertyAccessor {
        public boolean isReadonly();

        public Object getValue(Scriptable var1);

        public void setValue(Scriptable var1, Object var2);
    }

    private static class PropertyAccessorPropertyContainer
    extends PropertyContainer {
        private PropertyAccessor fPropertyAccessor;

        public PropertyAccessorPropertyContainer(PropertyAccessor propertyAccessor, EnumSet<PropertyAttribute> attributes) {
            super(attributes);
            this.fPropertyAccessor = propertyAccessor;
        }

        @Override
        public boolean canWrite() {
            return !this.fPropertyAccessor.isReadonly();
        }

        @Override
        public Object getValue(Scriptable start) {
            return this.fPropertyAccessor.getValue(start);
        }

        @Override
        public boolean setValue(Scriptable start, Object value) {
            if (this.fPropertyAccessor.isReadonly()) {
                return true;
            }
            this.fPropertyAccessor.setValue(start, value);
            return true;
        }
    }

    public static enum PropertyAttribute {
        READONLY,
        DONTENUM,
        PERMANENT;

    }

    public static abstract class PropertyContainer {
        private final EnumSet<PropertyAttribute> fAttributes;

        public PropertyContainer(EnumSet<PropertyAttribute> attributes) {
            this.fAttributes = attributes;
        }

        public boolean canWrite() {
            return true;
        }

        public abstract Object getValue(Scriptable var1);

        public abstract boolean setValue(Scriptable var1, Object var2);

        public boolean isAttribute(PropertyAttribute attribute) {
            return this.fAttributes.contains((Object)attribute);
        }
    }

    private static class ValuePropertyContainer
    extends PropertyContainer {
        private Object fValue;

        public ValuePropertyContainer(Object value) {
            this(value, EnumSet.noneOf(PropertyAttribute.class));
        }

        public ValuePropertyContainer(Object value, EnumSet<PropertyAttribute> attributes) {
            super(attributes);
            this.fValue = value;
        }

        @Override
        public Object getValue(Scriptable start) {
            return this.fValue;
        }

        @Override
        public boolean setValue(Scriptable start, Object value) {
            this.fValue = value;
            return true;
        }
    }
}

