/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.util;

import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;

public class WrappingIndentingPrintStream
extends IndentingPrintStream {
    private int wrapSize;

    public WrappingIndentingPrintStream(OutputStream s, int wrapSize) {
        super(s);
        this.wrapSize = wrapSize;
    }

    public WrappingIndentingPrintStream(OutputStream s, int indent, int wrapSize) {
        super(s, indent);
        this.wrapSize = wrapSize;
    }

    @Override
    public void println(CharSequence s) {
        if (s == null) {
            return;
        }
        this.print(s);
        this.println();
    }

    @Override
    public void print(CharSequence s) {
        if (s == null) {
            return;
        }
        try {
            Collection<String> lines = StringUtil.wrapAndIndent(s.toString(), this.wrapSize, this.indent);
            int lineCount = 1;
            for (String line : lines) {
                this.stream.write(line.getBytes(Charset.defaultCharset().name()));
                if (lineCount < lines.size()) {
                    this.stream.write(this.newline.getBytes(Charset.defaultCharset().name()));
                }
                ++lineCount;
            }
            this.stream.flush();
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    @Override
    protected StringBuffer createString(CharSequence toWrite) {
        return null;
    }

    @Override
    public WrappingIndentingPrintStream indent() {
        return new WrappingIndentingPrintStream(this.stream, this.indent + 2, this.wrapSize);
    }
}

