/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.util;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IExecutionContext;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.OptionGroupUtil;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;

public abstract class SubcommandUtil {
    public static void printDebugTiming(IExecutionContext ctx, String label, PrintStream ps) {
        ps.println(String.valueOf(label) + ": " + (System.currentTimeMillis() - ctx.getStartTime()));
    }

    public static CharSequence getExecutionString(ISubcommandDefinition defn) {
        List<ISubcommandDefinition> ancestors = defn.getAncestors();
        StringBuffer buf = new StringBuffer();
        for (ISubcommandDefinition ancestor : ancestors) {
            buf.append(ancestor.getFullSubcommandName());
            buf.append(" ");
        }
        buf.append(defn.getFullSubcommandName());
        return buf;
    }

    public static int getTerminalWidth(IClientConfiguration config) {
        return SubcommandUtil.getTerminalWidth(config.getContext());
    }

    public static int getTerminalWidth(IExecutionContext ctx) {
        int columns = 80;
        String columnsString = ctx.environment().get("COLUMNS");
        if (columnsString != null) {
            try {
                columns = Integer.parseInt(columnsString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return columns;
    }

    public static String getUsagePrefix(ISubcommandDefinition defn, String appName) {
        StringBuffer prefixString = new StringBuffer();
        prefixString.append(Messages.HelpCmd_41);
        prefixString.append(appName);
        prefixString.append(Messages.HelpCmd_24);
        List<ISubcommandDefinition> ancestors = defn.getAncestors();
        ancestors.add(defn);
        for (ISubcommandDefinition ancestor : ancestors) {
            prefixString.append(String.valueOf(ancestor.getFullSubcommandName()) + Messages.HelpCmd_24);
        }
        return prefixString.toString();
    }

    public static String getFormattedShortUsageHelp(IExecutionContext ctx, ISubcommandDefinition defn) throws ISubcommandDefinition.LoadOptionsException, ConflictingOptionException {
        StringBuffer outputString = new StringBuffer();
        String prefixString = SubcommandUtil.getUsagePrefix(defn, ctx.getAppName());
        List<StringBuffer> usageTextList = OptionGroupUtil.getShortUsageHelp(defn.getOptions());
        int termWidth = SubcommandUtil.getTerminalWidth(ctx);
        boolean trailing = false;
        for (StringBuffer usageText : usageTextList) {
            if (trailing) {
                outputString.append(Messages.HelpCmd_39);
            }
            trailing = true;
            usageText.insert(0, prefixString);
            Collection<String> lines = StringUtil.wrapAndIndent(usageText.toString(), prefixString.toString(), termWidth);
            SubcommandUtil.addLinesToBuffer(lines, outputString);
        }
        return outputString.toString();
    }

    private static void addLinesToBuffer(Collection<String> lines, StringBuffer outputString) {
        boolean lineTrailing = false;
        for (String line : lines) {
            if (lineTrailing) {
                outputString.append(Messages.HelpCmd_39);
            }
            lineTrailing = true;
            outputString.append(line);
        }
    }

    public static boolean isEnvironmentVarSet(String envVar, String[] envVarValues, IClientConfiguration config) {
        String strEnvVarValue = config.getContext().environment().get(envVar);
        if (strEnvVarValue != null) {
            String[] stringArray = envVarValues;
            int n = envVarValues.length;
            int n2 = 0;
            while (n2 < n) {
                String envVarValue = stringArray[n2];
                if (strEnvVarValue.equalsIgnoreCase(envVarValue)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

