/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.util;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.osgi.util.NLS;

public class StringUtil {
    public static final int MIN_WRAP_LIMIT = 10;
    private static final Map<Character, Character> PATH_ESCAPE_MAPPING = new HashMap<Character, Character>();
    public static final char PATH_SEPARATOR = '/';

    static {
        PATH_ESCAPE_MAPPING.put(Character.valueOf('/'), Character.valueOf('/'));
    }

    public static void printTable(IndentingPrintStream out, PaddingInstruction[] alignment, CharSequence ... strings) {
        int numColumns = alignment.length;
        CharSequence[] padded = new CharSequence[strings.length];
        int[] columnWidth = new int[numColumns];
        int i = 0;
        while (i < strings.length) {
            columnWidth[i % numColumns] = Math.max(columnWidth[i % numColumns], strings[i].length());
            ++i;
        }
        i = 0;
        while (i < strings.length) {
            PaddingInstruction pi = alignment[i % numColumns];
            switch (pi) {
                case LEFT_WITH_SPACE: {
                    if (i % numColumns != numColumns - 1) {
                        padded[i] = StringUtil.pad(strings[i], columnWidth[i % numColumns]);
                        break;
                    }
                    padded[i] = strings[i];
                    break;
                }
                case RIGHT_WITH_SPACE: {
                    padded[i] = StringUtil.padLeft(strings[i], columnWidth[i % numColumns], ' ');
                    break;
                }
                case LEFT_WITH_ALTERNATING_DOTS: {
                    if (i % numColumns != numColumns - 1) {
                        char padChar = ' ';
                        if (i % 2 == 1) {
                            padChar = '.';
                        }
                        padded[i] = StringUtil.pad(strings[i], columnWidth[i % numColumns], padChar);
                        break;
                    }
                    padded[i] = strings[i];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown alignment instruction: " + (Object)((Object)pi));
                }
            }
            ++i;
        }
        StringUtil.printTable(out, numColumns, false, padded);
    }

    public static void printTable(IndentingPrintStream out, int numColumns, boolean pad, CharSequence ... strings) {
        if (pad) {
            CharSequence[] padded = new CharSequence[strings.length];
            int[] columnWidth = new int[numColumns];
            int i = 0;
            while (i < strings.length) {
                columnWidth[i % numColumns] = Math.max(columnWidth[i % numColumns], strings[i].length());
                ++i;
            }
            i = 0;
            while (i < strings.length) {
                padded[i] = i % numColumns == numColumns - 1 ? strings[i] : StringUtil.pad(strings[i], columnWidth[i % numColumns]);
                ++i;
            }
            StringUtil.printTable(out, numColumns, false, padded);
        } else {
            int i = 0;
            while (i < strings.length) {
                StringBuilder builder = new StringBuilder();
                int j = i;
                while (j < i + numColumns) {
                    builder.append(strings[j]);
                    builder.append(' ');
                    ++j;
                }
                out.println(builder.toString());
                i += numColumns;
            }
        }
    }

    public static CharSequence pad(CharSequence str, int width, char c) {
        StringBuffer buf = new StringBuffer(str);
        int i = str.length();
        while (i < width) {
            buf.append(c);
            ++i;
        }
        return buf;
    }

    public static CharSequence padLeft(CharSequence str, int width, char c) {
        StringBuffer buf = new StringBuffer();
        int i = str.length();
        while (i < width) {
            buf.append(c);
            ++i;
        }
        buf.append(str);
        return buf;
    }

    public static CharSequence pad(CharSequence str, int width) {
        return StringUtil.pad(str, width, ' ');
    }

    public static String escape(String str, Map<Character, Character> toEscape, char escapeChar) {
        StringBuffer buf = new StringBuffer(str.length());
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Character item = toEscape.get(Character.valueOf(c));
            if (item == null) {
                buf.append(c);
            } else {
                buf.append(escapeChar);
                buf.append(item);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static String unescape(String str, Map<Character, Character> toEscape, char escapeChar) {
        StringBuffer buf = new StringBuffer(str.length());
        HashMap<Character, Character> escaped = new HashMap<Character, Character>();
        for (Map.Entry<Character, Character> entry : toEscape.entrySet()) {
            if (escaped.containsKey(entry.getValue())) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.StringUtil_0, (Object)entry.getValue()));
            }
            escaped.put(entry.getValue(), entry.getKey());
        }
        boolean isEscaped = false;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Character item = Character.valueOf(c);
            if (isEscaped) {
                if (!escaped.containsKey(item)) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.StringUtil_1, (Object)item));
                }
                buf.append(escaped.get(item));
                isEscaped = false;
            } else if (c == escapeChar) {
                isEscaped = true;
            } else {
                buf.append(c);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static String[] splitEscapedPath(String str) {
        List<String> segments = StringUtil.splitEscaped(str, PATH_ESCAPE_MAPPING, '/', '\\');
        Iterator<String> i = segments.iterator();
        while (i.hasNext()) {
            String segment = i.next();
            assert (segment != null);
            if (segment.length() != 0) continue;
            i.remove();
        }
        return segments.toArray(new String[0]);
    }

    public static List<String> splitEscaped(String str, Map<Character, Character> toEscape, char splitOn, char escapeChar) {
        LinkedList<String> toReturn = new LinkedList<String>();
        StringBuffer accumulator = new StringBuffer(str.length());
        boolean isEscaped = false;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (isEscaped) {
                accumulator.append(c);
                isEscaped = false;
            } else if (c == escapeChar) {
                isEscaped = true;
                accumulator.append(c);
            } else if (c == splitOn) {
                toReturn.add(StringUtil.unescape(accumulator.toString(), toEscape, escapeChar));
                accumulator = new StringBuffer(str.length());
            } else {
                accumulator.append(c);
            }
            ++n2;
        }
        toReturn.add(accumulator.toString());
        return toReturn;
    }

    public static <T> CharSequence listToString(List<T> items) {
        StringBuffer buf = new StringBuffer();
        for (T item : items) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(item.toString());
        }
        return buf;
    }

    public static String createPathString(String[] segments) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            sb.append('/');
            sb.append(segment);
            ++n2;
        }
        return sb.toString();
    }

    public static String createPathString(List<String> segments) {
        String[] path = segments.toArray(new String[segments.size()]);
        return StringUtil.createPathString(path);
    }

    public static String join(String glue, String[] pieces) {
        if (pieces.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(pieces[0]);
        int i = 1;
        while (i < pieces.length) {
            buf.append(glue);
            buf.append(pieces[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String findEffectiveCwd(String[] args) {
        File result;
        String path = StringUtil.getPathArgument(args, "-d", "--directory");
        if (path == null) {
            result = new File(System.getProperty("user.dir"));
        } else {
            result = new File(path);
            if (!result.isAbsolute()) {
                result = new File(System.getProperty("user.dir"), path);
            }
        }
        try {
            result = result.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.getAbsolutePath();
    }

    public static String getPathArgument(String[] args, String shortName, String longName) {
        boolean returnNextValue = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (returnNextValue) {
                return arg;
            }
            if (arg.equals(shortName) || arg.equals(longName)) {
                returnNextValue = true;
            }
            ++n2;
        }
        return null;
    }

    public static String[] splitString(String str, String delim, int maxLength) {
        int noOfLines = str.length() / maxLength + 1;
        ArrayList<String> strArr = new ArrayList<String>(noOfLines);
        if (noOfLines == 1) {
            strArr.add(str);
        } else {
            StringTokenizer token = new StringTokenizer(str, delim);
            StringBuffer line = new StringBuffer();
            String word = null;
            while (token.hasMoreTokens()) {
                word = token.nextToken();
                if (line.length() + word.length() > maxLength) {
                    strArr.add(line.toString());
                    line.delete(0, line.length());
                }
                line.append(word);
                line.append(delim);
            }
            if (line.length() > 0) {
                strArr.add(line.toString());
            }
        }
        return strArr.toArray(new String[strArr.size()]);
    }

    public static Collection<String> wrapAndIndent(String text, int width) {
        return StringUtil.wrapAndIndent(text, " - ", width);
    }

    public static Collection<String> wrapAndIndent(String text, String allignmentText, int width) {
        --width;
        if (text == null || text.length() == 0) {
            return new ArrayList<String>();
        }
        if (allignmentText == null) {
            return StringUtil.wrap(text, width);
        }
        if (width < 10) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(text);
            return lines;
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (text.length() <= width) {
            lines.add(text);
            return lines;
        }
        int cursor = 0;
        String line = StringUtil.getWrapLine(text, 0, width);
        lines.add(line);
        cursor += line.length();
        int indent = text.indexOf(allignmentText);
        indent = indent == -1 || indent > width - allignmentText.length() ? 0 : (indent += allignmentText.length());
        char[] padChars = new char[indent];
        Arrays.fill(padChars, ' ');
        String padString = new String(padChars);
        while (cursor < text.length()) {
            line = StringUtil.getWrapLine(text, cursor, width - indent);
            lines.add(String.valueOf(padString) + line.trim());
            cursor += line.length();
        }
        return lines;
    }

    private static String getWrapLine(String text, int start, int maxLength) {
        int end = Math.min(text.length(), start + maxLength);
        if (end < text.length()) {
            while (!Character.isWhitespace(text.charAt(end)) && end > start) {
                --end;
            }
        }
        end = end == start ? Math.min(text.length(), start + maxLength) : Math.min(end, text.length());
        return text.substring(start, end);
    }

    public static Collection<String> wrap(String text, int width) {
        return StringUtil.wrapAndIndent(text, "", width);
    }

    public static Collection<String> wrapAndIndent(String text, int width, int indent) {
        int cursor = 0;
        char[] padChars = new char[indent];
        Arrays.fill(padChars, ' ');
        String padString = new String(padChars);
        ArrayList<String> lines = new ArrayList<String>();
        while (cursor < text.length()) {
            String line = StringUtil.getWrapLine(text, cursor, width - indent);
            lines.add(String.valueOf(padString) + line.trim());
            cursor += line.length();
        }
        return lines;
    }

    public static enum PaddingInstruction {
        LEFT_WITH_SPACE,
        RIGHT_WITH_SPACE,
        LEFT_WITH_ALTERNATING_DOTS;

    }
}

