/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.util;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.util.SubcommandUtil;
import java.io.PrintStream;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class StatusHelper {
    public static CLIClientException argSyntax(String message, IClientConfiguration config) {
        CharSequence cmdName = SubcommandUtil.getExecutionString(config.getSubcommandDefinition());
        if (cmdName.toString().equals("help")) {
            return StatusHelper.createException(NLS.bind((String)Messages.Application_CONCATENATE, (Object)message, (Object)NLS.bind((String)Messages.Application_1, (Object)config.getContext().getAppName())), 1, null);
        }
        return StatusHelper.createException(NLS.bind((String)Messages.Application_CONCATENATE, (Object)message, (Object)NLS.bind((String)Messages.Application_2, (Object)config.getContext().getAppName(), (Object)cmdName)), 1, null);
    }

    public static CLIClientException failure(String message, Throwable t) {
        return StatusHelper.createException(message, 3, t);
    }

    public static CLIClientException internalError(String message) {
        return StatusHelper.createException(message, 7, null);
    }

    public static CLIClientException internalError(String message, Exception e) {
        return StatusHelper.createException(message, 7, e);
    }

    public static CLIClientException internalError(String message, Collection<CLIClientException> exceptions) {
        MultiStatus multi = new MultiStatus("com.ibm.team.rtc.cli.infrastructure", 7, message, null);
        for (CLIClientException exception : exceptions) {
            multi.add((IStatus)new Status(4, "com.ibm.team.rtc.cli.infrastructure", 7, exception.getMessage(), (Throwable)exception));
        }
        return new CLIClientException((IStatus)multi);
    }

    public static CLIClientException createException(String message, int errorCode, Throwable t) {
        return new CLIClientException((IStatus)new Status(4, "com.ibm.team.rtc.cli.infrastructure", errorCode, message, t));
    }

    public static void showStatusException(IStatus status, PrintStream err) {
        if (status.isMultiStatus()) {
            MultiStatus multi;
            if (status.getException() != null) {
                err.println(Messages.Application_24);
                status.getException().printStackTrace(err);
            }
            if ((multi = (MultiStatus)status).getChildren().length > 1) {
                err.print(Messages.Application_25);
            }
            err.println(status.getMessage());
            if (multi.getException() != null) {
                multi.getException().printStackTrace(err);
            }
            StatusHelper.writeChildStatuses(multi, err);
        } else if (status.getException() != null) {
            status.getException().printStackTrace(err);
        }
    }

    private static void writeChildStatuses(MultiStatus multi, PrintStream err) {
        IStatus[] iStatusArray = multi.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (child.getException() == null) {
                err.println(NLS.bind((String)Messages.Application_26, (Object)child.getMessage()));
            } else {
                child.getException().printStackTrace(err);
            }
            err.println();
            err.println();
            if (child.isMultiStatus()) {
                StatusHelper.writeChildStatuses((MultiStatus)child, err);
            }
            ++n2;
        }
    }
}

