/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.util;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.SimpleGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class OptionGroupUtil {
    public static final String HelpCmdHtmlArgsFinite = " &lt;arg&gt;";
    public static final String HelpCmdHtmlArgsInfinite = " &lt;arg ...&gt;";

    public static boolean AllAreRequired(SimpleGroup grp) {
        for (Pair<INamedOptionDefinition, Boolean> def : grp.getNamedOptionsWithFlag()) {
            Boolean isRequired = def.getSecond();
            if (isRequired.booleanValue()) continue;
            return false;
        }
        for (IPositionalOptionDefinition positionalDef : grp.getPositionalOptions()) {
            if (positionalDef.isRequired()) continue;
            return false;
        }
        return true;
    }

    public static boolean AllAreRequired(MutuallyExclusiveGroup grp) {
        for (SimpleGroup simpleGroup : grp.getSimpleGroups()) {
            if (OptionGroupUtil.AllAreRequired(simpleGroup)) continue;
            return false;
        }
        return true;
    }

    public static boolean AllAreOptional(SimpleGroup grp) {
        return !grp.isRequired();
    }

    public static boolean AllAreOptional(MutuallyExclusiveGroup grp) {
        for (SimpleGroup simpleGroup : grp.getSimpleGroups()) {
            Boolean optional = OptionGroupUtil.AllAreOptional(simpleGroup);
            if (optional.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean AllInnerGroupsAreSingleton(MutuallyExclusiveGroup grp) {
        for (SimpleGroup simpleGroup : grp.getSimpleGroups()) {
            if (simpleGroup.size() <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean continuousGroupPrinter(ContinuousGroup grp, boolean escapeHtml, boolean hideCommonOptions, String prefix, StringBuffer buffer) {
        if (grp.isHidden()) {
            return false;
        }
        Collection<IOptionGroup> optionGroups = grp.getOptions();
        StringBuffer groupBuffer = new StringBuffer();
        String groupPrefix = "";
        for (IOptionGroup group : optionGroups) {
            boolean hasData = false;
            if (group instanceof MutuallyExclusiveGroup) {
                hasData = OptionGroupUtil.mutuallyExclusiveGroupPrinter((MutuallyExclusiveGroup)group, escapeHtml, hideCommonOptions, groupPrefix, groupBuffer);
            } else if (group instanceof SimpleGroup) {
                SimpleGroup simpleGroup = (SimpleGroup)group;
                boolean printOuterTags = simpleGroup.size() > 1;
                hasData = OptionGroupUtil.simpleGroupPrinter(simpleGroup, false, printOuterTags, escapeHtml, hideCommonOptions, groupPrefix, groupBuffer);
            }
            if (!groupPrefix.isEmpty() || !hasData) continue;
            groupPrefix = Messages.HelpCmd_24;
        }
        if (groupBuffer.length() > 0) {
            String openingTag = "";
            String closingTag = "";
            if (grp.isRequired()) {
                openingTag = "(";
                closingTag = ")";
            }
            buffer.append(prefix);
            buffer.append(openingTag);
            buffer.append(groupBuffer.toString());
            buffer.append(closingTag);
            return true;
        }
        return false;
    }

    public static boolean mutuallyExclusiveGroupPrinter(MutuallyExclusiveGroup grp, boolean escapeHtml, boolean hideCommonOptions, String prefix, StringBuffer buffer) {
        if (grp.isHidden()) {
            return false;
        }
        Collection<SimpleGroup> simpleGroups = grp.getSimpleGroups();
        StringBuffer groupBuffer = new StringBuffer();
        boolean trailing = false;
        boolean canSkipOptionalTag = OptionGroupUtil.AllInnerGroupsAreSingleton(grp);
        String groupPrefix = "";
        for (SimpleGroup simpleGroup : simpleGroups) {
            boolean hasData = OptionGroupUtil.simpleGroupPrinter(simpleGroup, canSkipOptionalTag, false, escapeHtml, hideCommonOptions, groupPrefix, groupBuffer);
            if (!groupPrefix.isEmpty() || !hasData) continue;
            groupPrefix = " | ";
        }
        if (groupBuffer.length() > 0) {
            String openingTag = "(";
            String closingTag = ")";
            if (OptionGroupUtil.AllAreOptional(grp)) {
                openingTag = "[";
                closingTag = "]";
            }
            buffer.append(prefix);
            buffer.append(openingTag);
            buffer.append(groupBuffer.toString());
            buffer.append(closingTag);
            return true;
        }
        return false;
    }

    public static boolean simpleGroupPrinter(SimpleGroup simpleGroup, boolean canSkipInnerOptionalTag, boolean printOuterTags, boolean escapeHtml, boolean hideCommonOptions, String prefix, StringBuffer buffer) {
        if (simpleGroup.isHidden()) {
            return false;
        }
        List<Pair<INamedOptionDefinition, Boolean>> namedOptions = simpleGroup.getNamedOptionsWithFlag();
        Collection<IPositionalOptionDefinition> positionalOptions = simpleGroup.getPositionalOptions();
        StringBuffer groupBuffer = new StringBuffer();
        String optionPrefix = "";
        for (Pair pair : namedOptions) {
            INamedOptionDefinition def = (INamedOptionDefinition)pair.getFirst();
            if (hideCommonOptions && def.isCommonOption()) continue;
            Boolean isRequired = (Boolean)pair.getSecond();
            boolean hasData = OptionGroupUtil.optionPrinter(def, isRequired, canSkipInnerOptionalTag, escapeHtml, hideCommonOptions, optionPrefix, groupBuffer);
            if (!optionPrefix.isEmpty() || !hasData) continue;
            optionPrefix = Messages.HelpCmd_24;
        }
        if (namedOptions.size() > 0 && positionalOptions.size() > 0) {
            groupBuffer.append(Messages.HelpCmd_24);
        }
        optionPrefix = "";
        for (IPositionalOptionDefinition iPositionalOptionDefinition : positionalOptions) {
            OptionGroupUtil.optionPrinter(iPositionalOptionDefinition, escapeHtml, optionPrefix, groupBuffer);
            if (!optionPrefix.isEmpty()) continue;
            optionPrefix = Messages.HelpCmd_24;
        }
        if (groupBuffer.length() > 0) {
            String string;
            String string2 = printOuterTags ? (!simpleGroup.isRequired() ? "[" : "(") : (string = "");
            String closingTag = printOuterTags ? (!simpleGroup.isRequired() ? "]" : ")") : "";
            buffer.append(prefix);
            buffer.append(string);
            buffer.append(groupBuffer.toString());
            buffer.append(closingTag);
            return true;
        }
        return false;
    }

    public static boolean optionPrinter(INamedOptionDefinition opt, boolean isRequired, boolean canSkipOptionalTag, boolean escapeHtml, boolean hideCommonOptions, String prefix, StringBuffer buffer) {
        if (opt.isHidden() || hideCommonOptions && opt.isCommonOption()) {
            return false;
        }
        String openingTag = "";
        String closingTag = "";
        if (!isRequired && !canSkipOptionalTag) {
            openingTag = "[";
            closingTag = "]";
        }
        buffer.append(prefix);
        buffer.append(openingTag);
        boolean hasShortOpt = false;
        if (opt.getShortOpt() != null) {
            buffer.append("-" + opt.getShortOpt());
            hasShortOpt = true;
        }
        if (opt.getLongOpt() != null) {
            if (hasShortOpt) {
                buffer.append("/");
            }
            buffer.append("--" + opt.getLongOpt());
        }
        if (opt.getArgCount() == -1) {
            if (escapeHtml) {
                buffer.append(HelpCmdHtmlArgsInfinite);
            } else {
                buffer.append(Messages.HelpCmd_40);
            }
        } else {
            int minArgCount = opt.getMinArgCount();
            int argCount = opt.getArgCount();
            int i = 0;
            while (i < argCount) {
                if (i < minArgCount) {
                    if (escapeHtml) {
                        buffer.append(HelpCmdHtmlArgsFinite);
                    } else {
                        buffer.append(Messages.HelpCmd_37);
                    }
                } else {
                    buffer.append(Messages.HelpCmd_38);
                }
                ++i;
            }
        }
        buffer.append(closingTag);
        return true;
    }

    public static boolean optionPrinter(IPositionalOptionDefinition opt, boolean escapeHtml, String prefix, StringBuffer buffer) {
        String openingTag;
        boolean isRequired;
        boolean bl = isRequired = opt.getMinCount() > 0 || opt.isShowAsRequired();
        String string = isRequired ? (escapeHtml ? "&lt;" : "<") : (openingTag = "[");
        String closingTag = isRequired ? (escapeHtml ? "&gt;" : ">") : "]";
        buffer.append(prefix);
        buffer.append(openingTag);
        buffer.append(opt.getName());
        if (opt.getMaxCount() == -1) {
            buffer.append("...");
        }
        buffer.append(closingTag);
        return true;
    }

    public static List<StringBuffer> getShortUsageHelp(Options options) {
        return OptionGroupUtil.getShortUsageHelp(options, false);
    }

    public static List<StringBuffer> getShortUsageHelpForHtml(Options options) {
        return OptionGroupUtil.getShortUsageHelp(options, true);
    }

    public static List<StringBuffer> getShortUsageHelp(Options options, boolean escapeHtml) {
        LinkedList<ContinuousGroup> continuousGroups = new LinkedList<ContinuousGroup>();
        ArrayList<StringBuffer> resultHelpTextList = new ArrayList<StringBuffer>();
        StringBuffer buffer = new StringBuffer();
        Collection<Object> allOptionsForPrint = options.getAllOptions();
        HashMap<INamedOptionDefinition, Boolean> topLevelNamedOptions = options.getTopLevelNamedOptions();
        boolean hideCommonOptions = options.isHideCommonOptions();
        boolean showCommonOptionsText = false;
        String prefix = "";
        for (Object opt : allOptionsForPrint) {
            boolean hasData = false;
            boolean hasCommonOptions = false;
            if (opt instanceof INamedOptionDefinition) {
                INamedOptionDefinition namedOpt = (INamedOptionDefinition)opt;
                if (namedOpt.isCommonOption()) {
                    hasCommonOptions = true;
                }
                if (!hasCommonOptions || !hideCommonOptions) {
                    boolean isRequired = false;
                    if (topLevelNamedOptions.containsKey(namedOpt)) {
                        isRequired = topLevelNamedOptions.get(namedOpt);
                    }
                    hasData = OptionGroupUtil.optionPrinter(namedOpt, isRequired, false, escapeHtml, hideCommonOptions, prefix, buffer);
                }
            } else if (opt instanceof IPositionalOptionDefinition) {
                hasData = OptionGroupUtil.optionPrinter((IPositionalOptionDefinition)opt, escapeHtml, prefix, buffer);
            } else if (opt instanceof SimpleGroup) {
                SimpleGroup simpleGroup = (SimpleGroup)opt;
                hasData = OptionGroupUtil.simpleGroupPrinter(simpleGroup, false, true, escapeHtml, hideCommonOptions, prefix, buffer);
                hasCommonOptions = simpleGroup.hasCommonOptions();
            } else if (opt instanceof MutuallyExclusiveGroup) {
                MutuallyExclusiveGroup mutuallyExclusiveGroup = (MutuallyExclusiveGroup)opt;
                hasData = OptionGroupUtil.mutuallyExclusiveGroupPrinter(mutuallyExclusiveGroup, escapeHtml, hideCommonOptions, prefix, buffer);
                hasCommonOptions = mutuallyExclusiveGroup.hasCommonOptions();
            } else if (opt instanceof ContinuousGroup) {
                ContinuousGroup continuousGroup = (ContinuousGroup)opt;
                continuousGroups.add(continuousGroup);
                hasCommonOptions = continuousGroup.hasCommonOptions();
            }
            if (prefix.isEmpty() && hasData) {
                prefix = Messages.HelpCmd_24;
            }
            if (showCommonOptionsText || !hasCommonOptions || !hideCommonOptions) continue;
            showCommonOptionsText = true;
        }
        if (continuousGroups.size() == 0) {
            StringBuffer helpString = new StringBuffer();
            if (showCommonOptionsText) {
                helpString.append(Messages.HelpCmd_CommonOptionsInShortUsage);
                helpString.append(Messages.HelpCmd_24);
            }
            helpString.append(buffer);
            resultHelpTextList.add(helpString);
        } else {
            for (ContinuousGroup group : continuousGroups) {
                boolean hasData;
                if (group.isHidden()) continue;
                StringBuffer groupBuffer = new StringBuffer();
                if (showCommonOptionsText) {
                    groupBuffer.append(Messages.HelpCmd_CommonOptionsInShortUsage);
                    groupBuffer.append(Messages.HelpCmd_24);
                }
                if (!(hasData = OptionGroupUtil.continuousGroupPrinter(group, escapeHtml, hideCommonOptions, "", groupBuffer))) continue;
                groupBuffer.append(Messages.HelpCmd_24);
                groupBuffer.append(buffer);
                resultHelpTextList.add(groupBuffer);
            }
        }
        return resultHelpTextList;
    }
}

