/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class IndentingPrintStream {
    public static final int INDENT = 2;
    final BufferedOutputStream stream;
    final String newline = System.getProperty("line.separator");
    Exception exception = null;
    int indent;

    public IndentingPrintStream(OutputStream s) {
        this.stream = new BufferedOutputStream(s);
        this.indent = 0;
    }

    public IndentingPrintStream(OutputStream s, int indent) {
        this.stream = new BufferedOutputStream(s);
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void println(CharSequence s) {
        if (s == null) {
            return;
        }
        this.print(this.createString(s));
        this.println();
    }

    public void printIndent() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.indent) {
            buf.append(" ");
            ++i;
        }
        this.print(buf);
    }

    public void print(CharSequence s) {
        if (s == null) {
            return;
        }
        try {
            byte[] sBytes = s.toString().getBytes(Charset.defaultCharset().name());
            int length = 0;
            while (length < sBytes.length) {
                this.stream.write(sBytes[length++]);
            }
            this.stream.flush();
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    public void println() {
        try {
            this.stream.write(this.newline.getBytes(Charset.defaultCharset().name()));
            this.stream.flush();
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    public IndentingPrintStream indent() {
        return new IndentingPrintStream(this.stream, this.indent + 2);
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    protected StringBuffer createString(CharSequence toWrite) {
        StringBuffer buf = new StringBuffer(this.indent + toWrite.length());
        int i = 0;
        while (i < this.indent) {
            buf.append(" ");
            ++i;
        }
        buf.append(toWrite);
        return buf;
    }
}

