/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.subcommands;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommand;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.rtc.cli.infrastructure.internal.util.SubcommandUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class VersionCmd
implements ISubcommand,
IOptionSource {
    private Map<Map<String, String>, String> commandList = new HashMap<Map<String, String>, String>();

    @Override
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        options.setLongHelp(Messages.VersionCmd_0);
        return options;
    }

    public void initialize(IClientConfiguration config) throws CLIClientException {
    }

    @Override
    public int run(IClientConfiguration config) throws CLIClientException {
        this.getCommands(config);
        this.displayCommands(config, this.commandList);
        return 0;
    }

    public Map<Map<String, String>, String> getCommands(IClientConfiguration config) throws CLIClientException {
        HashMap<String, ArrayList<ISubcommandDefinition>> grouped = new HashMap<String, ArrayList<ISubcommandDefinition>>();
        for (ISubcommandDefinition defn : config.getSubcommandDefinitions()) {
            ArrayList<ISubcommandDefinition> list = (ArrayList<ISubcommandDefinition>)grouped.get(defn.getModuleName());
            if (list == null) {
                list = new ArrayList<ISubcommandDefinition>();
                grouped.put(defn.getModuleName(), list);
            }
            list.add(defn);
        }
        boolean showDeprecatedHelp = SubcommandUtil.isEnvironmentVarSet("SHOW_DEPRECATED_HELP", new String[]{"1", "true"}, config);
        for (Map.Entry entry : grouped.entrySet()) {
            this.getVersion((String)entry.getKey(), (List)entry.getValue(), showDeprecatedHelp, config);
        }
        return this.commandList;
    }

    private void getVersion(String bundleName, List<ISubcommandDefinition> defns, boolean showDeprecatedHelp, IClientConfiguration config) {
        Bundle bundle = Platform.getBundle((String)bundleName);
        String version = Messages.VersionCmd_2;
        Dictionary headers = bundle.getHeaders();
        String VERSION_KEY = "bundle-version";
        Enumeration i = headers.keys();
        while (i.hasMoreElements()) {
            String candidate = (String)i.nextElement();
            if (!"bundle-version".equals(candidate.toLowerCase())) continue;
            version = (String)headers.get(candidate);
            break;
        }
        String namespace = bundle.getSymbolicName();
        HashMap<String, String> key = new HashMap<String, String>();
        key.put(namespace, version);
        StringBuffer buf = new StringBuffer();
        ArrayList<String> commands = new ArrayList<String>();
        for (ISubcommandDefinition defn : defns) {
            if (defn.isDeprecated() && !showDeprecatedHelp) continue;
            StringBuffer command = new StringBuffer();
            for (ISubcommandDefinition ancestor : defn.getAncestors()) {
                command.append(ancestor.getFullSubcommandName());
                command.append('/');
            }
            command.append(defn.getFullSubcommandName());
            commands.add(command.toString());
        }
        commands.sort(String::compareToIgnoreCase);
        for (String command : commands) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(command);
        }
        this.commandList.put(key, buf.toString());
    }

    public void displayCommands(IClientConfiguration config, Map<Map<String, String>, String> commandList) {
        for (Map.Entry<Map<String, String>, String> entry : commandList.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            for (Map.Entry<String, String> entry1 : entry.getKey().entrySet()) {
                config.getContext().stdout().println(NLS.bind((String)Messages.VersionCmd_3, (Object)entry1.getKey(), (Object)entry1.getValue()));
            }
            config.getContext().stdout().println(Messages.VersionCmd_5);
            IndentingPrintStream out = new IndentingPrintStream(config.getContext().stdout(), 2);
            Collection<String> lines = StringUtil.wrap(entry.getValue().toString(), SubcommandUtil.getTerminalWidth(config) - out.getIndent());
            for (String line : lines) {
                out.println(line);
            }
            config.getContext().stdout().println();
        }
    }
}

