/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.subcommands;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommand;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.OptionGroupUtil;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StatusHelper;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.rtc.cli.infrastructure.internal.util.SubcommandNameCompator;
import com.ibm.team.rtc.cli.infrastructure.internal.util.SubcommandUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class HelpCmd
implements ISubcommand,
IOptionSource {
    public static final String NO_HELP_STRING = Messages.HelpCmd_0;
    public static PositionalOptionDefinition OPT_SUBCOMMAND_NAME = new PositionalOptionDefinition("subcmd", 0, -1);
    public static NamedOptionDefinition OPT_ALL = new NamedOptionDefinition(null, "all", 0);
    private int termWidth;
    private boolean showDeprecatedHelp = false;

    @Override
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.HelpCmd_1);
        options.addOption(OPT_SUBCOMMAND_NAME, Messages.HelpCmd_2).addOption(OPT_ALL, Messages.HelpCmd_3);
        return options;
    }

    public void initialize(IClientConfiguration config) throws CLIClientException {
    }

    @Override
    public int run(IClientConfiguration config) throws CLIClientException {
        this.termWidth = SubcommandUtil.getTerminalWidth(config);
        config.getContext().stdout().println();
        ICommandLine subargs = config.getSubcommandCommandLine();
        this.showDeprecatedHelp = SubcommandUtil.isEnvironmentVarSet("SHOW_DEPRECATED_HELP", new String[]{"1", "true"}, config);
        if (subargs != null && subargs.hasOption(OPT_ALL)) {
            this.showAllSubcommands(config);
        } else if (subargs == null || !subargs.hasOption(OPT_SUBCOMMAND_NAME)) {
            this.showSubcommandListing(config);
        } else {
            this.showSubCommand(subargs.getOptions(OPT_SUBCOMMAND_NAME), config);
        }
        return 0;
    }

    private void showSubcommandListing(IClientConfiguration config) {
        boolean IsADeprecatedNonParent;
        boolean IsADeprecatedParent;
        Options options = config.getCommandLine().getDefinition();
        config.getContext().stdout().print(NLS.bind((String)Messages.HelpCmd_4, (Object)config.getContext().getAppName()));
        this.showUsage(options, config, false);
        config.getContext().stdout().println();
        ArrayList<ISubcommandDefinition> subcommands = new ArrayList<ISubcommandDefinition>(config.getSubcommandDefinitions());
        Collections.sort(subcommands, new SubcommandNameCompator());
        IndentingPrintStream out = new IndentingPrintStream(config.getContext().stdout());
        out.println(Messages.HelpCmd_5);
        out = out.indent();
        int maxNameLength = 0;
        for (ISubcommandDefinition defn : subcommands) {
            IsADeprecatedParent = defn.isDeprecated() && defn.isParent() && !this.hasVisibleChildren(defn, config);
            boolean bl = IsADeprecatedNonParent = defn.isDeprecated() && !defn.isParent();
            if (!defn.showInHelpListing(config) || (IsADeprecatedNonParent || IsADeprecatedParent) && !this.showDeprecatedHelp || defn.getParentId() != null) continue;
            maxNameLength = Math.max(maxNameLength, defn.getFullSubcommandName().length());
        }
        for (ISubcommandDefinition defn : subcommands) {
            IsADeprecatedParent = defn.isDeprecated() && defn.isParent() && !this.hasVisibleChildren(defn, config);
            boolean bl = IsADeprecatedNonParent = defn.isDeprecated() && !defn.isParent();
            if (!defn.showInHelpListing(config) || (IsADeprecatedNonParent || IsADeprecatedParent) && !this.showDeprecatedHelp || defn.getParentId() != null) continue;
            String longLine = NLS.bind((String)Messages.HelpCmd_6, (Object)StringUtil.pad(defn.getFullSubcommandName(), maxNameLength), (Object)defn.getShortHelp());
            Collection<String> lines = StringUtil.wrapAndIndent(longLine, this.termWidth - out.getIndent());
            for (String line : lines) {
                out.println(line);
            }
        }
    }

    private void showAllSubcommands(IClientConfiguration config) throws CLIClientException {
        Collection<ISubcommandDefinition> subcommands = config.getSubcommandDefinitions();
        LinkedList<CLIClientException> exceptions = new LinkedList<CLIClientException>();
        StringBuffer erroringNames = new StringBuffer();
        boolean isFirst = true;
        for (ISubcommandDefinition defn : subcommands) {
            if (!defn.showInHelpListing(config) || defn.isDeprecated() && !this.showDeprecatedHelp) continue;
            if (!isFirst) {
                config.getContext().stdout().println();
                config.getContext().stdout().println();
            }
            isFirst = false;
            try {
                this.showSubcommand(config, Collections.singletonList(defn.getFullSubcommandName()), defn);
            }
            catch (CLIClientException e) {
                config.getContext().stderr().println(NLS.bind((String)Messages.HelpCmd_9, (Object)defn.getFullSubcommandName()));
                exceptions.add(e);
                if (erroringNames.length() > 0) {
                    erroringNames.append(Messages.HelpCmd_10);
                }
                erroringNames.append(defn.getFullSubcommandName());
            }
        }
        if (exceptions.size() > 0) {
            throw StatusHelper.internalError(NLS.bind((String)Messages.HelpCmd_11, (Object)erroringNames.toString()), exceptions);
        }
    }

    private void showSubCommand(List<String> cmdNames, IClientConfiguration config) throws CLIClientException {
        String cmdName = cmdNames.get(0);
        ISubcommandDefinition myDef = config.getSubcommandDefinition();
        ISubcommandDefinition parent = myDef.getLoader().loadToplevel(cmdName);
        if (parent == null) {
            throw StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_12, (Object)cmdName), config);
        }
        if (parent.getParentId() != null) {
            StringBuffer buf = new StringBuffer();
            for (ISubcommandDefinition anc : parent.getAncestors()) {
                buf.append(anc.getFullSubcommandName());
                buf.append(Messages.HelpCmd_13);
            }
            buf.append(cmdName);
            throw StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_14, (Object)cmdName), config);
        }
        ISubcommandDefinition child = parent;
        int i = 1;
        while (i < cmdNames.size()) {
            try {
                parent = child = parent.getChild(cmdNames.get(i));
            }
            catch (IllegalArgumentException e) {
                throw StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_15, (Object)cmdNames.get(i)), config);
            }
            ++i;
        }
        if (child.isDeprecated() && !this.showDeprecatedHelp && !this.hasVisibleChildren(child, config)) {
            this.showDeprecatedHelpHint(parent, config);
            return;
        }
        this.showSubcommand(config, cmdNames, child);
    }

    private void showDeprecatedHelpHint(ISubcommandDefinition defn, IClientConfiguration config) throws CLIClientException {
        String deprecatedAlternative = defn.getAttr("deprecated");
        if (deprecatedAlternative == null || deprecatedAlternative.isEmpty()) {
            throw StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_SHOW_DEPRECATED_GENERIC_MESSAGE, (Object)"SHOW_DEPRECATED_HELP", (Object)"1"), config);
        }
        if (defn.isParent()) {
            String[] deprecatedAlternatives = deprecatedAlternative.split(" ");
            StringBuffer alternatives = new StringBuffer();
            String[] stringArray = deprecatedAlternatives;
            int n = deprecatedAlternatives.length;
            int n2 = 0;
            while (n2 < n) {
                String alternative = stringArray[n2];
                if (alternatives.length() != 0) {
                    alternatives.append(", ");
                }
                alternatives.append(alternative);
                ++n2;
            }
            throw StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_SHOW_DEPRECATED_PARENT_MESSAGE, (Object[])new String[]{alternatives.toString(), "SHOW_DEPRECATED_HELP", "1"}), config);
        }
        throw StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_SHOW_DEPRECATED_COMMAND_MESSAGE, (Object[])new String[]{deprecatedAlternative, "SHOW_DEPRECATED_HELP", "1"}), config);
    }

    private void showSubcommand(IClientConfiguration config, List<String> cmdNames, ISubcommandDefinition defn) throws CLIClientException {
        Options options;
        String cmdName = cmdNames.get(cmdNames.size() - 1);
        try {
            options = defn.getOptions();
        }
        catch (ISubcommandDefinition.LoadOptionsException e) {
            throw StatusHelper.failure(NLS.bind((String)Messages.HelpCmd_16, (Object)cmdName, (Object)e.getCause().getMessage()), e);
        }
        catch (ConflictingOptionException e) {
            throw StatusHelper.failure(NLS.bind((String)Messages.HelpCmd_17, (Object)cmdName, (Object)e.getMessage()), e);
        }
        List<ISubcommandDefinition> ancestors = defn.getAncestors();
        config.getContext().stdout().print(Messages.HelpCmd_19);
        config.getContext().stdout().print(String.valueOf(config.getContext().getAppName()) + " ");
        for (ISubcommandDefinition ancestor : ancestors) {
            config.getContext().stdout().print(String.valueOf(ancestor.getFullSubcommandName()) + " ");
        }
        config.getContext().stdout().print(defn.getFullSubcommandName());
        config.getContext().stdout().println();
        config.getContext().stdout().println();
        String longHelp = options.getLongHelp();
        if (longHelp == null) {
            config.getContext().stdout().println(NO_HELP_STRING);
        } else {
            String purposeLine1 = NLS.bind((String)Messages.HelpCmd_34, (Object)longHelp);
            if (purposeLine1.length() < this.termWidth) {
                config.getContext().stdout().println(purposeLine1);
            } else {
                purposeLine1 = NLS.bind((String)Messages.HelpCmd_34, (Object)"");
                config.getContext().stdout().println(purposeLine1);
                Collection<String> lines = StringUtil.wrap(longHelp, this.termWidth);
                for (String line : lines) {
                    config.getContext().stdout().print("  ");
                    config.getContext().stdout().println(line);
                }
            }
        }
        config.getContext().stdout().println();
        String[] aliases = defn.getAliases();
        if (aliases.length > 0) {
            StringBuffer parentCommands = new StringBuffer();
            boolean trailing = false;
            int i = 0;
            while (i < cmdNames.size() - 1) {
                if (trailing) {
                    parentCommands.append(Messages.HelpCmd_13);
                }
                trailing = true;
                parentCommands.append(cmdNames.get(i));
                ++i;
            }
            config.getContext().stdout().print(Messages.HelpCmd_21);
            trailing = false;
            String[] stringArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (trailing) {
                    config.getContext().stdout().print(Messages.HelpCmd_10);
                }
                trailing = true;
                config.getContext().stdout().print(parentCommands.toString().isEmpty() ? alias : String.valueOf(parentCommands.toString()) + Messages.HelpCmd_13 + alias);
                ++n2;
            }
            config.getContext().stdout().println();
            config.getContext().stdout().println();
        }
        StringBuffer prefixString = new StringBuffer();
        boolean helpShown = false;
        if (defn.isRunnable() && (!defn.isDeprecated() || this.showDeprecatedHelp)) {
            this.showUsagePrefix(defn, config, prefixString, !options.getSupportsNewHelp());
            if (options.getSupportsNewHelp()) {
                this.showNewUsage(options, prefixString, config, true);
            } else {
                this.showUsage(options, config, true);
            }
            helpShown = true;
        }
        if (defn.isParent() && this.hasVisibleChildren(defn, config)) {
            if (helpShown) {
                config.getContext().stdout().println();
                config.getContext().stdout().println();
            }
            this.showUsagePrefix(defn, config, prefixString, !options.getSupportsNewHelp());
            this.showChildCommands(defn, config);
        }
    }

    private boolean hasVisibleChildren(ISubcommandDefinition defn, IClientConfiguration config) {
        ArrayList<ISubcommandDefinition> children = new ArrayList<ISubcommandDefinition>(defn.getChildren());
        for (ISubcommandDefinition child : children) {
            if (!child.showInHelpListing(config) || child.isDeprecated() && !this.showDeprecatedHelp) continue;
            return true;
        }
        return false;
    }

    private void showUsagePrefix(ISubcommandDefinition defn, IClientConfiguration config, StringBuffer prefixString, boolean print) {
        prefixString.append(config.getContext().getAppName());
        prefixString.append(Messages.HelpCmd_24);
        if (print) {
            config.getContext().stdout().print(NLS.bind((String)Messages.HelpCmd_23, (Object)config.getContext().getAppName()));
        }
        List<ISubcommandDefinition> ancestors = defn.getAncestors();
        ancestors.add(defn);
        for (ISubcommandDefinition ancestor : ancestors) {
            prefixString.append(String.valueOf(ancestor.getFullSubcommandName()) + Messages.HelpCmd_24);
            if (!print) continue;
            config.getContext().stdout().print(String.valueOf(ancestor.getFullSubcommandName()) + Messages.HelpCmd_24);
        }
    }

    private void showChildCommands(ISubcommandDefinition defn, IClientConfiguration config) {
        ArrayList<ISubcommandDefinition> children = new ArrayList<ISubcommandDefinition>(defn.getChildren());
        Collections.sort(children, new SubcommandNameCompator());
        config.getContext().stdout().print(String.valueOf(Messages.HelpCmd_35) + " ");
        config.getContext().stdout().println(Messages.HelpCmd_25);
        String longLine = NLS.bind((String)Messages.HelpCmd_28, (Object)config.getContext().getAppName(), (Object)defn.getFullSubcommandName());
        Collection<String> lines = StringUtil.wrap(longLine, this.termWidth);
        for (String line : lines) {
            config.getContext().stdout().println(line);
        }
        config.getContext().stdout().println();
        config.getContext().stdout().println(Messages.HelpCmd_26);
        IndentingPrintStream out = new IndentingPrintStream(config.getContext().stdout()).indent();
        int maxNameLength = 0;
        for (ISubcommandDefinition child : children) {
            maxNameLength = Math.max(maxNameLength, child.getFullSubcommandName().length());
        }
        for (ISubcommandDefinition child : children) {
            if (!child.showInHelpListing(config) || child.isDeprecated() && !this.showDeprecatedHelp) continue;
            longLine = NLS.bind((String)Messages.HelpCmd_27, (Object)StringUtil.pad(child.getFullSubcommandName(), maxNameLength), (Object)child.getShortHelp());
            lines = StringUtil.wrapAndIndent(longLine, this.termWidth - out.getIndent());
            for (String line : lines) {
                out.println(line);
            }
        }
    }

    private void showNewUsage(Options options, StringBuffer prefixString, IClientConfiguration config, boolean isLeaf) {
        IndentingPrintStream out = new IndentingPrintStream(config.getContext().stdout());
        List<StringBuffer> resultOptStrings = OptionGroupUtil.getShortUsageHelp(options);
        if (resultOptStrings.size() > 1) {
            out.println(Messages.HelpCmd_41);
        } else {
            prefixString.insert(0, Messages.HelpCmd_41);
        }
        boolean trailing = false;
        for (StringBuffer resultOptString : resultOptStrings) {
            if (trailing) {
                out.println();
            }
            trailing = true;
            resultOptString.insert(0, prefixString);
            Collection<String> lines = StringUtil.wrapAndIndent(resultOptString.toString(), prefixString.toString(), this.termWidth - out.getIndent());
            for (String string : lines) {
                out.println(string);
            }
        }
        if (options.getPositionalOptions().size() > 0) {
            out.println();
        }
        IndentingPrintStream pos = out.indent();
        int maxWidth = 0;
        for (IPositionalOptionDefinition opt : options.getPositionalOptions()) {
            maxWidth = Math.max(maxWidth, opt.getName().length());
        }
        for (IPositionalOptionDefinition opt : options.getPositionalOptions()) {
            String optionString = StringUtil.pad(opt.getName(), maxWidth) + NLS.bind((String)Messages.HelpCmd_30, (Object)options.getHelpFor(opt.getId()));
            Collection<String> lines = StringUtil.wrapAndIndent(optionString, this.termWidth - pos.getIndent());
            for (String line : lines) {
                pos.println(line);
            }
        }
        List<INamedOptionDefinition> namedOptions = options.getNamedOptions();
        if (namedOptions.size() == 0) {
            return;
        }
        ArrayList<INamedOptionDefinition> arrayList = new ArrayList<INamedOptionDefinition>();
        HashMap<INamedOptionDefinition, StringBuffer> names = new HashMap<INamedOptionDefinition, StringBuffer>();
        maxWidth = 0;
        for (INamedOptionDefinition opt : namedOptions) {
            if (opt.isHidden() && !this.showDeprecatedHelp) continue;
            if (options.isHideCommonOptions() && opt.isCommonOption()) {
                arrayList.add(opt);
            }
            StringBuffer buf = new StringBuffer();
            boolean hasShortOpt = false;
            if (opt.getShortOpt() != null) {
                buf.append("-" + opt.getShortOpt());
                hasShortOpt = true;
            }
            if (opt.getLongOpt() != null) {
                String commaSequence = ", ";
                if (hasShortOpt) {
                    buf.append(commaSequence);
                } else {
                    int whiteSpaceLength = "-".length() + 1 + commaSequence.length();
                    buf.append(StringUtil.pad(" ", whiteSpaceLength));
                }
                buf.append("--" + opt.getLongOpt());
            }
            if (opt.getArgCount() == -1) {
                buf.append(Messages.HelpCmd_40);
            } else {
                int minArgCount = opt.getMinArgCount();
                int argCount = opt.getArgCount();
                int i = 0;
                while (i < argCount) {
                    if (i < minArgCount) {
                        buf.append(Messages.HelpCmd_37);
                    } else {
                        buf.append(Messages.HelpCmd_38);
                    }
                    ++i;
                }
            }
            names.put(opt, buf);
            maxWidth = Math.max(maxWidth, buf.length());
        }
        maxWidth += 2;
        if (arrayList.size() > 0) {
            out.println();
            out.print(Messages.HelpCmd_CommonOptions);
            out.println();
            out = out.indent();
            this.showOptionUsage(options, arrayList, names, maxWidth, out);
        }
        namedOptions.removeAll(arrayList);
        if (namedOptions.size() > 0) {
            out.println();
            out.print(Messages.HelpCmd_31);
            out.println();
            if (arrayList.size() == 0) {
                out = out.indent();
            }
            this.showOptionUsage(options, namedOptions, names, maxWidth, out);
        }
    }

    public void showOptionUsage(Options options, Collection<INamedOptionDefinition> namedOptions, HashMap<INamedOptionDefinition, StringBuffer> names, int maxWidth, IndentingPrintStream out) {
        for (INamedOptionDefinition opt : namedOptions) {
            if (opt.isHidden() && !this.showDeprecatedHelp) continue;
            String optionString = NLS.bind((String)Messages.HelpCmd_33, (Object)StringUtil.pad(names.get(opt), maxWidth), (Object)options.getHelpFor(opt.getId()));
            Collection<String> lines = StringUtil.wrapAndIndent(optionString, this.termWidth - out.getIndent());
            for (String line : lines) {
                out.println(line);
            }
        }
    }

    private void showUsage(Options options, IClientConfiguration config, boolean isLeaf) {
        IndentingPrintStream out = new IndentingPrintStream(config.getContext().stdout());
        if (options.getNamedOptions().size() > 0) {
            out.print(Messages.HelpCmd_29);
        }
        for (IPositionalOptionDefinition opt : options.getPositionalOptions()) {
            boolean isRequired;
            boolean bl = isRequired = opt.getMinCount() > 0;
            if (isRequired) {
                out.print("<");
            } else {
                out.print("[");
            }
            out.print(opt.getName());
            if (opt.getMaxCount() == -1) {
                out.print("...");
            }
            if (isRequired) {
                out.print(">");
            } else {
                out.print("]");
            }
            out.print(" ");
        }
        out.println();
        if (!isLeaf) {
            out.println(NLS.bind((String)Messages.HelpCmd_36, (Object)config.getContext().getAppName()));
            out.println();
        }
        IndentingPrintStream pos = out.indent();
        int maxWidth = 0;
        for (IPositionalOptionDefinition opt : options.getPositionalOptions()) {
            maxWidth = Math.max(maxWidth, opt.getName().length());
        }
        for (IPositionalOptionDefinition opt : options.getPositionalOptions()) {
            String optionString = StringUtil.pad(opt.getName(), maxWidth) + NLS.bind((String)Messages.HelpCmd_30, (Object)options.getHelpFor(opt.getId()));
            Collection<String> lines = StringUtil.wrapAndIndent(optionString, this.termWidth - pos.getIndent());
            for (String line : lines) {
                pos.println(line);
            }
        }
        if (options.getNamedOptions().size() > 0) {
            out.println();
            out.print(Messages.HelpCmd_31);
            out.println();
        }
        out = out.indent();
        HashMap<INamedOptionDefinition, StringBuffer> names = new HashMap<INamedOptionDefinition, StringBuffer>();
        maxWidth = 0;
        ArrayList<INamedOptionDefinition> namedOptions = new ArrayList<INamedOptionDefinition>(options.getNamedOptions());
        Collections.sort(namedOptions, new NamedOptionComparator());
        for (INamedOptionDefinition opt : namedOptions) {
            if (opt.isHidden() && !this.showDeprecatedHelp) continue;
            StringBuffer buf = new StringBuffer();
            boolean hasShortOpt = false;
            if (opt.getShortOpt() != null) {
                buf.append("-" + opt.getShortOpt());
                hasShortOpt = true;
            }
            if (opt.getLongOpt() != null) {
                if (hasShortOpt) {
                    buf.append(" ");
                }
                if (hasShortOpt) {
                    buf.append("[");
                }
                buf.append("--" + opt.getLongOpt());
                if (hasShortOpt) {
                    buf.append("]");
                }
            }
            if (opt.getArgCount() == -1) {
                buf.append(" ...");
            } else {
                int i = opt.getArgCount();
                while (i > 0) {
                    buf.append(Messages.HelpCmd_32);
                    --i;
                }
            }
            names.put(opt, buf);
            maxWidth = Math.max(maxWidth, buf.length());
        }
        maxWidth += 2;
        for (INamedOptionDefinition opt : namedOptions) {
            if (opt.isHidden() && !this.showDeprecatedHelp) continue;
            String optionString = NLS.bind((String)Messages.HelpCmd_33, (Object)StringUtil.pad((CharSequence)names.get(opt), maxWidth), (Object)options.getHelpFor(opt.getId()));
            Collection<String> lines = StringUtil.wrapAndIndent(optionString, this.termWidth - out.getIndent());
            for (String line : lines) {
                out.println(line);
            }
        }
    }

    private static final class NamedOptionComparator
    implements Comparator<INamedOptionDefinition> {
        private NamedOptionComparator() {
        }

        @Override
        public int compare(INamedOptionDefinition o1, INamedOptionDefinition o2) {
            String s1 = o1.getShortOpt();
            String s2 = o2.getShortOpt();
            if (s1 == null && s2 == null) {
                s1 = o1.getLongOpt();
                s2 = o2.getLongOpt();
            }
            if (s1 != null && s2 != null) {
                return s1.compareToIgnoreCase(s2);
            }
            if (s1 != null) {
                return 1;
            }
            if (s2 != null) {
                return -1;
            }
            return o1.getArgCount() - o2.getArgCount();
        }
    }
}

