/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.parser;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.AbstractOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import org.eclipse.osgi.util.NLS;

public class PositionalOptionDefinition
extends AbstractOptionDefinition
implements IPositionalOptionDefinition {
    private final int minCount;
    private final int maxCount;
    boolean showAsRequired = false;

    public PositionalOptionDefinition(IOptionKey id, String name, int minCount, int maxCount) {
        this(id, name, minCount, maxCount, null);
    }

    public PositionalOptionDefinition(IOptionKey id, String name, int minCount, int maxCount, String delimiter) {
        super(id, name, delimiter);
        if (minCount > maxCount && maxCount != -1) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.PositionalOptionDefinition_0, (Object)minCount, (Object)maxCount));
        }
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public PositionalOptionDefinition(String name, int minCount, int maxCount) {
        this(USE_SELF_AS_ID, name, minCount, maxCount, null);
    }

    public PositionalOptionDefinition(String name, int minCount, int maxCount, String delimiter) {
        this(USE_SELF_AS_ID, name, minCount, maxCount, delimiter);
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public int getMinCount() {
        return this.minCount;
    }

    @Override
    public String toString() {
        return super.getName();
    }

    @Override
    public boolean isRequired() {
        return this.getMinCount() > 0;
    }

    @Override
    public void setShowAsRequired() {
        this.showAsRequired = true;
    }

    @Override
    public boolean isShowAsRequired() {
        return this.showAsRequired;
    }
}

