/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.parser;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class Options {
    private final boolean stopOnUnknownValue;
    private final LinkedList<IPositionalOptionDefinition> positionalOptions = new LinkedList();
    private final List<INamedOptionDefinition> namedOptions = new LinkedList<INamedOptionDefinition>();
    private final HashMap<INamedOptionDefinition, Boolean> topLevelNamedOptions = new HashMap();
    private final List<Object> printOptions = new LinkedList<Object>();
    List<MutuallyExclusiveGroup> mutuallyExclusiveOptions = new LinkedList<MutuallyExclusiveGroup>();
    private boolean supportsNewHelpFormat = false;
    String longHelp = null;
    private boolean hideCommonOptions = true;
    public static final int ARG_INFINITE = -1;
    private final List<HelpPair> optionHelp = new LinkedList<HelpPair>();

    public Options(boolean stopOnUnknownValue) {
        this(stopOnUnknownValue, false);
    }

    public Options(boolean stopOnUnknownValue, boolean supportsNewHelpFormat) {
        this.stopOnUnknownValue = stopOnUnknownValue;
        this.supportsNewHelpFormat = supportsNewHelpFormat;
    }

    public Options addOption(IOptionKey key, String shortOpt, String longOpt, String help, int argCount) throws ConflictingOptionException {
        NamedOptionDefinition opt = new NamedOptionDefinition(key, shortOpt, longOpt, argCount);
        return this.addOption(opt, help, false);
    }

    public Options addOption(IOptionKey key, String shortOpt, String longOpt, String help, int argCount, String delimiter) throws ConflictingOptionException {
        NamedOptionDefinition opt = new NamedOptionDefinition(key, shortOpt, longOpt, argCount, delimiter);
        return this.addOption(opt, help, false);
    }

    public boolean hasOption(IOptionKey key) {
        return this.getOption(key) != null;
    }

    public IOptionDefinition getOption(IOptionKey key) {
        for (INamedOptionDefinition iNamedOptionDefinition : this.namedOptions) {
            if (!key.equals(iNamedOptionDefinition.getId())) continue;
            return iNamedOptionDefinition;
        }
        for (IPositionalOptionDefinition iPositionalOptionDefinition : this.positionalOptions) {
            if (!key.equals(iPositionalOptionDefinition.getId())) continue;
            return iPositionalOptionDefinition;
        }
        return null;
    }

    public LinkedList<IPositionalOptionDefinition> getPositionalOptions() {
        return this.positionalOptions;
    }

    public Options addOption(IPositionalOptionDefinition opt, String helpText) throws ConflictingOptionException {
        if (this.positionalOptionsAreInfinite()) {
            IPositionalOptionDefinition last = this.positionalOptions.getLast();
            throw new IllegalArgumentException(NLS.bind((String)Messages.Options_0, (Object)last.getId().toString()));
        }
        this.ensureNonConflicting(opt);
        this.positionalOptions.add(opt);
        this.printOptions.add(opt);
        this.optionHelp.add(new HelpPair(opt.getId(), helpText));
        return this;
    }

    public boolean positionalOptionsAreInfinite() {
        if (this.positionalOptions.size() > 0) {
            IPositionalOptionDefinition last = this.positionalOptions.getLast();
            return last.getMaxCount() == -1;
        }
        return false;
    }

    public Options addOption(INamedOptionDefinition opt, String helpString) throws ConflictingOptionException {
        return this.addOption(opt, helpString, false);
    }

    public Options addOption(INamedOptionDefinition opt, String helpString, boolean isRequired) throws ConflictingOptionException {
        if (opt.getId() == null) {
            throw new IllegalArgumentException(Messages.Options_1);
        }
        this.ensureNonConflicting(opt);
        this.namedOptions.add(opt);
        this.topLevelNamedOptions.put(opt, isRequired);
        this.printOptions.add(opt);
        this.optionHelp.add(new HelpPair(opt.getId(), helpString));
        return this;
    }

    public Options addOption(IOptionGroup grp) throws ConflictingOptionException {
        this.addNamedOptionsFromGroup(grp);
        this.addPositionalOptionsFromGroup(grp);
        this.printOptions.add(grp);
        return this;
    }

    private void addNamedOptionsFromGroup(IOptionGroup grp) {
        Collection<Pair<INamedOptionDefinition, String>> namedOptionsFromGrp = grp.getNamedOptionsWithHelp();
        for (Pair<INamedOptionDefinition, String> p : namedOptionsFromGrp) {
            INamedOptionDefinition opt = p.getFirst();
            if (opt.getId() == null) {
                throw new IllegalArgumentException(Messages.Options_1);
            }
            try {
                this.ensureNonConflicting(opt);
            }
            catch (ConflictingOptionException exp) {
                continue;
            }
            this.namedOptions.add(opt);
            this.optionHelp.add(new HelpPair(opt.getId(), p.getSecond()));
        }
    }

    private void addPositionalOptionsFromGroup(IOptionGroup grp) throws ConflictingOptionException {
        Collection<Pair<IPositionalOptionDefinition, String>> positionalOptionsWithHelp = grp.getPositionalOptionsWithHelp();
        for (Pair<IPositionalOptionDefinition, String> positionalOpt : positionalOptionsWithHelp) {
            IPositionalOptionDefinition positionalDef = positionalOpt.getFirst();
            if (positionalDef.getId() == null) {
                throw new IllegalArgumentException(Messages.Options_1);
            }
            try {
                this.ensureNonConflicting(positionalDef);
            }
            catch (ConflictingOptionException exp) {
                continue;
            }
            this.positionalOptions.add(positionalDef);
            this.optionHelp.add(new HelpPair(positionalDef.getId(), positionalOpt.getSecond()));
        }
    }

    private void ensureNonConflicting(IOptionDefinition opt) throws ConflictingOptionException {
        if (this.hasOption(opt.getId())) {
            throw new ConflictingOptionException(opt, null, "id", opt.getId().getName());
        }
        for (IOptionDefinition iOptionDefinition : this.namedOptions) {
            if (!iOptionDefinition.getName().equals(opt.getName())) continue;
            throw new ConflictingOptionException(opt, iOptionDefinition, "name", iOptionDefinition.getName());
        }
        for (IOptionDefinition iOptionDefinition : this.positionalOptions) {
            if (!iOptionDefinition.getName().equals(opt.getName())) continue;
            throw new ConflictingOptionException(opt, iOptionDefinition, "name", iOptionDefinition.getName());
        }
        if (opt instanceof INamedOptionDefinition) {
            INamedOptionDefinition iNamedOptionDefinition = (INamedOptionDefinition)opt;
            for (INamedOptionDefinition current : this.namedOptions) {
                String shortOpt = current.getShortOpt();
                if (shortOpt != null && shortOpt.equals(iNamedOptionDefinition.getShortOpt())) {
                    throw new ConflictingOptionException(opt, current, "shortOpt", current.getShortOpt());
                }
                String longOpt = current.getLongOpt();
                if (longOpt == null || !longOpt.equals(iNamedOptionDefinition.getLongOpt())) continue;
                throw new ConflictingOptionException(opt, current, "longOpt", current.getLongOpt());
            }
        }
    }

    public List<INamedOptionDefinition> getNamedOptions() {
        return this.namedOptions;
    }

    public HashMap<INamedOptionDefinition, Boolean> getTopLevelNamedOptions() {
        return this.topLevelNamedOptions;
    }

    public boolean shouldStopOnUnknownValue() {
        return this.stopOnUnknownValue;
    }

    public void setLongHelp(String longHelp) {
        this.longHelp = longHelp;
    }

    public String getLongHelp() {
        return this.longHelp;
    }

    public String getHelpFor(IOptionKey optionKey) {
        for (HelpPair pair : this.optionHelp) {
            if (pair.key != optionKey) continue;
            return pair.help;
        }
        throw new IllegalArgumentException(Messages.Options_2);
    }

    public void setSupportsNewHelp(boolean isSupported) {
        this.supportsNewHelpFormat = isSupported;
    }

    public boolean getSupportsNewHelp() {
        return this.supportsNewHelpFormat;
    }

    public Collection<Object> getAllOptions() {
        return this.printOptions;
    }

    public boolean isHideCommonOptions() {
        return this.hideCommonOptions;
    }

    public boolean setHideCommonOptions(boolean hide) {
        this.hideCommonOptions = hide;
        return this.hideCommonOptions;
    }

    private static class HelpPair {
        final IOptionKey key;
        final String help;

        public HelpPair(IOptionKey optionKey, String helpText) {
            this.key = optionKey;
            this.help = helpText;
        }
    }
}

