/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.parser;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.AbstractOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;

public class NamedOptionDefinition
extends AbstractOptionDefinition
implements INamedOptionDefinition {
    private final String shortOpt;
    private final String longOpt;
    private final int argCount;
    private final int minArgCount;
    private boolean hideOption = false;
    private boolean isCommonOption = false;

    public NamedOptionDefinition(IOptionKey id, String shortOpt, String longOpt, int argCount) {
        this(id, longOpt, shortOpt, longOpt, argCount, argCount, null);
    }

    public NamedOptionDefinition(IOptionKey id, String shortOpt, String longOpt, int argCount, String delimiter) {
        this(id, longOpt, shortOpt, longOpt, argCount, argCount, delimiter);
    }

    public NamedOptionDefinition(IOptionKey id, String shortOpt, String longOpt, int minArgCount, int argCount) {
        this(id, longOpt, shortOpt, longOpt, minArgCount, argCount, null);
    }

    public NamedOptionDefinition(IOptionKey id, String shortOpt, String longOpt, int minArgCount, int argCount, String delimiter) {
        this(id, longOpt, shortOpt, longOpt, minArgCount, argCount, delimiter);
    }

    public NamedOptionDefinition(IOptionKey id, String name, String shortOpt, String longOpt, int argCount) {
        this(id, name, shortOpt, longOpt, argCount, argCount, null);
    }

    public NamedOptionDefinition(IOptionKey id, String name, String shortOpt, String longOpt, int argCount, String delimiter) {
        this(id, name, shortOpt, longOpt, argCount, argCount, delimiter);
    }

    public NamedOptionDefinition(IOptionKey id, String name, String shortOpt, String longOpt, int minArgCount, int argCount, String delimiter) {
        super(id, name, delimiter);
        if (shortOpt != null && shortOpt.length() != 1) {
            throw new IllegalArgumentException(Messages.NamedOptionDefinition_0);
        }
        if (longOpt != null && longOpt.startsWith("--")) {
            throw new IllegalArgumentException(Messages.NamedOptionDefinition_1);
        }
        this.shortOpt = shortOpt;
        this.longOpt = longOpt;
        this.argCount = argCount;
        this.minArgCount = minArgCount;
    }

    public NamedOptionDefinition(String shortOpt, String longOpt, int argCount) {
        this(USE_SELF_AS_ID, shortOpt, longOpt, argCount, null);
    }

    public NamedOptionDefinition(String shortOpt, String longOpt, int argCount, boolean isCommonOption) {
        this(USE_SELF_AS_ID, shortOpt, longOpt, argCount, null);
        this.isCommonOption = isCommonOption;
    }

    public NamedOptionDefinition(String shortOpt, String longOpt, int argCount, String delimiter) {
        this(USE_SELF_AS_ID, shortOpt, longOpt, argCount, delimiter);
    }

    public NamedOptionDefinition(String shortOpt, String longOpt, int minArgCount, int argCount, String delimiter) {
        this(USE_SELF_AS_ID, longOpt, shortOpt, longOpt, minArgCount, argCount, delimiter);
    }

    @Override
    public String getShortOpt() {
        return this.shortOpt;
    }

    @Override
    public String getLongOpt() {
        return this.longOpt;
    }

    @Override
    public int getArgCount() {
        return this.argCount;
    }

    @Override
    public int getMinArgCount() {
        return this.minArgCount;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.shortOpt != null) {
            buf.append("-");
            buf.append(this.shortOpt);
        }
        if (this.longOpt != null) {
            if (buf.length() > 0) {
                buf.append("/");
            }
            buf.append("--");
            buf.append(this.longOpt);
        }
        return buf.toString();
    }

    public void hideOption() {
        this.hideOption = true;
    }

    @Override
    public boolean isHidden() {
        return this.hideOption;
    }

    @Override
    public boolean isRequired() {
        return this.getMinArgCount() > 0;
    }

    @Override
    public boolean isCommonOption() {
        return this.isCommonOption;
    }

    @Override
    public void setCommonOption(boolean isCommonOption) {
        this.isCommonOption = isCommonOption;
    }
}

