/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.parser;

import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.SimpleGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.util.Pair;
import java.util.Collection;
import java.util.LinkedList;

public class ContinuousGroup
extends OptionGroup {
    private final LinkedList<IOptionGroup> groups = new LinkedList();

    public ContinuousGroup() {
    }

    public ContinuousGroup(boolean isRequired) {
        super(isRequired);
    }

    public ContinuousGroup(ContinuousGroup continuousGroup) {
        super(continuousGroup.isRequired(), continuousGroup.isHidden());
        for (IOptionGroup group : continuousGroup.groups) {
            this.groups.add(group);
        }
    }

    public ContinuousGroup addOption(INamedOptionDefinition opt, String helpString, boolean isRequired) {
        return this.addOptionHelper(opt, helpString, isRequired);
    }

    public ContinuousGroup addOption(IPositionalOptionDefinition opt, String helpString, boolean isRequired) {
        return this.addOptionHelper(opt, helpString, isRequired);
    }

    public ContinuousGroup addOption(IOptionKey optKey, String shortOpt, String longOpt, String helpString, int argCount, boolean isRequired) {
        NamedOptionDefinition opt = new NamedOptionDefinition(optKey, shortOpt, longOpt, argCount);
        return this.addOptionHelper(opt, helpString, isRequired);
    }

    public ContinuousGroup addOption(SimpleGroup group) {
        this.groups.add(group);
        return this;
    }

    public ContinuousGroup addOption(MutuallyExclusiveGroup group) {
        this.groups.add(group);
        return this;
    }

    private ContinuousGroup addOptionHelper(INamedOptionDefinition opt, String helpString, boolean isRequired) {
        SimpleGroup grp = new SimpleGroup(isRequired, opt.isHidden());
        grp.addOption(opt, helpString, isRequired);
        this.groups.add(grp);
        return this;
    }

    private ContinuousGroup addOptionHelper(IPositionalOptionDefinition opt, String helpString, boolean isRequired) {
        SimpleGroup grp = new SimpleGroup(isRequired);
        grp.addOption(opt, helpString);
        this.groups.add(grp);
        return this;
    }

    public Collection<IOptionGroup> getOptions() {
        return this.groups;
    }

    public Collection<SimpleGroup> getSimpleGroups() {
        LinkedList<SimpleGroup> simpleGroups = new LinkedList<SimpleGroup>();
        for (IOptionGroup grp : this.groups) {
            if (!(grp instanceof SimpleGroup)) continue;
            simpleGroups.add((SimpleGroup)grp);
        }
        return simpleGroups;
    }

    public Collection<MutuallyExclusiveGroup> getMutuallyExclusiveGroups() {
        LinkedList<MutuallyExclusiveGroup> mutuallyExclusiveGroups = new LinkedList<MutuallyExclusiveGroup>();
        for (IOptionGroup grp : this.groups) {
            if (!(grp instanceof MutuallyExclusiveGroup)) continue;
            mutuallyExclusiveGroups.add((MutuallyExclusiveGroup)grp);
        }
        return mutuallyExclusiveGroups;
    }

    @Override
    public Collection<Pair<INamedOptionDefinition, String>> getNamedOptionsWithHelp() {
        LinkedList<Pair<INamedOptionDefinition, String>> flattenedNamedOptions = new LinkedList<Pair<INamedOptionDefinition, String>>();
        for (IOptionGroup grp : this.groups) {
            flattenedNamedOptions.addAll(grp.getNamedOptionsWithHelp());
        }
        return flattenedNamedOptions;
    }

    @Override
    public Collection<INamedOptionDefinition> getNamedOptions() {
        LinkedList<INamedOptionDefinition> flattenedNamedOptions = new LinkedList<INamedOptionDefinition>();
        for (IOptionGroup grp : this.groups) {
            flattenedNamedOptions.addAll(grp.getNamedOptions());
        }
        return flattenedNamedOptions;
    }

    @Override
    public Collection<IPositionalOptionDefinition> getPositionalOptions() {
        LinkedList<IPositionalOptionDefinition> posOptions = new LinkedList<IPositionalOptionDefinition>();
        for (IOptionGroup grp : this.groups) {
            posOptions.addAll(grp.getPositionalOptions());
        }
        return posOptions;
    }

    @Override
    public Collection<Pair<IPositionalOptionDefinition, String>> getPositionalOptionsWithHelp() {
        LinkedList<Pair<IPositionalOptionDefinition, String>> posOptions = new LinkedList<Pair<IPositionalOptionDefinition, String>>();
        for (IOptionGroup grp : this.groups) {
            posOptions.addAll(grp.getPositionalOptionsWithHelp());
        }
        return posOptions;
    }

    @Override
    public boolean hasCommonOptions() {
        for (IOptionGroup group : this.groups) {
            if (!group.hasCommonOptions()) continue;
            return true;
        }
        return false;
    }
}

