/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.parser;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.CommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.MalformedArgumentException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class CommandLine
implements ICommandLine {
    final List<String> unconsumed;
    final Options options;
    private final Map<IOptionKey, OptValueArg> namedOpts;
    private final Map<IOptionKey, OptValueArg> positionalOpts;

    public CommandLine(Options options, Map<IOptionKey, OptValue> namedOpts, Map<IOptionKey, OptValue> posOpts, LinkedList<String> unconsumed) throws MalformedArgumentException {
        this.options = options;
        this.namedOpts = this.getOptArgs(namedOpts);
        this.positionalOpts = this.getOptArgs(posOpts);
        this.unconsumed = unconsumed;
    }

    @Override
    public boolean hasOption(IOptionKey id) {
        return this.namedOpts.containsKey(id) || this.positionalOpts.containsKey(id);
    }

    public boolean hasOption(IOptionKey id, Map<IOptionKey, OptValue> opts) {
        if (this.namedOpts != null) {
            return this.namedOpts.containsKey(id);
        }
        return opts.containsKey(id);
    }

    @Override
    public String getOption(IOptionKey argName) {
        ICommandLineArgument value = this.getOptionValue(argName);
        return value != null ? value.getValue() : null;
    }

    @Override
    public List<String> getOptions(IOptionKey argName) {
        List<ICommandLineArgument> argList = this.getOptionValues(argName);
        ArrayList<String> selectors = new ArrayList<String>(argList.size());
        for (ICommandLineArgument arg : argList) {
            selectors.add(arg.getValue());
        }
        return selectors;
    }

    @Override
    public List<String> getUnconsumedArgs() {
        return this.unconsumed;
    }

    @Override
    public Collection<IOptionKey> getDefinedOpts() {
        ArrayList<IOptionKey> allKeys = new ArrayList<IOptionKey>(this.namedOpts.size() + this.positionalOpts.size());
        allKeys.addAll(this.namedOpts.keySet());
        allKeys.addAll(this.positionalOpts.keySet());
        return allKeys;
    }

    @Override
    public String getOption(IOptionKey argName, String defaultValue) {
        CommandLineArgument defaultArg = new CommandLineArgument(argName, defaultValue);
        ICommandLineArgument value = this.getOptionValue(argName, defaultArg);
        return value.getValue();
    }

    @Override
    public Options getDefinition() {
        return this.options;
    }

    private Map<IOptionKey, OptValueArg> getOptArgs(Map<IOptionKey, OptValue> opts) throws MalformedArgumentException {
        HashMap<IOptionKey, OptValueArg> optValueMap = new HashMap<IOptionKey, OptValueArg>();
        for (Map.Entry<IOptionKey, OptValue> optEntry : opts.entrySet()) {
            OptValueArg valueArg = this.constructCommandLineArg(optEntry.getKey(), optEntry.getValue());
            optValueMap.put(optEntry.getKey(), valueArg);
        }
        return optValueMap;
    }

    private OptValueArg getOptionValue(IOptionKey id, boolean isRequired) {
        OptValueArg toReturn = this.namedOpts.get(id);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = this.positionalOpts.get(id);
        if (toReturn != null) {
            return toReturn;
        }
        if (toReturn == null && !isRequired) {
            return null;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.CommandLine_3, (Object)id.toString()));
    }

    @Override
    public ICommandLineArgument getOptionValue(IOptionKey argName) {
        IOptionDefinition optDef = this.options.getOption(argName);
        OptValueArg value = this.getOptionValue(argName, optDef.isRequired());
        if (!(optDef.isRequired() || value != null && value.args != null && value.args.size() != 0)) {
            return null;
        }
        if (value == null || value.args == null || value.args.size() == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.CommandLine_0, (Object)argName));
        }
        if (value.args.size() > 1) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.CommandLine_1, (Object)argName));
        }
        return value.args.get(0);
    }

    @Override
    public ICommandLineArgument getOptionValue(IOptionKey argName, ICommandLineArgument defaultValue) {
        ICommandLineArgument value = null;
        if (this.hasOption(argName)) {
            value = this.getOptionValue(argName);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public List<ICommandLineArgument> getOptionValues(IOptionKey argName) {
        if (!this.hasOption(argName)) {
            throw new NoSuchElementException(argName.toString());
        }
        IOptionDefinition optDef = this.options.getOption(argName);
        OptValueArg value = this.getOptionValue(argName, optDef.isRequired());
        List<ICommandLineArgument> selectors = value != null ? value.args : Collections.emptyList();
        return selectors;
    }

    private int lastIndexOfDelimiter(String inputStr) {
        String selectorSplitRegEx = "(?<!\\\\)@";
        Pattern pattern = Pattern.compile("(?<!\\\\)@");
        Matcher matcher = pattern.matcher(inputStr);
        int lastIndex = -1;
        while (matcher.find()) {
            lastIndex = matcher.start();
        }
        return lastIndex;
    }

    private String[] splitOnLastIndex(String inputStr) {
        ArrayList<String> result = new ArrayList<String>(2);
        int lastIndex = this.lastIndexOfDelimiter(inputStr);
        if (lastIndex != -1) {
            if (lastIndex == inputStr.length() - 1) {
                result.add(0, inputStr);
            } else {
                result.add(0, inputStr.substring(0, lastIndex));
                result.add(1, inputStr.substring(lastIndex + 1));
            }
        } else {
            result.add(0, inputStr);
        }
        return result.toArray(new String[result.size()]);
    }

    private OptValueArg constructCommandLineArg(IOptionKey option, OptValue value) throws MalformedArgumentException {
        ArrayList<ICommandLineArgument> cmdLineArgs = new ArrayList<ICommandLineArgument>();
        if (value.args == null) {
            return null;
        }
        String delimiter = option.getDelimiter();
        String prefix = null;
        String suffix = null;
        for (String str : value.args) {
            String[] tokens = new String[]{};
            if (delimiter != null) {
                if (str.startsWith(delimiter)) {
                    throw new MalformedArgumentException(str);
                }
                tokens = this.splitOnLastIndex(str);
                switch (tokens.length) {
                    case 1: {
                        prefix = str.indexOf(delimiter) == -1 ? str : this.stripEscapedChars(tokens[0], delimiter);
                        suffix = null;
                        break;
                    }
                    case 2: {
                        prefix = tokens[0].indexOf(delimiter) == -1 ? tokens[0] : this.stripEscapedChars(tokens[0], delimiter);
                        suffix = tokens[1].indexOf(delimiter) == -1 ? tokens[1] : this.stripEscapedChars(tokens[1], delimiter);
                    }
                }
                cmdLineArgs.add(new CommandLineArgument(option, str, prefix, suffix));
                continue;
            }
            cmdLineArgs.add(new CommandLineArgument(option, str, str, null));
        }
        return new OptValueArg(cmdLineArgs);
    }

    private String stripEscapedChars(String selector, String delimiter) {
        StringBuffer selectorBuf = new StringBuffer();
        assert (selector != null);
        int delimLen = delimiter.length();
        int i = 0;
        while (i < selector.length()) {
            int index;
            boolean strip = false;
            if (selector.charAt(i) == '\\' && i + delimLen <= selector.length() && (index = selector.indexOf(delimiter, i + delimLen)) != -1 && index == i + delimLen) {
                strip = true;
            }
            if (!strip) {
                selectorBuf.append(selector.charAt(i));
                ++i;
                continue;
            }
            i += delimLen;
        }
        return selectorBuf.toString();
    }

    static class OptValue {
        final List<String> args;

        OptValue(List<String> args) {
            this.args = args;
        }
    }

    static class OptValueArg {
        final List<ICommandLineArgument> args;

        OptValueArg(List<ICommandLineArgument> args) {
            this.args = args;
        }
    }
}

