/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.parser;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IExecutionContext;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.CommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IParseController;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ArgumentOverflowException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ArgumentUnderflowException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.MalformedCommandLineException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.MalformedOptException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.UnknownOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringMatcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CLIParser {
    public static final String PREFIX_LONGOPT = "--";
    public static final String PREFIX_SHORTOPT = "-";
    private final Options options;
    private final String[] commandLine;

    public void halt() {
    }

    public CLIParser(Options opts, String[] commandLine) {
        this.options = opts;
        this.commandLine = commandLine;
    }

    public CLIParser(Options opts, List<String> list) {
        this.options = opts;
        this.commandLine = list.toArray(new String[0]);
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> expandWildCardArgs(String[] args, String[] ignoreStrs, IExecutionContext context) throws IOException {
        finalArgList = new ArrayList<String>();
        expandedArgList = new ArrayList<String>();
        ignoreList = new ArrayList<StringMatcher>();
        if (ignoreStrs != null) {
            var9_6 = ignoreStrs;
            var8_7 = ignoreStrs.length;
            var7_9 = 0;
            while (var7_9 < var8_7) {
                ignoreStr = var9_6[var7_9];
                ignoreList.add(new StringMatcher(ignoreStr, false, false));
                ++var7_9;
            }
        }
        if (!(dir = (currDir1 = new Path(wd = context.getCurrentWorkingDirectory())).toFile()).exists()) {
            finalArgList.addAll(0, Arrays.asList(args));
            return finalArgList;
        }
        env = context.environment();
        var13_12 = args;
        var12_13 = args.length;
        var11_14 = 0;
        while (var11_14 < var12_13) {
            arg = var13_12[var11_14];
            pathStr = new Path(arg);
            if (pathStr.getDevice() == null || pathStr.isAbsolute()) ** GOTO lbl34
            deviceId = pathStr.getDevice();
            if (deviceId.length() > 2) {
                finalArgList.add(arg);
            } else {
                key = "=" + deviceId;
                pathStr = new Path(String.valueOf(env.get(key)) + File.separator + arg.substring(2, arg.length()));
                arg = pathStr.toOSString();
lbl34:
                // 2 sources

                if (!arg.contains("*") && !arg.contains("?")) {
                    finalArgList.add(arg);
                } else if (!CLIParser.checkEscaped(arg, finalArgList)) {
                    idx = 0;
                    currDir = currDir1;
                    paths = pathStr.segments();
                    if (pathStr.isAbsolute()) {
                        cwd = null;
                        cwd = pathStr.getDevice() != null ? new Path(String.valueOf(pathStr.getDevice()) + File.separator) : new Path(File.separator);
                        var22_28 = paths;
                        var21_27 = paths.length;
                        var20_25 = 0;
                        while (var20_25 < var21_27) {
                            str = var22_28[var20_25];
                            if (str.contains("*") || str.contains("?")) break;
                            cwd = cwd.append(str);
                            ++idx;
                            ++var20_25;
                        }
                        currDir = cwd;
                    }
                    hasTrailingSeparator = pathStr.hasTrailingSeparator() != false;
                    expandedArgList.add(currDir.toString());
                    i = idx;
                    while (i < pathStr.segmentCount()) {
                        pathSgmt = pathStr.segment(i);
                        if (!CLIParser.expandPath((IPath)currDir, pathSgmt, expandedArgList, finalArgList, ignoreList, i == idx, i == paths.length - 1, hasTrailingSeparator)) {
                            expandedArgList.clear();
                            finalArgList.add(arg);
                            break;
                        }
                        ++i;
                    }
                }
            }
            ++var11_14;
        }
        return finalArgList;
    }

    private static boolean checkEscaped(String arg, ArrayList<String> finalArgList) {
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        boolean handledEscaped = false;
        char[] cArray = arg.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\\': {
                    escaped = true;
                    break;
                }
                case '*': {
                    if (!escaped) break;
                    builder.append('*');
                    escaped = false;
                    handledEscaped = true;
                    break;
                }
                case '?': {
                    if (!escaped) break;
                    builder.append('?');
                    escaped = false;
                    handledEscaped = true;
                    break;
                }
                default: {
                    if (escaped) {
                        builder.append('\\');
                        escaped = false;
                    }
                    builder.append(c);
                }
            }
            ++n2;
        }
        if (handledEscaped) {
            finalArgList.add(builder.toString());
        }
        return handledEscaped;
    }

    private static boolean expandPath(IPath currDir, String pattern, ArrayList<String> expandedArgList, ArrayList<String> finalArgList, List<StringMatcher> ignoreStrs, boolean isFirstSgmt, boolean isLastSgmt, boolean hasTrailingSeparator) throws IOException {
        boolean matchFound = false;
        boolean isAPattern = pattern.contains("*") || pattern.contains("?");
        ArrayList<String> newlyExpandedArgList = new ArrayList<String>();
        for (String pathStr : expandedArgList) {
            Path cwd = null;
            cwd = isFirstSgmt ? new Path(currDir.toString()) : new Path(pathStr);
            if (!isAPattern) {
                Path filePath = new Path(String.valueOf(cwd.toOSString()) + File.separator + pattern);
                File file = filePath.toFile();
                if ((!file.exists() || isLastSgmt || !file.isDirectory()) && !isLastSgmt || isLastSgmt && hasTrailingSeparator && !file.isDirectory() || ignoreStrs.size() > 0 && CLIParser.shouldIgnoreFile(ignoreStrs, filePath.toOSString(), file.getName())) continue;
                String result = filePath.toOSString();
                matchFound = true;
                if (isLastSgmt && !finalArgList.contains(result)) {
                    finalArgList.add(result);
                    continue;
                }
                newlyExpandedArgList.add(result);
                continue;
            }
            File dir = cwd.toFile();
            File[] children = dir.listFiles();
            if (children == null) continue;
            StringMatcher strMatcher = new StringMatcher(pattern, false, false);
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                Path filePath = new Path(String.valueOf(cwd.toOSString()) + File.separator + fileName);
                if (!(!strMatcher.match(fileName) || !isLastSgmt && !file.isDirectory() || isLastSgmt && hasTrailingSeparator && !file.isDirectory() || ignoreStrs.size() > 0 && CLIParser.shouldIgnoreFile(ignoreStrs, filePath.toOSString(), fileName))) {
                    matchFound = true;
                    String result = filePath.toOSString();
                    if (isLastSgmt) {
                        if (!finalArgList.contains(result)) {
                            finalArgList.add(result);
                        }
                    } else {
                        newlyExpandedArgList.add(result);
                    }
                }
                ++n2;
            }
        }
        expandedArgList.clear();
        expandedArgList.addAll(newlyExpandedArgList);
        return matchFound;
    }

    private static boolean shouldIgnoreFile(List<StringMatcher> ignoreStrs, String filePath, String fileName) {
        for (StringMatcher ignoreStr : ignoreStrs) {
            if (ignoreStr.match(filePath)) {
                return true;
            }
            if (!ignoreStr.match(fileName)) continue;
            return true;
        }
        return false;
    }

    public ICommandLine parse() throws MalformedCommandLineException {
        INamedOptionDefinition currentOpt = null;
        LinkedList<String> currentOptArgs = null;
        HashMap<IOptionKey, CommandLine.OptValue> namedOpts = new HashMap<IOptionKey, CommandLine.OptValue>();
        PositionalArgumentAccumulator positionalArgs = new PositionalArgumentAccumulator();
        ParseController parseController = new ParseController();
        int i = 0;
        while (i < this.commandLine.length && parseController.carryOn()) {
            String item = this.commandLine[i];
            INamedOptionDefinition opt = null;
            try {
                opt = this.asOpt(item);
            }
            catch (UnknownOptionException e) {
                if (this.options.shouldStopOnUnknownValue()) break;
                throw e;
            }
            if (opt == null) {
                if (currentOpt == null) {
                    try {
                        positionalArgs.addPositionalArg(item, parseController);
                    }
                    catch (ArgumentOverflowException e) {
                        if (this.options.shouldStopOnUnknownValue()) break;
                        throw e;
                    }
                } else if (currentOpt.getArgCount() == -1 || currentOpt.getArgCount() > currentOptArgs.size()) {
                    currentOpt.matchArgument(parseController);
                    currentOptArgs.add(item);
                    if (currentOpt.getArgCount() == currentOptArgs.size()) {
                        namedOpts.put(currentOpt.getId(), new CommandLine.OptValue(currentOptArgs));
                        currentOpt = null;
                        currentOptArgs = null;
                    }
                }
            } else {
                if (namedOpts.containsKey(opt.getId())) {
                    throw new MalformedOptException(item, Messages.RepeatedNamedOption);
                }
                if (currentOpt == null) {
                    if (opt.getArgCount() == 0) {
                        namedOpts.put(opt.getId(), new CommandLine.OptValue(currentOptArgs));
                    } else {
                        currentOpt = opt;
                        currentOptArgs = new LinkedList<String>();
                    }
                } else if (currentOpt.getArgCount() == -1 && currentOpt.getMinArgCount() == 0 || currentOpt.getArgCount() == 0 || currentOptArgs.size() >= currentOpt.getMinArgCount()) {
                    namedOpts.put(currentOpt.getId(), new CommandLine.OptValue(currentOptArgs));
                    if (opt.getArgCount() == 0) {
                        namedOpts.put(opt.getId(), new CommandLine.OptValue(currentOptArgs));
                        currentOpt = null;
                        currentOptArgs = null;
                    } else {
                        currentOpt = opt;
                        currentOptArgs = new LinkedList();
                    }
                } else {
                    throw new ArgumentUnderflowException(currentOpt.getArgCount(), currentOptArgs.size(), Collections.singletonList(currentOpt));
                }
            }
            ++i;
        }
        LinkedList<String> unconsumed = new LinkedList<String>();
        int j = i;
        while (j < this.commandLine.length) {
            unconsumed.add(this.commandLine[j]);
            ++j;
        }
        if (currentOpt != null) {
            if (currentOpt.getArgCount() == currentOptArgs.size() || currentOpt.getArgCount() == -1 && currentOpt.getMinArgCount() == 0 || currentOptArgs.size() >= currentOpt.getMinArgCount()) {
                namedOpts.put(currentOpt.getId(), new CommandLine.OptValue((List<String>)currentOptArgs));
                currentOpt = null;
                currentOptArgs = null;
            } else {
                throw new ArgumentUnderflowException(currentOpt.getArgCount(), currentOptArgs.size(), Collections.singletonList(currentOpt));
            }
        }
        positionalArgs.ensureSatisfied();
        return new CommandLine(this.options, namedOpts, positionalArgs.getArgs(), unconsumed);
    }

    protected INamedOptionDefinition asOpt(String item) throws MalformedCommandLineException {
        String optName;
        if (item.startsWith(PREFIX_LONGOPT) && item.length() >= PREFIX_LONGOPT.length()) {
            optName = item.substring(PREFIX_LONGOPT.length());
            for (INamedOptionDefinition candidate : this.options.getNamedOptions()) {
                if (!optName.equals(candidate.getLongOpt())) continue;
                return candidate;
            }
            if (!item.equals(PREFIX_LONGOPT)) {
                throw new UnknownOptionException(item);
            }
        }
        if (item.startsWith(PREFIX_SHORTOPT)) {
            if (item.length() == PREFIX_SHORTOPT.length()) {
                return null;
            }
            if (item.length() != PREFIX_SHORTOPT.length() + 1) {
                throw new MalformedOptException(item, Messages.CLIParser_1);
            }
            optName = item.substring(PREFIX_SHORTOPT.length());
            if (PREFIX_SHORTOPT.equals(optName)) {
                return null;
            }
            for (INamedOptionDefinition candidate : this.options.getNamedOptions()) {
                if (!optName.equals(candidate.getShortOpt())) continue;
                return candidate;
            }
            throw new UnknownOptionException(item);
        }
        return null;
    }

    private class ParseController
    implements IParseController {
        boolean haltAfterOption = false;

        private ParseController() {
        }

        @Override
        public void haltAfterOption() {
            this.haltAfterOption = true;
        }

        public boolean carryOn() {
            return !this.haltAfterOption;
        }
    }

    private class PositionalArgumentAccumulator {
        int totalArgsReceived = 0;
        protected LinkedList<IPositionalOptionDefinition> defs;
        protected Map<IOptionKey, CommandLine.OptValue> positionalOpts = new HashMap<IOptionKey, CommandLine.OptValue>();

        PositionalArgumentAccumulator() {
            this.defs = new LinkedList<IPositionalOptionDefinition>(CLIParser.this.options.getPositionalOptions());
        }

        void addPositionalArg(String newArg, ParseController parseController) throws ArgumentOverflowException {
            if (this.defs.isEmpty()) {
                throw new ArgumentOverflowException(-1, newArg);
            }
            IPositionalOptionDefinition def = this.defs.getFirst();
            def.matchArgument(parseController);
            IOptionKey id = def.getId();
            CommandLine.OptValue values = this.positionalOpts.get(id);
            if (values == null) {
                LinkedList<String> list = new LinkedList<String>();
                values = new CommandLine.OptValue(list);
                this.positionalOpts.put(id, values);
            }
            values.args.add(newArg);
            ++this.totalArgsReceived;
            if (values.args.size() >= def.getMaxCount() && def.getMaxCount() != -1) {
                this.defs.removeFirst();
            }
        }

        int getExpectedArgCount() {
            if (CLIParser.this.options.positionalOptionsAreInfinite()) {
                return -1;
            }
            int expected = 0;
            for (IPositionalOptionDefinition def : this.defs) {
                expected += def.getMaxCount();
            }
            return expected;
        }

        public void ensureSatisfied() throws ArgumentUnderflowException {
            int i = 0;
            while (i < this.defs.size()) {
                IPositionalOptionDefinition def = this.defs.get(i);
                IOptionKey id = def.getId();
                CommandLine.OptValue values = this.positionalOpts.get(id);
                if (values == null ? def.getMinCount() != 0 : values.args.size() < def.getMinCount()) {
                    throw new ArgumentUnderflowException(this.getExpectedArgCount(), this.totalArgsReceived, this.defs);
                }
                ++i;
            }
        }

        public Map<IOptionKey, CommandLine.OptValue> getArgs() {
            return this.positionalOpts;
        }
    }
}

