/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.core;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.core.SubcommandDefinition;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class SubcommandLoader {
    private static HashMap<String, SubcommandLoader> loaders;
    private static PrintStream printStream;
    List<ISubcommandDefinition> subcommands;
    private final String group;

    public static synchronized SubcommandLoader getScope(String groupName, PrintStream ps) {
        SubcommandLoader loader;
        if (groupName == null) {
            groupName = "";
        }
        printStream = ps;
        if (loaders == null) {
            loaders = new HashMap();
        }
        if ((loader = loaders.get(groupName)) == null) {
            loader = new SubcommandLoader(groupName);
            loaders.put(groupName, loader);
        }
        return loader;
    }

    public static Collection<String> getAllScopeNames() {
        IConfigurationElement[] configs;
        TreeSet<String> allScopes = new TreeSet<String>();
        IConfigurationElement[] iConfigurationElementArray = configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.rtc.cli.infrastructure", "subcommand");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            Collection<String> scopes = SubcommandDefinition.getScopes(config);
            allScopes.addAll(scopes);
            ++n2;
        }
        return allScopes;
    }

    public SubcommandLoader(String group) {
        this.group = group;
    }

    private void loadSubcommands() {
        if (this.subcommands != null) {
            return;
        }
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.rtc.cli.infrastructure", "subcommand");
        HashMap<String, SubcommandDefinition> idToDefn = new HashMap<String, SubcommandDefinition>();
        HashMap<String, ArrayList<String>> nameToId = new HashMap<String, ArrayList<String>>();
        ArrayList<String> defnsToIgnore = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (SubcommandDefinition.inGroup(config, this.group)) {
                SubcommandDefinition defn = new SubcommandDefinition(this, config, printStream);
                ArrayList<String> defnIds = (ArrayList<String>)nameToId.get(defn.getFullSubcommandName());
                SubcommandDefinition matchedDefn = null;
                if (defnIds == null || (matchedDefn = this.matchCommonParentDefinition(defn, (List<String>)defnIds, idToDefn)) == null) {
                    idToDefn.put(defn.getId(), defn);
                    if (defnIds == null) {
                        defnIds = new ArrayList<String>();
                        nameToId.put(defn.getFullSubcommandName(), defnIds);
                    }
                    defnIds.add(defn.getId());
                } else if (defn.getOverrideValue() > matchedDefn.getOverrideValue()) {
                    idToDefn.remove(matchedDefn.getId());
                    idToDefn.put(defn.getId(), defn);
                    defnIds.remove(matchedDefn.getId());
                    defnIds.add(defn.getId());
                    if (matchedDefn.getParentId() == null) {
                        defnsToIgnore.add(matchedDefn.getId());
                    }
                } else {
                    if (defn.getOverrideValue() == matchedDefn.getOverrideValue()) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.SubcommandLoader_MultipleExtensions, (Object[])new String[]{defn.getFullSubcommandName(), defn.getId(), matchedDefn.getId()}));
                    }
                    if (defn.getParentId() == null) {
                        defnsToIgnore.add(defn.getId());
                    }
                }
            }
            ++n2;
        }
        this.subcommands = new ArrayList<ISubcommandDefinition>(idToDefn.values().size());
        this.subcommands.addAll(idToDefn.values());
        Iterator<ISubcommandDefinition> it = this.subcommands.iterator();
        block1: while (it.hasNext()) {
            ISubcommandDefinition defn = it.next();
            if (defn.getParentId() == null) continue;
            for (String ignoreDefnId : defnsToIgnore) {
                if (!defn.getParentId().equals(ignoreDefnId)) continue;
                it.remove();
                continue block1;
            }
        }
    }

    private SubcommandDefinition matchCommonParentDefinition(SubcommandDefinition defn, List<String> defnIds, Map<String, SubcommandDefinition> idToDefn) {
        for (String defnId : defnIds) {
            SubcommandDefinition defn2 = idToDefn.get(defnId);
            if ((defn.getParentId() != null || defn2.getParentId() != null) && (defn.getParentId() == null || defn2.getParentId() == null || !defn.getParentId().equals(defn2.getParentId()))) continue;
            return defn2;
        }
        return null;
    }

    public boolean validate() {
        this.loadSubcommands();
        HashSet<String> ids = new HashSet<String>();
        for (ISubcommandDefinition d : this.subcommands) {
            SubcommandDefinition defn = (SubcommandDefinition)d;
            if (defn.getFullSubcommandName() == null) {
                throw new AssertionError((Object)NLS.bind((String)Messages.SubcommandLoader_0, (Object)defn.getId()));
            }
            String id = defn.getId();
            if (id == null) {
                throw new AssertionError((Object)NLS.bind((String)Messages.SubcommandLoader_1, (Object)defn.getFullSubcommandName()));
            }
            if (ids.contains(id)) {
                throw new AssertionError((Object)NLS.bind((String)Messages.SubcommandLoader_2, (Object)id));
            }
            ids.add(id);
            if (defn.getOptionsClass() == null && defn.getLongHelp() == null) {
                throw new AssertionError((Object)NLS.bind((String)Messages.SubcommandLoader_3, (Object)defn.getFullSubcommandName(), (Object)id));
            }
            if (defn.getParentId() == null) continue;
            HashSet<String> ancestors = new HashSet<String>();
            ISubcommandDefinition parent = defn.getParent();
            do {
                if (ancestors.contains(parent.getId())) {
                    throw new AssertionError((Object)NLS.bind((String)Messages.SubcommandLoader_4, (Object)defn.getId(), (Object)parent.getId()));
                }
                ancestors.add(parent.getId());
            } while ((parent = parent.getParent()) != null);
        }
        return true;
    }

    public ISubcommandDefinition loadToplevel(String name) {
        this.loadSubcommands();
        for (ISubcommandDefinition subcommand : this.subcommands) {
            if (!name.equals(subcommand.getFullSubcommandName()) || subcommand.getParent() != null) continue;
            return subcommand;
        }
        for (ISubcommandDefinition subcommand : this.subcommands) {
            String[] stringArray = subcommand.getAliases();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (name.equals(alias) && subcommand.getParent() == null) {
                    return subcommand;
                }
                ++n2;
            }
        }
        return null;
    }

    public Collection<ISubcommandDefinition> getAllDefinitions() {
        this.loadSubcommands();
        return this.subcommands;
    }

    public Collection<ISubcommandDefinition> getChildSubcommands(ISubcommandDefinition defn) {
        String id = defn.getId();
        if (id == null) {
            throw new IllegalArgumentException(Messages.SubcommandLoader_5);
        }
        this.loadSubcommands();
        ArrayList<ISubcommandDefinition> children = new ArrayList<ISubcommandDefinition>(this.subcommands.size());
        for (ISubcommandDefinition child : this.subcommands) {
            String parentId = child.getParentId();
            if (parentId == null || !id.equals(parentId)) continue;
            children.add(child);
        }
        return children;
    }
}

