/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.core;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.Constants;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IExecutionContext;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommand;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.core.SubcommandLoader;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.CLIParser;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.HaltingPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ArgumentOverflowException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ArgumentUnderflowException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.MalformedArgumentException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.MalformedCommandLineException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.MalformedOptException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.UnknownOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StatusHelper;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.rtc.cli.infrastructure.internal.util.SubcommandUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class SubcommandLauncher {
    private static final String SUBCOMMAND_HELP = "help";
    public static NamedOptionDefinition OPT_HELP = new NamedOptionDefinition("h", "help", 0);
    public static NamedOptionDefinition OPT_SYMBOLIC_HELP = new NamedOptionDefinition("?", "?", 0);
    private static final String SUBCOMMAND_VERSION = "version";
    public static final NamedOptionDefinition OPT_VERSION = new NamedOptionDefinition("v", "version", 0);
    public static HaltingPositionalOptionDefinition OPT_SUBCOMMAND_NAME = new HaltingPositionalOptionDefinition("command", 0, 1);
    public static final int UNINITIALIZED_RETURN_CODE = -1;
    private final String subcommandGroup;
    private SubcommandLoader loader;
    private static PrintStream err;
    private int returnValue = -1;
    public static final IOptionKey OPT_DISALLOW_INTERACTION;
    public static final IOptionKey OPT_CONFIG_LOCATION;
    public static final IOptionKey OPT_DRY_RUN;
    public static final IOptionKey OPT_NO_MASK;
    public static final IOptionKey OPT_SHOW_UUID;
    public static final IOptionKey OPT_SHOW_ALIAS;
    private static String[] ALWAYS_VALUES;
    private static String[] NEVER_VALUES;

    static {
        OPT_DISALLOW_INTERACTION = new OptionKey("non-interactive");
        OPT_CONFIG_LOCATION = new OptionKey("config");
        OPT_DRY_RUN = new OptionKey("dry-run");
        OPT_NO_MASK = new OptionKey("no-mask");
        OPT_SHOW_UUID = new OptionKey("show-uuid");
        OPT_SHOW_ALIAS = new OptionKey("show-alias");
        ALWAYS_VALUES = new String[]{"y", "yes"};
        NEVER_VALUES = new String[]{"n", "no"};
    }

    public SubcommandLauncher(String subcommandGroup, PrintStream err) {
        this.subcommandGroup = subcommandGroup;
        SubcommandLauncher.err = err;
    }

    public int run(IExecutionContext env, IApplicationContext appContext, IProgressMonitor progressMonitor) throws Exception {
        if (IClientConfiguration.DEBUG_TIMING) {
            SubcommandUtil.printDebugTiming(env, "Entering Application.start()", env.stderr());
        }
        try {
            this.doStart(env, appContext, progressMonitor);
            assert (this.returnValue != -1);
            int n = this.returnValue;
            return n;
        }
        catch (InternalErrorException e) {
            int n = this.returnValue;
            return n;
        }
        catch (Exception e) {
            err.println(Messages.Application_0);
            e.printStackTrace(env.stderr());
            throw e;
        }
        catch (Throwable t) {
            err.println(Messages.Application_0);
            t.printStackTrace(env.stderr());
            throw new RuntimeException(t);
        }
        finally {
            String prop;
            if (IClientConfiguration.DEBUG_OUTPUT && (prop = System.getProperty("eclipse.exitdata")) != null) {
                err.println(prop);
            }
        }
    }

    public void doStart(IExecutionContext ctx, IApplicationContext legacyContext, IProgressMonitor progressMonitor) throws InternalErrorException, CLIClientException {
        ISubcommandDefinition defn;
        ICommandLine args = null;
        String cmdName = null;
        this.loader = SubcommandLoader.getScope(this.subcommandGroup, ctx.stderr());
        try {
            args = this.parseCommandLine(ctx);
            cmdName = args.getOption(OPT_SUBCOMMAND_NAME, null);
        }
        catch (UnknownOptionException e) {
            throw this.complain(ctx, 1, Messages.Application_36, NLS.bind((String)Messages.Application_CONCATENATE, (Object)NLS.bind((String)Messages.Application_4, (Object)e.getOption()), (Object)NLS.bind((String)Messages.Application_1, (Object)ctx.getAppName())));
        }
        catch (ArgumentUnderflowException e) {
            List<? extends IOptionDefinition> missing = e.getMissingArguments();
            String msg = null;
            msg = missing.size() > 0 ? NLS.bind((String)Messages.Application_58, (Object)missing.iterator().next()) : Messages.Application_28;
            throw this.complain(ctx, 1, Messages.Application_28, msg);
        }
        catch (MalformedOptException e) {
            throw this.complain(ctx, 1, Messages.Application_29, NLS.bind((String)Messages.Application_CONCATENATE, (Object)NLS.bind((String)Messages.Application_6, (Object)e.getOption()), (Object)NLS.bind((String)Messages.Application_1, (Object)ctx.getAppName())));
        }
        catch (MalformedArgumentException e) {
            throw this.complain(ctx, 1, Messages.Application_MALFORMED_ARGUMENT, NLS.bind((String)Messages.Application_CONCATENATE, (Object)NLS.bind((String)Messages.Application_INVALID_SELECTOR, (Object)e.getArgument()), (Object)NLS.bind((String)Messages.Application_1, (Object)ctx.getAppName())));
        }
        catch (MalformedCommandLineException e) {
            e.printStackTrace(ctx.stderr());
            throw this.complain(ctx, 7, Messages.Application_30, e.getLocalizedMessage());
        }
        catch (ConflictingOptionException e) {
            e.printStackTrace(ctx.stderr());
            throw this.complain(ctx, 7, Messages.Application_31, e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace(ctx.stderr());
            throw this.complain(ctx, 7, Messages.Application_57, e.getLocalizedMessage());
        }
        CommandName commandName = CommandName.VALID;
        if (cmdName == null) {
            if (args.hasOption(OPT_VERSION)) {
                cmdName = SUBCOMMAND_VERSION;
            } else if (args.hasOption(OPT_HELP) || args.hasOption(OPT_SYMBOLIC_HELP)) {
                cmdName = SUBCOMMAND_HELP;
            } else {
                cmdName = SUBCOMMAND_HELP;
                commandName = CommandName.MISSING;
            }
        }
        if ((defn = this.loader.loadToplevel(cmdName)) == null) {
            defn = this.loader.loadToplevel(SUBCOMMAND_HELP);
            commandName = CommandName.UNKNOWN;
        }
        LinkedList<ISubcommandDefinition> parents = new LinkedList<ISubcommandDefinition>();
        ICommandLine subargs = null;
        if (commandName == CommandName.VALID) {
            int index = 0;
            List<String> unconsumed = args.getUnconsumedArgs();
            while (defn.isParent()) {
                if (index == unconsumed.size()) {
                    if (defn.isRunnable()) break;
                    CharSequence subcommands = SubcommandUtil.getExecutionString(defn);
                    throw this.complain(ctx, 1, NLS.bind((String)Messages.Application_49, (Object)subcommands), NLS.bind((String)Messages.Application_CONCATENATE, (Object)Messages.Application_50, (Object)NLS.bind((String)Messages.Application_2, (Object)ctx.getAppName(), (Object)subcommands)));
                }
                parents.add(defn);
                String childName = unconsumed.get(index);
                try {
                    defn = defn.getChild(childName);
                    ++index;
                }
                catch (IllegalArgumentException e) {
                    defn = parents.removeLast();
                    if (defn.isRunnable()) break;
                    throw this.complain(ctx, 1, Messages.Application_52, NLS.bind((String)Messages.Application_CONCATENATE, (Object)NLS.bind((String)Messages.Application_51, (Object)childName), (Object)NLS.bind((String)Messages.Application_2, (Object)ctx.getAppName(), (Object)SubcommandUtil.getExecutionString(defn))));
                }
            }
            int count = index;
            while (count > 0) {
                unconsumed.remove(0);
                --count;
            }
            if (args != null) {
                try {
                    subargs = this.parseSubCommandLine(defn, args.getUnconsumedArgs());
                }
                catch (ISubcommandDefinition.LoadOptionsException e) {
                    throw this.complain(ctx, 4, NLS.bind((String)Messages.Application_35, (Object)SubcommandUtil.getExecutionString(defn)), e.getCause().getLocalizedMessage());
                }
                catch (ArgumentOverflowException e) {
                    throw this.complain(ctx, defn, 1, Messages.Application_36, NLS.bind((String)Messages.Application_CONCATENATE, (Object)NLS.bind((String)Messages.Application_11, (Object)SubcommandUtil.getExecutionString(defn), (Object)e.getExtraArgument()), (Object)NLS.bind((String)Messages.Application_2, (Object)ctx.getAppName(), (Object)SubcommandUtil.getExecutionString(defn))));
                }
                catch (ArgumentUnderflowException e) {
                    throw this.complain(ctx, defn, 1, Messages.Application_36, NLS.bind((String)Messages.Application_CONCATENATE, (Object)NLS.bind((String)Messages.Application_12, (Object)SubcommandUtil.getExecutionString(defn), (Object)StringUtil.listToString(e.getMissingArguments())), (Object)NLS.bind((String)Messages.Application_2, (Object)ctx.getAppName(), (Object)SubcommandUtil.getExecutionString(defn))));
                }
                catch (UnknownOptionException e) {
                    StringBuffer parentCommandName = new StringBuffer();
                    boolean applicableToParent = this.optionApplicableToParentCommand(e.getOption(), ctx, parentCommandName);
                    String message1 = NLS.bind((String)Messages.Application_13, (Object)SubcommandUtil.getExecutionString(defn), (Object)e.getOption());
                    String message2 = NLS.bind((String)Messages.Application_2, (Object)ctx.getAppName(), (Object)SubcommandUtil.getExecutionString(defn));
                    String message3 = NLS.bind((String)Messages.Application_60, (Object)e.getOption(), (Object)parentCommandName);
                    throw this.complain(ctx, defn, 1, Messages.Application_36, applicableToParent ? String.valueOf(message1) + Messages.HelpCmd_24 + message3 + Messages.HelpCmd_24 + message2 : NLS.bind((String)Messages.Application_CONCATENATE, (Object)message1, (Object)message2));
                }
                catch (MalformedOptException e) {
                    String message = NLS.bind((String)Messages.Application_CONCATENATE, (Object)NLS.bind((String)Messages.Application_14, (Object)e.getOption()), (Object)e.getProblem());
                    throw this.complain(ctx, defn, 1, Messages.Application_36, NLS.bind((String)Messages.Application_CONCATENATE, (Object)message, (Object)NLS.bind((String)Messages.Application_2, (Object)ctx.getAppName(), (Object)SubcommandUtil.getExecutionString(defn))));
                }
                catch (MalformedCommandLineException e) {
                    throw this.complain(ctx, defn, 1, Messages.Application_36, NLS.bind((String)Messages.Application_CONCATENATE, (Object)e.getLocalizedMessage(), (Object)NLS.bind((String)Messages.Application_2, (Object)ctx.getAppName(), (Object)SubcommandUtil.getExecutionString(defn))));
                }
                catch (ConflictingOptionException e) {
                    e.printStackTrace(ctx.stderr());
                    throw this.complain(ctx, 7, NLS.bind((String)Messages.Application_41, (Object)SubcommandUtil.getExecutionString(defn)), e.getLocalizedMessage());
                }
            }
        }
        this.run(ctx, legacyContext, defn, parents, args, subargs);
        if (commandName == CommandName.MISSING) {
            throw this.complain(ctx, 1, Messages.Application_32, NLS.bind((String)Messages.Application_7, (Object)OPT_VERSION.getName(), (Object)OPT_HELP.getName()));
        }
        if (commandName == CommandName.UNKNOWN) {
            throw this.complain(ctx, 12, Messages.Application_33, NLS.bind((String)Messages.Application_8, (Object)cmdName));
        }
    }

    private InternalErrorException complain(IExecutionContext ctx, ISubcommandDefinition defn, int errorCode, String errorTitle, String errorDescription) {
        this.returnValue = errorCode;
        String formattedHelp = null;
        try {
            if (defn != null && defn.getOptions().getSupportsNewHelp()) {
                formattedHelp = SubcommandUtil.getFormattedShortUsageHelp(ctx, defn);
            }
        }
        catch (ISubcommandDefinition.LoadOptionsException e) {
            e.printStackTrace(ctx.stderr());
        }
        catch (ConflictingOptionException e) {
            e.printStackTrace(ctx.stderr());
        }
        if (errorDescription != null) {
            if (formattedHelp != null) {
                errorDescription = NLS.bind((String)Messages.Application_JOIN, (Object)errorDescription, (Object)formattedHelp);
            }
            if (ctx.isLocal()) {
                ctx.setTerminatingError("", "");
                ctx.stderr().println(NLS.bind((String)Messages.ERROR_TITLE1, (Object)errorTitle));
                ctx.stderr().println(errorDescription);
            } else {
                ctx.setTerminatingError(errorTitle, errorDescription);
            }
        }
        return new InternalErrorException();
    }

    private InternalErrorException complain(IExecutionContext env, int errorCode, String errorTitle, String errorDescription) {
        return this.complain(env, null, errorCode, errorTitle, errorDescription);
    }

    private boolean optionApplicableToParentCommand(String optString, IExecutionContext ctx, StringBuffer parentCommandName) {
        boolean applicableToParentCommand = false;
        String PREFIX_LONGOPT = "--";
        String PREFIX_SHORTOPT = "-";
        String optName = "";
        optName = optString.startsWith(PREFIX_LONGOPT) && optString.length() > PREFIX_LONGOPT.length() ? optString.substring(PREFIX_LONGOPT.length()) : (optString.startsWith(PREFIX_SHORTOPT) && optString.length() > PREFIX_SHORTOPT.length() ? optString.substring(PREFIX_SHORTOPT.length()) : optString);
        try {
            Options appOptions = this.getAppOptions();
            for (INamedOptionDefinition namedOption : appOptions.getNamedOptions()) {
                if (!optName.equals(namedOption.getShortOpt()) && !optName.equals(namedOption.getLongOpt())) continue;
                parentCommandName.append(ctx.getAppName());
                applicableToParentCommand = true;
                break;
            }
        }
        catch (ConflictingOptionException conflictingOptionException) {
            // empty catch block
        }
        return applicableToParentCommand;
    }

    private InternalErrorException returnValue(IExecutionContext env, int errorCode) {
        this.returnValue = errorCode;
        env.setTerminatingError("", "");
        return new InternalErrorException();
    }

    public void stop() {
    }

    private ICommandLine parseCommandLine(IExecutionContext context) throws MalformedCommandLineException, ConflictingOptionException, IOException, CLIClientException {
        Options appOptions = this.getAppOptions();
        String[] args = context.arguments();
        Map<String, String> env = context.environment();
        String forceGlob = env.get("JAZZSCM_FORCE_GLOBBING");
        boolean forceGlobFlag = "1".equals(forceGlob);
        if (System.getProperty("os.name").toLowerCase().contains("windows") || forceGlobFlag) {
            String globIgnore = env.get("GLOBIGNORE");
            String[] ignoreStrs = null;
            if (globIgnore != null) {
                ignoreStrs = globIgnore.split(";");
            }
            List<String> argList = CLIParser.expandWildCardArgs(args, ignoreStrs, context);
            args = argList.toArray(new String[argList.size()]);
        }
        CLIParser parser = new CLIParser(appOptions, args);
        return parser.parse();
    }

    private ICommandLine parseSubCommandLine(ISubcommandDefinition defn, List<String> subargs) throws MalformedCommandLineException, ISubcommandDefinition.LoadOptionsException, ConflictingOptionException, CLIClientException {
        Options options = defn.getOptions();
        return new CLIParser(options, subargs).parse();
    }

    private void run(IExecutionContext ctx, IApplicationContext legacyContext, ISubcommandDefinition defn, LinkedList<ISubcommandDefinition> parents, ICommandLine args, ICommandLine subargs) throws InternalErrorException, CLIClientException {
        IClientConfiguration config;
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.rtc.cli.infrastructure", "clientconfiguration");
        if (configs.length == 0) {
            config = new ClientConfiguration();
        } else if (configs.length == 1) {
            try {
                config = (IClientConfiguration)configs[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                throw this.complain(ctx, 4, "Client Configuration", "Cannot load client configuration");
            }
        } else {
            throw this.complain(ctx, 4, "Client Configuration", "Found more than one client configuration");
        }
        try {
            try {
                ISubcommand subcmd;
                config.initialize(this.loader, ctx, legacyContext, defn, parents, args, subargs);
                try {
                    subcmd = defn.loadSubcommand();
                }
                catch (ISubcommandDefinition.LoadSubcommandException e) {
                    throw this.complain(ctx, 4, NLS.bind((String)Messages.Application_43, (Object)SubcommandUtil.getExecutionString(defn)), e.getLocalizedMessage());
                }
                if (IClientConfiguration.DEBUG_TIMING) {
                    SubcommandUtil.printDebugTiming(ctx, NLS.bind((String)Messages.Application_16, (Object)ctx.getAppName()), ctx.stderr());
                }
                this.returnValue = subcmd.run(config);
                if (IClientConfiguration.DEBUG_TIMING) {
                    SubcommandUtil.printDebugTiming(ctx, NLS.bind((String)Messages.Application_17, (Object)ctx.getAppName()), ctx.stderr());
                }
            }
            catch (CLIClientException e) {
                IStatus status = e.getStatus();
                if (status == null) {
                    throw e;
                }
                if (Constants.showStackTraceFor(status.getCode())) {
                    StatusHelper.showStatusException(status, config.getContext().stderr());
                }
                if (status.getSeverity() == 1) {
                    throw this.returnValue(ctx, status.getCode());
                }
                throw this.complain(ctx, status.getCode(), NLS.bind((String)Messages.Application_44, (Object)SubcommandUtil.getExecutionString(defn)), status.getMessage());
            }
        }
        finally {
            config.deInitialize();
        }
    }

    private Options getAppOptions() throws ConflictingOptionException {
        Options opt = new Options(true);
        opt.addOption(OPT_SUBCOMMAND_NAME, Messages.Application_21);
        opt.addOption(OPT_HELP, Messages.Application_22);
        OPT_SYMBOLIC_HELP.hideOption();
        opt.addOption(OPT_SYMBOLIC_HELP, Messages.Application_22);
        opt.addOption(OPT_DISALLOW_INTERACTION, null, "non-interactive", Messages.Application_19, 0);
        opt.addOption(OPT_CONFIG_LOCATION, null, "config", Messages.Application_20, 1);
        opt.addOption(OPT_NO_MASK, null, "no-mask", Messages.Application_NO_MASK_HELP, 0);
        Object[] yesNoList = new Object[]{ALWAYS_VALUES[0], ALWAYS_VALUES[1], NEVER_VALUES[0], NEVER_VALUES[1]};
        opt.addOption(OPT_SHOW_UUID, "u", "show-uuid", NLS.bind((String)Messages.Application_55, (Object[])yesNoList), 1);
        opt.addOption(OPT_SHOW_ALIAS, "a", "show-alias", NLS.bind((String)Messages.Application_56, (Object[])yesNoList), 1);
        opt.addOption(OPT_VERSION, Messages.CommonOptions_11);
        return opt;
    }

    static enum CommandName {
        MISSING,
        UNKNOWN,
        VALID;

    }

    private static class InternalErrorException
    extends Exception {
        private static final long serialVersionUID = 7057110785038430374L;

        private InternalErrorException() {
        }
    }
}

