/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.core;

import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommand;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.core.SubcommandLoader;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.SubcommandUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

class SubcommandDefinition
implements ISubcommandDefinition {
    IConfigurationElement ext;
    private final SubcommandLoader loader;
    private String name = null;
    private String shortHelp = null;
    private PrintStream printStream;
    private static volatile Pattern SCOPE_SPLITTER = null;

    public SubcommandDefinition(SubcommandLoader loader, IConfigurationElement config, PrintStream printStream) {
        this.loader = loader;
        this.ext = config;
        this.printStream = printStream;
    }

    @Override
    public IConfigurationElement getConfigurationElement() {
        return this.ext;
    }

    @Override
    public String getAttr(String attrName) {
        return this.getAttr(attrName, false);
    }

    private String getAttr(String attrName, boolean required) {
        String attr = this.ext.getAttribute(attrName);
        if (required && attr == null) {
            this.printStream.println(NLS.bind((String)Messages.SubcommandDefinition_0, (Object)attrName));
        }
        return attr;
    }

    @Override
    public String getFullSubcommandName() {
        if (this.name == null) {
            this.name = this.getAttr("name", true);
        }
        return this.name;
    }

    @Override
    public String getShortHelp() {
        if (this.shortHelp == null) {
            this.shortHelp = this.getAttr("shortHelp", true);
        }
        return this.shortHelp;
    }

    public String getLongHelp() {
        return this.ext.getAttribute("longHelp");
    }

    public String getOptionsClass() {
        return this.ext.getAttribute("options");
    }

    @Override
    public Options getOptions() throws ISubcommandDefinition.LoadOptionsException, ConflictingOptionException {
        Options opts = null;
        boolean mustSet = true;
        if (this.getOptionsClass() == null) {
            opts = new Options(false);
        } else {
            IOptionSource src;
            try {
                src = (IOptionSource)this.ext.createExecutableExtension("options");
            }
            catch (CoreException e) {
                throw new ISubcommandDefinition.LoadOptionsException(this.name, e);
            }
            opts = src.getOptions();
            mustSet = false;
        }
        String longHelp = this.getLongHelp();
        assert (!mustSet || longHelp != null) : "Extension point for subcommand \"" + this.getId() + "\" does not set options class or long help.";
        if (longHelp != null) {
            opts.setLongHelp(longHelp);
        }
        return opts;
    }

    @Override
    public ISubcommand loadSubcommand() throws ISubcommandDefinition.LoadSubcommandException {
        block3: {
            try {
                if (this.getSubcommandName() != null) break block3;
                return null;
            }
            catch (CoreException e) {
                throw new ISubcommandDefinition.LoadSubcommandException(this.name, e);
            }
        }
        return (ISubcommand)this.ext.createExecutableExtension("class");
    }

    public String getSubcommandName() {
        return this.ext.getAttribute("class");
    }

    @Override
    public String[] getAliases() {
        String aliasString = this.getAttr("aliases", false);
        if (aliasString == null) {
            return new String[0];
        }
        return aliasString.split("\\s+");
    }

    @Override
    public String getModuleName() {
        return this.ext.getContributor().getName();
    }

    @Override
    public String getId() {
        return this.getAttr("id", false);
    }

    @Override
    public String getParentId() {
        return this.getAttr("parent", false);
    }

    @Override
    public ISubcommandDefinition getParent() {
        String parentId = this.getParentId();
        if (parentId == null) {
            return null;
        }
        Collection<ISubcommandDefinition> all = this.loader.getAllDefinitions();
        if (parentId != null) {
            for (ISubcommandDefinition defn : all) {
                if (!parentId.equals(defn.getId())) continue;
                return defn;
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.SubcommandDefinition_11, (Object)parentId));
    }

    @Override
    public List<ISubcommandDefinition> getAncestors() {
        LinkedList<ISubcommandDefinition> ancestors = new LinkedList<ISubcommandDefinition>();
        ISubcommandDefinition parent = this.getParent();
        while (parent != null) {
            ancestors.addFirst(parent);
            parent = parent.getParent();
        }
        return ancestors;
    }

    @Override
    public boolean isParent() {
        Collection<ISubcommandDefinition> children = this.loader.getChildSubcommands(this);
        return children.size() > 0;
    }

    @Override
    public boolean isRunnable() {
        return this.ext.getAttribute("class") != null;
    }

    @Override
    public ISubcommandDefinition getChild(String childName) {
        Collection<ISubcommandDefinition> children = this.loader.getChildSubcommands(this);
        for (ISubcommandDefinition child : children) {
            if (!childName.equals(child.getFullSubcommandName())) continue;
            return child;
        }
        for (ISubcommandDefinition child : children) {
            String[] stringArray = child.getAliases();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (childName.equals(alias)) {
                    return child;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.SubcommandDefinition_12, (Object)childName));
    }

    @Override
    public Collection<ISubcommandDefinition> getChildren() {
        return this.loader.getChildSubcommands(this);
    }

    @Override
    public boolean showInHelpListing(IClientConfiguration config) {
        return this.ext.getAttribute("hideFromHelp") == null || SubcommandUtil.isEnvironmentVarSet("JAZZSCM_SHOW_HIDDEN_COMMANDS", new String[]{"true"}, config);
    }

    public static boolean inGroup(IConfigurationElement config, String requestedGroup) {
        Collection<String> scopes = SubcommandDefinition.getScopes(config);
        return scopes.contains(requestedGroup);
    }

    public static Collection<String> getScopes(IConfigurationElement config) {
        String actual = config.getAttribute("scope");
        if (actual == null || actual.trim().length() == 0) {
            return Collections.singleton("default");
        }
        Pattern splitter = SCOPE_SPLITTER;
        if (SCOPE_SPLITTER == null) {
            splitter = SCOPE_SPLITTER = Pattern.compile("\\s+");
        }
        ArrayList<String> scopes = new ArrayList<String>(5);
        String[] stringArray = splitter.split(actual);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            scopes.add(group);
            ++n2;
        }
        return scopes;
    }

    @Override
    public SubcommandLoader getLoader() {
        return this.loader;
    }

    public int getOverrideValue() {
        int overrideValue = 1;
        String override = this.getAttr("override", false);
        if (override != null) {
            try {
                overrideValue = Integer.parseInt(override);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return overrideValue;
    }

    @Override
    public boolean isDeprecated() {
        return this.ext.getAttribute("deprecated") != null;
    }
}

