/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.core;

import com.ibm.team.rtc.cli.infrastructure.internal.core.AbstractExecutionContext;
import com.ibm.team.rtc.cli.infrastructure.internal.util.PromptUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;

public class LocalContext
extends AbstractExecutionContext {
    private final String appName;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final InputStream stdin;
    private final String[] arguments;
    private final Map<String, String> env;
    private final String cwd;
    private final boolean local;

    public LocalContext(String appName, PrintStream stdout, PrintStream stderr, InputStream stdin, String[] arguments, Map<String, String> env, String cwd) {
        this(System.currentTimeMillis(), appName, stdout, stderr, stdin, arguments, env, cwd);
    }

    public LocalContext(long start, String appName, PrintStream stdout, PrintStream stderr, InputStream stdin, String[] arguments, Map<String, String> env, String cwd) {
        super(start);
        this.appName = appName;
        this.stdout = stdout;
        this.stderr = stderr;
        this.stdin = stdin;
        this.arguments = arguments;
        this.env = env;
        this.cwd = cwd;
        this.local = true;
    }

    @Override
    public PrintStream stderr() {
        return this.stderr;
    }

    @Override
    public PrintStream stdout() {
        return this.stdout;
    }

    @Override
    public InputStream stdin() {
        return this.stdin;
    }

    @Override
    public String[] arguments() {
        return this.arguments;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public void setTerminatingError(String title, String message) {
        if (!title.isEmpty() || !message.isEmpty()) {
            System.getProperties().setProperty("eclipse.exitdata", "<title>" + title + "</title>" + message);
        } else {
            System.setProperty("eclipse.exitdata", "");
        }
    }

    @Override
    public Map<String, String> environment() {
        return this.env;
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return this.cwd;
    }

    @Override
    public String readInput(String prompt, boolean mask) throws IOException {
        return PromptUtil.prompt(prompt, mask, this.stdin, this.stdout);
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Object getRemoteObject() {
        return null;
    }
}

