/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.cli.infrastructure.internal.core;

import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IApplicationEndListener;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IExecutionContext;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.core.SubcommandLauncher;
import com.ibm.team.rtc.cli.infrastructure.internal.core.SubcommandLoader;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.equinox.app.IApplicationContext;

public class ClientConfiguration
implements IClientConfiguration {
    protected SubcommandLoader loader;
    protected IExecutionContext environment;
    @Deprecated
    protected IApplicationContext context;
    protected ICommandLine args;
    protected List<ISubcommandDefinition> parents;
    protected ICommandLine subargs;
    protected File cwd;
    protected List<IApplicationEndListener> endListeners;
    protected ISubcommandDefinition defn;

    @Override
    public void initialize(SubcommandLoader loader, IExecutionContext environment, IApplicationContext context, ISubcommandDefinition defn, List<ISubcommandDefinition> parents, ICommandLine args, ICommandLine subargs) throws CLIClientException {
        this.loader = loader;
        this.environment = environment;
        this.cwd = new File(environment.getCurrentWorkingDirectory());
        this.context = context;
        this.defn = defn;
        this.args = args;
        this.subargs = subargs;
        this.parents = parents;
        this.endListeners = new LinkedList<IApplicationEndListener>();
    }

    @Override
    public File getCurrentWorkingDirectory() {
        return this.cwd;
    }

    @Override
    public SubcommandLoader getSubcommandLoader() {
        return this.loader;
    }

    @Override
    public Collection<ISubcommandDefinition> getSubcommandDefinitions() {
        return this.loader.getAllDefinitions();
    }

    @Override
    public ISubcommandDefinition getSubcommandDefinition() {
        return this.defn;
    }

    @Override
    public IApplicationContext getApplicationContext() {
        return this.context;
    }

    @Override
    public ICommandLine getSubcommandCommandLine() {
        return this.subargs;
    }

    @Override
    public ICommandLine getCommandLine() {
        return this.args;
    }

    @Override
    public List<ISubcommandDefinition> getParents() {
        return this.parents;
    }

    @Override
    public boolean mayInteract() {
        return false;
    }

    @Override
    public void addApplicationEndListener(IApplicationEndListener listener) {
        this.endListeners.add(listener);
    }

    @Override
    public void deInitialize() {
        for (IApplicationEndListener listener : this.endListeners) {
            listener.run(this);
        }
    }

    public IClientConfiguration getClientConfiguration() {
        return this;
    }

    @Override
    public IExecutionContext getContext() {
        return this.environment;
    }

    @Override
    public boolean isDryRun() {
        return this.args == null || this.args.hasOption(SubcommandLauncher.OPT_DRY_RUN);
    }
}

