/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class RepositorySelectionPart {
    private TableViewer table;
    private Button useExistingRepo;
    private Button useNewRepo;
    private ITeamRepository result;
    private final IRepositorySelectionListener selectionListener;
    private final IRepositorySelectionListener doubleClickListener;

    public RepositorySelectionPart(Composite parent, IRepositorySelectionListener selectionListener, IRepositorySelectionListener doubleClickListener) {
        this.selectionListener = selectionListener;
        this.doubleClickListener = doubleClickListener;
        this.createControl(parent);
    }

    protected TableViewer createTable(Composite parent, int span) {
        Table table = new Table(parent, 68356);
        return new TableViewer(table);
    }

    public Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.useNewRepo = new Button(composite, 16);
        this.useNewRepo.setText(Messages.RepositorySelectionPart_0);
        this.useExistingRepo = new Button(composite, 16);
        this.useExistingRepo.setText(Messages.RepositorySelectionPart_1);
        this.table = this.createTable(composite, 1);
        GridDataFactory.defaultsFor((Control)this.table.getControl()).hint(200, 200).applyTo(this.table.getControl());
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RepositorySelectionPart.this.notifyDoubleClicked();
            }
        });
        this.initializeValues();
        Dialog.applyDialogFont((Control)parent);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositorySelectionPart.this.notifyRepoSelected();
            }
        });
        this.useExistingRepo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (RepositorySelectionPart.this.useNewRepo.getSelection()) {
                    RepositorySelectionPart.this.table.getTable().setEnabled(false);
                } else {
                    RepositorySelectionPart.this.table.getTable().setEnabled(true);
                }
                RepositorySelectionPart.this.notifyRepoSelected();
            }
        });
        this.table.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.RepositorySelectionPart_2;
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return composite;
    }

    private void initializeValues() {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        this.table.setInput((Object)repos);
        if (repos.length == 0) {
            this.useNewRepo.setSelection(true);
            this.useExistingRepo.setSelection(false);
            this.useExistingRepo.setEnabled(false);
            this.table.getTable().setEnabled(false);
            this.result = null;
        } else {
            this.useNewRepo.setSelection(false);
            this.useExistingRepo.setSelection(true);
            this.table.getTable().setEnabled(true);
            this.result = repos[0];
            this.table.setSelection((ISelection)new StructuredSelection((Object)this.result));
        }
    }

    private void notifyRepoSelected() {
        ITeamRepository repo = null;
        if (this.useExistingRepo.getSelection()) {
            repo = (ITeamRepository)((IStructuredSelection)this.table.getSelection()).getFirstElement();
        }
        this.result = repo;
        this.selectionListener.repositorySelected(repo);
    }

    private void notifyDoubleClicked() {
        this.notifyRepoSelected();
        if (this.useExistingRepo.getSelection() && this.result != null && this.doubleClickListener != null) {
            this.doubleClickListener.repositorySelected(this.result);
        }
    }

    public ITeamRepository getTeamRepository() {
        return this.result;
    }

    public void dispose() {
    }

    public static interface IRepositorySelectionListener {
        public void repositorySelected(ITeamRepository var1);
    }
}

