/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.RepositorySelectionPart;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RepositorySelectionPage
extends WizardPage {
    private RepositorySelectionPart fPart;

    public RepositorySelectionPage(String title, String description) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
    }

    public RepositorySelectionPage(String description) {
        this(Messages.RepositorySelectionPage_0, description);
    }

    public void createControl(Composite parent) {
        RepositorySelectionPart.IRepositorySelectionListener selectionListener = new RepositorySelectionPart.IRepositorySelectionListener(){
            private ITeamRepository fLastRepo;

            @Override
            public void repositorySelected(ITeamRepository repo) {
                if (this.fLastRepo == null || repo != this.fLastRepo) {
                    RepositorySelectionPage.this.setPageComplete(repo != null);
                }
                this.fLastRepo = repo;
            }
        };
        Composite wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        wrapper.setLayout((Layout)layout);
        this.fPart = new RepositorySelectionPart(wrapper, selectionListener, this.createDoubleClickListener());
        this.setControl((Control)wrapper);
    }

    public RepositorySelectionPart.IRepositorySelectionListener createDoubleClickListener() {
        return new RepositorySelectionPart.IRepositorySelectionListener(){

            @Override
            public void repositorySelected(ITeamRepository repo) {
                RepositorySelectionPage.this.getContainer().showPage(RepositorySelectionPage.this.getNextPage());
            }
        };
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public ITeamRepository getTeamRepository() {
        return this.fPart.getTeamRepository();
    }

    public void dispose() {
        if (this.fPart != null) {
            this.fPart.dispose();
            this.fPart = null;
        }
        super.dispose();
    }
}

