/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.HistoryCombo;
import com.ibm.team.process.internal.rcp.ui.IntegratedWindowsLoginInfoUIProvider;
import com.ibm.team.process.internal.rcp.ui.LoginInfoUIProviderElementDescriptor;
import com.ibm.team.process.internal.rcp.ui.LoginInfoUIProviderExtensionReader;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.rcp.ui.ILoginInfoUIProvider;
import com.ibm.team.process.rcp.ui.IStatusHandler;
import com.ibm.team.process.rcp.ui.IUIValidationCallback;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.login.AbstractLoginInfo;
import com.ibm.team.repository.client.login.KerberosLoginInfo;
import com.ibm.team.repository.transport.client.TeamServerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class RepositoryCreationPart
implements IUIValidationCallback {
    private HistoryCombo uriCombo;
    private HistoryCombo nameCombo;
    private Button rememberPassword;
    private Button autoLogin;
    private Combo authenticationType;
    private boolean nameOverriden = false;
    private boolean nameHasFocus = false;
    private boolean initialized = false;
    private String partName = "";
    private Text timeoutText;
    private Map<Object, List> requiredFields = new HashMap<Object, List>();
    private Object generalFieldsKey = new Object();
    private final IStatusHandler fSite;
    private Map<LoginInfoUIProviderElementDescriptor, LoginProperties> authenticationPropertyControlMap = new HashMap<LoginInfoUIProviderElementDescriptor, LoginProperties>();
    private static final int ALREADY_EXISTS = 9999;
    private static final int NO_SPACES = 9998;
    private Preferences dialogPrefs;
    private RepositoryInfo fRepositoryInformation;
    private ControlDecoration fURIDecoration;

    public RepositoryCreationPart(IStatusHandler site, RepositoryInfo repositoryInformation) {
        this.fSite = site;
        this.fRepositoryInformation = repositoryInformation;
        this.dialogPrefs = this.getConfigPrefs().node("dialog");
        Composite parent = site.getComposite();
        Group uriComposite = new Group(parent, 0);
        uriComposite.setText(Messages.RepositoryCreationPart_2);
        final Label uriLabel = new Label((Composite)uriComposite, 0);
        uriLabel.setText(Messages.RepositoryCreationPart_3);
        this.uriCombo = new HistoryCombo((Composite)uriComposite, this.dialogPrefs.node("uri"), false);
        if (this.uriCombo.getHistory().length == 0) {
            this.uriCombo.addToHistory("https://localhost:9443/jazz", true);
            this.uriCombo.addToHistory("https://localhost:9443/ccm", true);
        }
        this.uriCombo.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)Messages.RepositoryCreationPart_1, (Object)uriLabel.getText());
            }
        });
        Label nameLabel = new Label((Composite)uriComposite, 0);
        nameLabel.setText(Messages.RepositoryCreationPart_7);
        this.nameCombo = new HistoryCombo((Composite)uriComposite, this.dialogPrefs.node("name"), true);
        this.nameCombo.getCombo().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                RepositoryCreationPart.this.nameHasFocus = false;
            }

            public void focusGained(FocusEvent e) {
                if (RepositoryCreationPart.this.nameCombo.getCombo().getText().equals("") && !RepositoryCreationPart.this.nameOverriden) {
                    RepositoryCreationPart.this.setSuggestedName();
                }
                RepositoryCreationPart.this.nameHasFocus = true;
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)uriComposite);
        Group authenticationComposite = new Group(parent, 0);
        authenticationComposite.setText(Messages.RepositoryCreationPart_10);
        new Label((Composite)authenticationComposite, 0).setText(Messages.RepositoryCreationPart_0);
        this.authenticationType = new Combo((Composite)authenticationComposite, 12);
        this.populateAuthenticationTypeSelection(this.authenticationType);
        final Composite authProperties = new Composite((Composite)authenticationComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)authProperties);
        final StackLayout stackLayout = new StackLayout();
        authProperties.setLayout((Layout)stackLayout);
        this.authenticationType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryCreationPart.this.switchAuthenticationProperties(RepositoryCreationPart.this.getCurrentLoginInfoProviderDescriptor(), authProperties, stackLayout);
                RepositoryCreationPart.this.updateRepositoryInformation();
            }
        });
        this.createAuthenticationProperties(authProperties);
        LoginInfoUIProviderElementDescriptor descriptor = this.getCurrentLoginInfoUIProviderElementDescriptor();
        this.selectAuthenticationProperties(authProperties, stackLayout, descriptor);
        this.populateSelectedAuthenticationProperties(descriptor);
        this.autoLogin = new Button((Composite)authenticationComposite, 32);
        this.autoLogin.setText(Messages.RepositoryCreationPart_15);
        this.autoLogin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((RepositoryCreationPart)RepositoryCreationPart.this).fRepositoryInformation.fAutoLogin = !((RepositoryCreationPart)RepositoryCreationPart.this).fRepositoryInformation.fAutoLogin;
            }
        });
        GridDataFactory.generate((Control)this.autoLogin, (int)2, (int)1);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)authenticationComposite);
        Group detailsSectionComposite = new Group(parent, 0);
        detailsSectionComposite.setText(Messages.RepositoryCreationPart_16);
        Label connectionTimeout = new Label((Composite)detailsSectionComposite, 0);
        connectionTimeout.setText(Messages.RepositoryCreationPart_17);
        this.timeoutText = new Text((Composite)detailsSectionComposite, 2052);
        this.timeoutText.setText("");
        this.timeoutText.setTextLimit(4);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)detailsSectionComposite);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.addDecorations();
        List updated = this.updateWidgets();
        ModifyListener modifyListener = new ModifyListener(updated){
            private List fModifiedByUser;
            {
                this.fModifiedByUser = list;
            }

            public void modifyText(ModifyEvent e) {
                if (e.widget == RepositoryCreationPart.this.uriCombo.getCombo() && !this.fModifiedByUser.contains(e.widget)) {
                    this.fModifiedByUser.add(e.widget);
                }
                if (e.widget == RepositoryCreationPart.this.nameCombo.getCombo()) {
                    RepositoryCreationPart.this.nameOverriden = RepositoryCreationPart.this.nameHasFocus;
                } else if (e.widget == RepositoryCreationPart.this.uriCombo.getCombo() && !RepositoryCreationPart.this.nameOverriden) {
                    RepositoryCreationPart.this.setSuggestedName();
                }
                if (this.fModifiedByUser.size() == 1) {
                    RepositoryCreationPart.this.updateRepositoryInformation();
                }
            }
        };
        this.nameCombo.getCombo().addModifyListener(modifyListener);
        this.timeoutText.addModifyListener(modifyListener);
        this.uriCombo.getCombo().addModifyListener(modifyListener);
        Dialog.applyDialogFont((Control)parent);
        ArrayList<HistoryCombo> generalFields = new ArrayList<HistoryCombo>();
        generalFields.add(this.uriCombo);
        this.requiredFields.put(this.generalFieldsKey, generalFields);
        this.initialized = true;
        this.fSite.setStatus(null);
        this.uriCombo.getControl().setFocus();
    }

    private void populateSelectedAuthenticationProperties(LoginInfoUIProviderElementDescriptor descriptor) {
        LoginProperties loginProperties = this.authenticationPropertyControlMap.get((Object)descriptor);
        if (this.fRepositoryInformation.fTeamRepository == null) {
            if (loginProperties != null) {
                loginProperties.fProvider.clear();
            }
            return;
        }
        ILoginInfo2 loginInfo = this.fRepositoryInformation.fTeamRepository.getLoginInfo();
        if (loginInfo == null) {
            return;
        }
        if (!AbstractLoginInfo.isKerberosPossible() && loginInfo instanceof KerberosLoginInfo) {
            return;
        }
        this.fRepositoryInformation.fProvider = loginProperties.fProvider;
        try {
            this.fRepositoryInformation.fProvider.populate(loginInfo, this.fRepositoryInformation.fSavePassword);
        }
        catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
            // empty catch block
        }
    }

    private LoginInfoUIProviderElementDescriptor getCurrentLoginInfoUIProviderElementDescriptor() {
        if (this.fRepositoryInformation.fProvider == null) {
            return this.getDefaultLoginInfoUIProviderElementDescriptor();
        }
        String id = this.fRepositoryInformation.fProvider.getLoginInfo().getId();
        Set<LoginInfoUIProviderElementDescriptor> keys = this.authenticationPropertyControlMap.keySet();
        LoginInfoUIProviderElementDescriptor descriptor = null;
        Iterator<LoginInfoUIProviderElementDescriptor> iterator = keys.iterator();
        boolean match = false;
        while (!match && iterator.hasNext()) {
            descriptor = iterator.next();
            ILoginInfoUIProvider provider = descriptor.createImplementation();
            String loginInfoId = provider.getLoginInfo().getId();
            match = loginInfoId.equals(id);
        }
        return match ? descriptor : this.getDefaultLoginInfoUIProviderElementDescriptor();
    }

    private LoginInfoUIProviderElementDescriptor getDefaultLoginInfoUIProviderElementDescriptor() {
        return LoginInfoUIProviderExtensionReader.INSTANCE.getDefaultDescriptor();
    }

    private void selectAuthenticationProperties(Composite parent, StackLayout stackLayout, LoginInfoUIProviderElementDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        int index = 0;
        int i = 0;
        while (i < this.authenticationType.getItemCount()) {
            LoginInfoUIProviderElementDescriptor loginInfoUIProviderElementDescriptor = (LoginInfoUIProviderElementDescriptor)((Object)this.authenticationType.getData(String.valueOf(i)));
            if (descriptor == loginInfoUIProviderElementDescriptor) {
                index = i;
                break;
            }
            ++i;
        }
        this.authenticationType.select(index);
        this.switchAuthenticationProperties(descriptor, parent, stackLayout);
        this.updateRepositoryInformation();
    }

    private boolean isWindowsAuthPossible(LoginInfoUIProviderElementDescriptor descriptor) {
        if (descriptor.getProviderClassName().equals(IntegratedWindowsLoginInfoUIProvider.class.getName())) {
            return AbstractLoginInfo.isWindowsAuthPossible();
        }
        return true;
    }

    private boolean isKerberosButNotEnabled(LoginInfoUIProviderElementDescriptor descriptor) {
        if (descriptor.getName().equals("Kerberos/SPNEGO")) {
            return !AbstractLoginInfo.isKerberosPossible();
        }
        return false;
    }

    private void createAuthenticationProperties(Composite authProperties) {
        int i = 0;
        while (i < this.authenticationType.getItemCount()) {
            LoginInfoUIProviderElementDescriptor descriptor = (LoginInfoUIProviderElementDescriptor)((Object)this.authenticationType.getData(String.valueOf(i)));
            if (!this.isKerberosButNotEnabled(descriptor) && this.isWindowsAuthPossible(descriptor)) {
                LoginProperties properties = new LoginProperties();
                properties.fProvider = descriptor.createImplementation();
                properties.fControl = properties.fProvider.createContents(authProperties, this);
                if (properties.fProvider.getLoginInfo().hasPassword()) {
                    this.rememberPassword = new Button((Composite)properties.fControl, 32);
                    this.rememberPassword.setText(Messages.RepositoryCreationPart_14);
                    this.rememberPassword.setSelection(this.fRepositoryInformation.fSavePassword);
                    this.rememberPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ((RepositoryCreationPart)RepositoryCreationPart.this).fRepositoryInformation.fSavePassword = !((RepositoryCreationPart)RepositoryCreationPart.this).fRepositoryInformation.fSavePassword;
                        }
                    });
                }
                this.authenticationPropertyControlMap.put(descriptor, properties);
            }
            ++i;
        }
    }

    private void populateAuthenticationTypeSelection(Combo combo) {
        List descriptors = LoginInfoUIProviderExtensionReader.INSTANCE.getDescriptors();
        int index = 0;
        for (LoginInfoUIProviderElementDescriptor descriptor : descriptors) {
            if (this.isKerberosButNotEnabled(descriptor) || !this.isWindowsAuthPossible(descriptor)) continue;
            combo.add(descriptor.getName());
            combo.setData(String.valueOf(index), (Object)descriptor);
            ++index;
        }
    }

    private LoginInfoUIProviderElementDescriptor getCurrentLoginInfoProviderDescriptor() {
        if (this.authenticationType == null) {
            return null;
        }
        return (LoginInfoUIProviderElementDescriptor)((Object)this.authenticationType.getData(String.valueOf(this.authenticationType.getSelectionIndex())));
    }

    private ILoginInfoUIProvider getCurrentLoginInfoUIProvider() {
        if (this.fRepositoryInformation.fProvider == null) {
            LoginInfoUIProviderElementDescriptor descriptor = this.getCurrentLoginInfoProviderDescriptor();
            if (descriptor != null) {
                LoginProperties loginProperties = this.authenticationPropertyControlMap.get((Object)descriptor);
                return loginProperties.fProvider;
            }
        } else {
            return this.fRepositoryInformation.fProvider;
        }
        return null;
    }

    public void dispose() {
        this.uriCombo.addToHistory();
        this.nameCombo.addToHistory();
    }

    private Preferences getConfigPrefs() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.team.process.rcp.ui");
        Preferences edilogPrefs = prefs.node(this.getClass().getName());
        return edilogPrefs;
    }

    private void setSuggestedName() {
        try {
            URI uri = new URI(this.uriCombo.getCombo().getText().trim());
            String hostnamePart = uri.getHost();
            if (hostnamePart != null) {
                this.nameCombo.getCombo().setText(hostnamePart);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    protected void updateRepositoryInformation() {
        boolean oldBoolean;
        boolean newBoolean;
        int timeout;
        int newTimeOut;
        String oldText;
        String newText;
        if (!this.initialized) {
            return;
        }
        LoginInfoUIProviderElementDescriptor currentDescriptor = this.getCurrentLoginInfoProviderDescriptor();
        if (currentDescriptor != null) {
            LoginProperties loginProperties = this.authenticationPropertyControlMap.get((Object)currentDescriptor);
            ILoginInfoUIProvider oldLoginProvider = this.fRepositoryInformation.fProvider;
            if (oldLoginProvider != loginProperties.fProvider) {
                this.fRepositoryInformation.fProvider = loginProperties.fProvider;
                this.fRepositoryInformation.hasPassword = loginProperties.fProvider.getLoginInfo().hasPassword();
            }
        }
        if (!(newText = this.uriCombo.getCombo().getText().trim()).equals(oldText = this.fRepositoryInformation.fURI)) {
            this.fRepositoryInformation.fURI = newText;
        }
        if (!(newText = this.nameCombo.getCombo().getText()).equals(oldText = this.fRepositoryInformation.fName)) {
            this.fRepositoryInformation.fName = newText;
        }
        if ((newTimeOut = this.parseTimeout(this.timeoutText.getText())) != (timeout = this.fRepositoryInformation.fTimeout)) {
            this.fRepositoryInformation.fTimeout = newTimeOut;
        }
        if ((newBoolean = this.autoLogin.getSelection()) != (oldBoolean = this.fRepositoryInformation.fAutoLogin)) {
            this.fRepositoryInformation.fAutoLogin = newBoolean;
        }
        if ((newBoolean = this.fRepositoryInformation.hasPassword ? this.rememberPassword.getSelection() : true) != (oldBoolean = this.fRepositoryInformation.fSavePassword)) {
            this.fRepositoryInformation.fSavePassword = newBoolean;
        }
        this.updateErrorState();
    }

    private List updateWidgets() {
        boolean newBoolean;
        boolean oldBoolean;
        String newText;
        ArrayList<Combo> requiredUpdated = new ArrayList<Combo>(2);
        String oldText = this.uriCombo.getCombo().getText();
        if (!oldText.equals(newText = this.fRepositoryInformation.fURI)) {
            this.uriCombo.getCombo().setText(newText);
            requiredUpdated.add(this.uriCombo.getCombo());
        }
        if (!(oldText = this.nameCombo.getCombo().getText()).equals(newText = this.fRepositoryInformation.fName)) {
            this.nameCombo.getCombo().setText(newText);
        }
        try {
            URI uri = new URI(this.uriCombo.getCombo().getText().trim());
            String hostnamePart = uri.getHost();
            if (newText != null && newText.trim().length() > 0 && !newText.equals(hostnamePart)) {
                this.nameOverriden = true;
            }
        }
        catch (URISyntaxException hostnamePart) {
            // empty catch block
        }
        if (!newText.equals(this.partName)) {
            this.partName = newText;
        }
        oldText = this.timeoutText.getText();
        int timeout = this.fRepositoryInformation.fTimeout;
        if (timeout < 0) {
            timeout = 0;
        }
        if (timeout > 9999) {
            timeout = 9999;
        }
        if (!oldText.equals(newText = Integer.toString(timeout))) {
            this.timeoutText.setText(newText);
        }
        if ((oldBoolean = this.autoLogin.getSelection()) != (newBoolean = this.fRepositoryInformation.fAutoLogin)) {
            this.autoLogin.setSelection(newBoolean);
        }
        if (this.fRepositoryInformation.hasPassword && (oldBoolean = this.rememberPassword.getSelection()) != (newBoolean = this.fRepositoryInformation.fSavePassword)) {
            this.rememberPassword.setSelection(newBoolean);
        }
        try {
            this.getCurrentLoginInfoUIProvider().populate(this.getCurrentLoginInfoUIProvider().getLoginInfo(), this.fRepositoryInformation.fSavePassword);
        }
        catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
            // empty catch block
        }
        return requiredUpdated;
    }

    private boolean repositoryExists(String uri) {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            ITeamRepository repository = repos[i];
            if (repository != this.fRepositoryInformation.fTeamRepository) {
                String repoUri = repository.getRepositoryURI();
                if (repoUri.equalsIgnoreCase(uri)) {
                    return true;
                }
                if (uri.endsWith("/") && repoUri.equalsIgnoreCase(uri.substring(0, uri.length() - 1))) {
                    return true;
                }
                if (repoUri.equalsIgnoreCase(String.valueOf(uri) + '/')) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void updateErrorState() {
        IStatus status;
        if (!this.initialized) {
            return;
        }
        this.fURIDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        ArrayList fields = new ArrayList();
        List reqFields = this.requiredFields.get(this.generalFieldsKey);
        if (reqFields != null) {
            fields.addAll(reqFields);
        }
        for (Object field : fields) {
            int validationCode;
            if (field != this.uriCombo || (validationCode = this.validateURI()) == 0) continue;
            this.fSite.setStatus((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", this.getURIErrorMessage(validationCode)));
            this.fURIDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            return;
        }
        String timeout = this.timeoutText.getText();
        if (this.parseTimeout(timeout) == -1) {
            this.fSite.setStatus((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", Messages.RepositoryCreationPart_20));
            return;
        }
        ILoginInfoUIProvider provider = this.getCurrentLoginInfoUIProvider();
        if (provider != null && (status = provider.getValidationStatus()) != null && !status.isOK()) {
            this.fSite.setStatus(status);
            return;
        }
        this.fSite.setStatus(null);
    }

    private int parseTimeout(String timeout) {
        int t;
        block8: {
            block7: {
                if (timeout.length() == 0) {
                    return -1;
                }
                int i = 0;
                while (i < timeout.length()) {
                    char ch = timeout.charAt(i);
                    if ('0' > ch || ch > '9') {
                        return -1;
                    }
                    ++i;
                }
                try {
                    t = Integer.parseInt(timeout);
                    if (t >= 0) break block7;
                    return -1;
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            if (t <= 9999) break block8;
            return -1;
        }
        return t;
    }

    private int validateURI() {
        String uri = this.uriCombo.getCombo().getText().trim();
        int spaces = uri.indexOf(" ");
        int validationCode = spaces != -1 ? 9998 : (this.repositoryExists(uri) ? 9999 : TeamServerFactory.INSTANCE.validateURL(uri));
        return validationCode;
    }

    private String getURIErrorMessage(int validationCode) {
        switch (validationCode) {
            case 3: {
                return Messages.RepositoryCreationPart_22;
            }
            case 4: {
                return Messages.RepositoryCreationPart_23;
            }
            case 2: {
                return Messages.RepositoryCreationPart_24;
            }
            case 9999: {
                return Messages.RepositoryCreationPart_25;
            }
            case 9998: {
                return Messages.RepositoryCreationPart_26;
            }
        }
        return Messages.RepositoryCreationPart_27;
    }

    private void addDecorations() {
        this.fURIDecoration = new ControlDecoration(this.uriCombo.getControl(), 16512);
        this.fURIDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        this.fURIDecoration.show();
    }

    public void setDefaultFocus() {
        this.uriCombo.getControl().setFocus();
    }

    public void enableComposite(Composite comp, boolean enable) {
        Control[] children = comp.getChildren();
        if (children != null && children.length != 0) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite && !(child instanceof Combo)) {
                    this.enableComposite((Composite)child, enable);
                } else {
                    child.setEnabled(enable);
                }
                ++n2;
            }
        }
    }

    private void switchAuthenticationProperties(LoginInfoUIProviderElementDescriptor descriptor, Composite parent, StackLayout stackLayout) {
        LoginProperties properties = this.authenticationPropertyControlMap.get((Object)descriptor);
        if (properties.fControl != null) {
            stackLayout.topControl = properties.fControl;
            parent.layout();
        }
    }

    @Override
    public void validate() {
        this.updateErrorState();
    }

    protected class LoginProperties {
        protected ILoginInfoUIProvider fProvider;
        protected Control fControl;

        protected LoginProperties() {
        }
    }
}

