/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.foundation.rcp.core.PasswordUtil;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.rcp.ui.DisplayHelper;
import com.ibm.team.process.internal.rcp.ui.ErrorUtil;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.internal.rcp.ui.RepositoryLoginErrorDialog;
import com.ibm.team.process.rcp.ui.IStatusHandler;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.RepositoryCreationPart;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ServerStateCheckException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RepositoryCreationPage
extends WizardPage
implements IStatusHandler {
    private RepositoryCreationPart fPart;
    private RepositoryInfo fRepositoryInformation;
    private boolean fIsNextPageAvailable;
    private boolean fReusedExistingRepository;

    public RepositoryCreationPage(String title, String description) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
        this.fRepositoryInformation = new RepositoryInfo(null);
        this.fIsNextPageAvailable = true;
    }

    public RepositoryCreationPage(String description) {
        this(Messages.RepositoryCreationPage_0, description);
    }

    public boolean canFlipToNextPage() {
        if (!this.isNextPageAvailable()) {
            return false;
        }
        return this.fRepositoryInformation.isValid();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite);
        this.fPart = new RepositoryCreationPart(this, this.fRepositoryInformation);
    }

    public ITeamRepository createRepository() {
        return this.createRepository(true);
    }

    public ITeamRepository createRepository(final boolean login) {
        boolean success;
        boolean deleteOnLoginFailure = login;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (monitor != null) {
                            monitor.beginTask(NLS.bind((String)Messages.RepositoryCreationPage_3, (Object)((RepositoryCreationPage)RepositoryCreationPage.this).fRepositoryInformation.fName), -1);
                        }
                        RepositoryCreationPage.this.create();
                        ITeamRepository repo = ((RepositoryCreationPage)RepositoryCreationPage.this).fRepositoryInformation.fTeamRepository;
                        if (repo != null) {
                            if (repo.loggedIn()) {
                                repo.logout();
                            }
                            if (login) {
                                repo.login(monitor);
                            }
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ServerStateCheckException) {
                deleteOnLoginFailure = false;
            }
            this.reportCreationError(e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        deleteOnLoginFailure = !this.fReusedExistingRepository && deleteOnLoginFailure;
        boolean bl = success = this.fRepositoryInformation.fTeamRepository != null && (!login || this.fRepositoryInformation.fTeamRepository.loggedIn());
        if (!success) {
            if (this.fRepositoryInformation.fTeamRepository != null && deleteOnLoginFailure) {
                TeamPlatform.getTeamRepositoryService().removeTeamRepository(this.fRepositoryInformation.fTeamRepository);
            }
            this.fRepositoryInformation.fTeamRepository = null;
        }
        this.setPageComplete(this.fRepositoryInformation.fTeamRepository != null);
        return this.fRepositoryInformation.fTeamRepository;
    }

    private void reportCreationError(InvocationTargetException invocationException) {
        Throwable exception = invocationException.getTargetException();
        if (exception == null) {
            exception = invocationException;
        }
        if (exception instanceof TeamRepositoryException) {
            TeamRepositoryException repoException = (TeamRepositoryException)exception;
            RepositoryLoginErrorDialog.openError(this.getShell(), repoException);
        } else {
            String message = exception.getMessage();
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RepositoryCreationPage_1, null, (IStatus)new Status(4, "com.ibm.team.process.rcp.ui", message, exception));
        }
    }

    public ITeamRepository getTeamRepository() {
        return this.fRepositoryInformation.fTeamRepository;
    }

    public void dispose() {
        this.fPart.dispose();
    }

    public void create() {
        this.fReusedExistingRepository = false;
        List<ITeamRepository> repositories = Arrays.asList(TeamPlatform.getTeamRepositoryService().getTeamRepositories());
        try {
            this.fRepositoryInformation.fTeamRepository = this.createNewRepository(this.fRepositoryInformation.fURI);
        }
        catch (TeamRepositoryException e) {
            ErrorUtil.reportException(Messages.RepositoryCreationPage_2, e);
            return;
        }
        this.fReusedExistingRepository = repositories.contains(this.fRepositoryInformation.fTeamRepository);
        if (this.fReusedExistingRepository) {
            DisplayHelper.asyncExec((Control)this.getShell(), new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)RepositoryCreationPage.this.getShell(), (String)Messages.RepositoryCreationPage_4, (String)Messages.RepositoryCreationPage_5);
                }
            });
        }
        ILoginInfo2 loginInfo = this.fRepositoryInformation.fProvider.getLoginInfo();
        this.fRepositoryInformation.fTeamRepository.setLoginInfo(loginInfo);
        this.fRepositoryInformation.fTeamRepository.setAutoLogin(this.fRepositoryInformation.fAutoLogin);
        this.fRepositoryInformation.fTeamRepository.setSavePassword(this.fRepositoryInformation.fSavePassword);
        this.fRepositoryInformation.fTeamRepository.setName(this.fRepositoryInformation.fName);
        this.fRepositoryInformation.fTeamRepository.setUserId(this.fRepositoryInformation.fUserID);
        if (this.fRepositoryInformation.fTeamRepository.getSavePassword()) {
            PasswordUtil.savePassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository, (ILoginInfo2)loginInfo);
        } else {
            PasswordUtil.clearSavedPassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository, (ILoginInfo2)loginInfo);
        }
        this.fRepositoryInformation.fTeamRepository.setConnectionTimeout(this.fRepositoryInformation.fTimeout);
    }

    private ITeamRepository createNewRepository(String uri) throws TeamRepositoryException {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepositoryWithOverride(uri, null);
        TeamPlatform.getTeamRepositoryService().addTeamRepository(repo);
        return repo;
    }

    public RepositoryInfo getRepositoryInformation() {
        return this.fRepositoryInformation;
    }

    @Override
    public Composite getComposite() {
        return (Composite)this.getControl();
    }

    @Override
    public void setStatus(IStatus status) {
        String statusMessage = null;
        if (status != null && !status.isOK()) {
            statusMessage = status.getMessage();
        }
        if (statusMessage == null) {
            this.setMessage(null);
        } else if (status.getSeverity() == 2) {
            this.setMessage(statusMessage, 2);
            statusMessage = null;
        } else {
            this.setMessage(statusMessage, 3);
        }
        this.setPageComplete(statusMessage == null);
    }

    @Override
    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    public boolean isNextPageAvailable() {
        return this.fIsNextPageAvailable;
    }

    public void setNextPageAvailable(boolean isNextPageAvailable) {
        this.fIsNextPageAvailable = isNextPageAvailable;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fPart.setDefaultFocus();
    }
}

